/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.exec;

import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.exec.ExecBinding;
import org.apache.camel.component.exec.ExecCommandExecutor;
import org.apache.camel.component.exec.ExecEndpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class ExecEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ExecEndpoint target = (ExecEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "args": {
                target.setArgs(ExecEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "binding": {
                target.setBinding(ExecEndpointConfigurer.property(camelContext, ExecBinding.class, value));
                return true;
            }
            case "commandexecutor": 
            case "commandExecutor": {
                target.setCommandExecutor(ExecEndpointConfigurer.property(camelContext, ExecCommandExecutor.class, value));
                return true;
            }
            case "commandloglevel": 
            case "commandLogLevel": {
                target.setCommandLogLevel(ExecEndpointConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "exitvalues": 
            case "exitValues": {
                target.setExitValues(ExecEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(ExecEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "outfile": 
            case "outFile": {
                target.setOutFile(ExecEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "timeout": {
                target.setTimeout(ExecEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "usestderronemptystdout": 
            case "useStderrOnEmptyStdout": {
                target.setUseStderrOnEmptyStdout(ExecEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "workingdir": 
            case "workingDir": {
                target.setWorkingDir(ExecEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "args": {
                return String.class;
            }
            case "binding": {
                return ExecBinding.class;
            }
            case "commandexecutor": 
            case "commandExecutor": {
                return ExecCommandExecutor.class;
            }
            case "commandloglevel": 
            case "commandLogLevel": {
                return LoggingLevel.class;
            }
            case "exitvalues": 
            case "exitValues": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "outfile": 
            case "outFile": {
                return String.class;
            }
            case "timeout": {
                return Long.TYPE;
            }
            case "usestderronemptystdout": 
            case "useStderrOnEmptyStdout": {
                return Boolean.TYPE;
            }
            case "workingdir": 
            case "workingDir": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ExecEndpoint target = (ExecEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "args": {
                return target.getArgs();
            }
            case "binding": {
                return target.getBinding();
            }
            case "commandexecutor": 
            case "commandExecutor": {
                return target.getCommandExecutor();
            }
            case "commandloglevel": 
            case "commandLogLevel": {
                return target.getCommandLogLevel();
            }
            case "exitvalues": 
            case "exitValues": {
                return target.getExitValues();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "outfile": 
            case "outFile": {
                return target.getOutFile();
            }
            case "timeout": {
                return target.getTimeout();
            }
            case "usestderronemptystdout": 
            case "useStderrOnEmptyStdout": {
                return target.isUseStderrOnEmptyStdout();
            }
            case "workingdir": 
            case "workingDir": {
                return target.getWorkingDir();
            }
        }
        return null;
    }
}

