/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public interface ObjectReader<T> {
    public static final long HASH_TYPE = Fnv.hashCode64("@type");
    public static final String VALUE_NAME = "@value";

    default public T createInstance() {
        return this.createInstance(0L);
    }

    default public T createInstance(long features) {
        throw new UnsupportedOperationException();
    }

    default public T createInstance(Collection collection) {
        return this.createInstance(collection, 0L);
    }

    default public T createInstance(Collection collection, JSONReader.Feature ... features) {
        return this.createInstance(collection, JSONReader.Feature.of(features));
    }

    default public T createInstance(Collection collection, long features) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    default public void acceptExtra(Object object, String fieldName, Object fieldValue) {
        this.acceptExtra(object, fieldName, fieldValue, this.getFeatures());
    }

    default public void acceptExtra(Object object, String fieldName, Object fieldValue, long features) {
    }

    default public T createInstance(Map map, JSONReader.Feature ... features) {
        long featuresValue = 0L;
        for (int i = 0; i < features.length; ++i) {
            featuresValue |= features[i].mask;
        }
        return this.createInstance(map, featuresValue);
    }

    default public T createInstance(Map map, long features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Object typeKey = map.get(this.getTypeKey());
        if (typeKey instanceof String) {
            String typeName = (String)typeKey;
            long typeHash = Fnv.hashCode64(typeName);
            ObjectReader reader = null;
            if ((features & JSONReader.Feature.SupportAutoType.mask) != 0L || this instanceof ObjectReaderSeeAlso) {
                reader = this.autoType(provider, typeHash);
            }
            if (reader == null) {
                reader = provider.getObjectReader(typeName, this.getObjectClass(), features | this.getFeatures());
            }
            if (reader != this && reader != null) {
                return reader.createInstance(map, features);
            }
        }
        T object = this.createInstance(0L);
        return this.accept(object, map, features);
    }

    default public T accept(T object, Map map, long features) {
        for (Map.Entry entry : map.entrySet()) {
            String entryKey = entry.getKey().toString();
            Object fieldValue = entry.getValue();
            FieldReader fieldReader = this.getFieldReader(entryKey);
            if (fieldReader == null) {
                this.acceptExtra(object, entryKey, entry.getValue(), features);
                continue;
            }
            fieldReader.acceptAny(object, fieldValue, features);
        }
        Function buildFunction = this.getBuildFunction();
        return (T)(buildFunction != null ? buildFunction.apply(object) : object);
    }

    default public T createInstanceNoneDefaultConstructor(Map<Long, Object> values) {
        throw new UnsupportedOperationException();
    }

    default public long getFeatures() {
        return 0L;
    }

    default public String getTypeKey() {
        return "@type";
    }

    default public long getTypeKeyHash() {
        return HASH_TYPE;
    }

    default public Class<T> getObjectClass() {
        return null;
    }

    default public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    default public FieldReader getFieldReaderLCase(long hashCode) {
        return null;
    }

    default public boolean setFieldValue(Object object, String fieldName, long fieldNameHashCode, int value) {
        FieldReader fieldReader = this.getFieldReader(fieldNameHashCode);
        if (fieldReader == null) {
            return false;
        }
        fieldReader.accept(object, value);
        return true;
    }

    default public boolean setFieldValue(Object object, String fieldName, long fieldNameHashCode, long value) {
        FieldReader fieldReader = this.getFieldReader(fieldNameHashCode);
        if (fieldReader == null) {
            return false;
        }
        fieldReader.accept(object, value);
        return true;
    }

    default public FieldReader getFieldReader(String fieldName) {
        long fieldNameHashLCase;
        long fieldNameHash = Fnv.hashCode64(fieldName);
        FieldReader fieldReader = this.getFieldReader(fieldNameHash);
        if (fieldReader == null && (fieldNameHashLCase = Fnv.hashCode64LCase(fieldName)) != fieldNameHash) {
            fieldReader = this.getFieldReaderLCase(fieldNameHashLCase);
        }
        return fieldReader;
    }

    default public boolean setFieldValue(Object object, String fieldName, Object value) {
        FieldReader fieldReader = this.getFieldReader(fieldName);
        if (fieldReader == null) {
            return false;
        }
        fieldReader.accept(object, value);
        return true;
    }

    default public Function getBuildFunction() {
        return null;
    }

    default public ObjectReader autoType(JSONReader.Context context, long typeHash) {
        return context.getObjectReaderAutoType(typeHash);
    }

    default public ObjectReader autoType(ObjectReaderProvider provider, long typeHash) {
        return provider.getObjectReader(typeHash);
    }

    default public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray()) {
            return this.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        Object object = null;
        jsonReader.nextIfObjectStart();
        JSONReader.Context context = jsonReader.getContext();
        long features2 = context.getFeatures() | features;
        int i = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == this.getTypeKeyHash() && i == 0) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                ObjectReader reader = this.autoType(context, typeHash);
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException(jsonReader.info("No suitable ObjectReader found for " + typeName));
                }
                if (reader != this) {
                    return reader.readJSONBObject(jsonReader, fieldType, fieldName, features);
                }
            } else if (hash != 0L) {
                long nameHashCodeLCase;
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features2 | this.getFeatures()) && (nameHashCodeLCase = jsonReader.getNameHashCodeLCase()) != hash) {
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (fieldReader == null) {
                    jsonReader.skipValue();
                } else {
                    if (object == null) {
                        object = this.createInstance(features2);
                    }
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        return object != null ? object : (Object)this.createInstance(features2);
    }

    default public T readArrayMappingJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        throw new UnsupportedOperationException();
    }

    default public T readArrayMappingObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        throw new UnsupportedOperationException();
    }

    default public T readObject(String str, JSONReader.Feature ... features) {
        try (JSONReader jsonReader = JSONReader.of(str, JSONFactory.createReadContext(features));){
            T t = this.readObject(jsonReader, null, null, this.getFeatures());
            return t;
        }
    }

    default public T readObject(JSONReader jsonReader) {
        return this.readObject(jsonReader, null, null, this.getFeatures());
    }

    default public T readObject(JSONReader jsonReader, long features) {
        return this.readObject(jsonReader, null, null, features);
    }

    public T readObject(JSONReader var1, Type var2, Object var3, long var4);
}

