/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.retrofit;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class Retrofit2ConverterFactory
extends Converter.Factory {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
    private FastJsonConfig config;

    public Retrofit2ConverterFactory() {
        this.config = new FastJsonConfig();
    }

    public Retrofit2ConverterFactory(FastJsonConfig fastJsonConfig) {
        this.config = fastJsonConfig;
    }

    public static Retrofit2ConverterFactory create() {
        return Retrofit2ConverterFactory.create(new FastJsonConfig());
    }

    public static Retrofit2ConverterFactory create(FastJsonConfig fastJsonConfig) {
        if (fastJsonConfig == null) {
            throw new NullPointerException("fastJsonConfig == null");
        }
        return new Retrofit2ConverterFactory(fastJsonConfig);
    }

    public Converter<ResponseBody, Object> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        return new ResponseBodyConverter<Object>(type);
    }

    public Converter<Object, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        return new RequestBodyConverter<Object>();
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.config;
    }

    public Retrofit2ConverterFactory setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.config = fastJsonConfig;
        return this;
    }

    final class RequestBodyConverter<T>
    implements Converter<T, RequestBody> {
        RequestBodyConverter() {
        }

        public RequestBody convert(T value) throws IOException {
            try {
                byte[] content = Retrofit2ConverterFactory.this.config.isJSONB() ? JSONB.toBytes(value, Retrofit2ConverterFactory.this.config.getSymbolTable(), Retrofit2ConverterFactory.this.config.getWriterFilters(), Retrofit2ConverterFactory.this.config.getWriterFeatures()) : JSON.toJSONBytes(value, Retrofit2ConverterFactory.this.config.getDateFormat(), Retrofit2ConverterFactory.this.config.getWriterFilters(), Retrofit2ConverterFactory.this.config.getWriterFeatures());
                return RequestBody.create((MediaType)MEDIA_TYPE, (byte[])content);
            }
            catch (Exception e) {
                throw new IOException("Could not write JSON: " + e.getMessage(), e);
            }
        }
    }

    final class ResponseBodyConverter<T>
    implements Converter<ResponseBody, T> {
        private Type type;

        ResponseBodyConverter(Type type) {
            this.type = type;
        }

        public T convert(ResponseBody value) throws IOException {
            try {
                if (Retrofit2ConverterFactory.this.config.isJSONB()) {
                    Object t = JSONB.parseObject(value.bytes(), this.type, Retrofit2ConverterFactory.this.config.getSymbolTable(), Retrofit2ConverterFactory.this.config.getReaderFilters(), Retrofit2ConverterFactory.this.config.getReaderFeatures());
                    return t;
                }
                Object t = JSON.parseObject(value.bytes(), this.type, Retrofit2ConverterFactory.this.config.getDateFormat(), Retrofit2ConverterFactory.this.config.getReaderFilters(), Retrofit2ConverterFactory.this.config.getReaderFeatures());
                return t;
            }
            catch (Exception e) {
                throw new IOException("JSON parse error: " + e.getMessage(), e);
            }
            finally {
                value.close();
            }
        }
    }
}

