/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.watch;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryChangeListener;
import io.methvin.watcher.DirectoryWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.watch.FileWatchEndpoint;
import org.apache.camel.component.file.watch.constants.FileEvent;
import org.apache.camel.component.file.watch.constants.FileEventEnum;
import org.apache.camel.component.file.watch.utils.PathUtils;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.AntPathMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatchConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatchConsumer.class);
    private final Set<FileEventEnum> events = new HashSet<FileEventEnum>();
    private ExecutorService watchDirExecutorService;
    private ExecutorService pollExecutorService;
    private LinkedBlockingQueue<FileEvent> eventQueue = this.getEndpoint().getQueueSize() <= 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(this.getEndpoint().getQueueSize());
    private Path baseDirectory;
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private DirectoryWatcher watcher;

    public FileWatchConsumer(FileWatchEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.baseDirectory = Paths.get(this.getEndpoint().getPath(), new String[0]).toAbsolutePath();
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        for (String event : this.getEndpoint().getEvents().split(",")) {
            FileEventEnum fe = FileEventEnum.valueOf(event);
            this.events.add(fe);
        }
    }

    @Override
    protected void doStart() throws Exception {
        int i;
        super.doStart();
        if (!Files.exists(this.baseDirectory, new LinkOption[0])) {
            if (this.getEndpoint().isAutoCreate()) {
                this.baseDirectory = Files.createDirectories(this.baseDirectory, new FileAttribute[0]);
            } else {
                throw new IllegalArgumentException("Path must exists when autoCreate = false");
            }
        }
        if (!Files.isDirectory(this.baseDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Parameter path must be directory, %s given", this.baseDirectory.toString()));
        }
        DirectoryWatcher.Builder watcherBuilder = DirectoryWatcher.builder().path(this.baseDirectory).logger(LOG).listener(new FileWatchDirectoryChangeListener());
        if (!System.getProperty("os.name").toLowerCase().contains("mac")) {
            watcherBuilder.watchService(this.baseDirectory.getFileSystem().newWatchService());
        }
        watcherBuilder.fileHashing(this.getEndpoint().isUseFileHashing());
        if (this.getEndpoint().getFileHasher() != null && this.getEndpoint().isUseFileHashing()) {
            watcherBuilder.fileHasher(this.getEndpoint().getFileHasher());
        }
        this.watcher = watcherBuilder.build();
        this.watchDirExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool(this, "CamelFileWatchService", this.getEndpoint().getPollThreads());
        this.pollExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool(this, "CamelFileWatchPoll", this.getEndpoint().getConcurrentConsumers());
        for (i = 0; i < this.getEndpoint().getPollThreads(); ++i) {
            this.watcher.watchAsync(this.watchDirExecutorService);
        }
        for (i = 0; i < this.getEndpoint().getConcurrentConsumers(); ++i) {
            this.pollExecutorService.submit(new PollRunnable());
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.watcher != null) {
            this.watcher.close();
        }
        if (this.watchDirExecutorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.watchDirExecutorService);
        }
        if (this.pollExecutorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.pollExecutorService);
        }
        super.doStop();
    }

    @Override
    protected void doSuspend() throws Exception {
        this.doStop();
    }

    @Override
    protected void doResume() throws Exception {
        this.doStart();
    }

    private Exchange prepareExchange(FileEvent event) {
        Exchange exchange = this.createExchange(true);
        File file = event.getEventPath().toFile();
        Message message = exchange.getIn();
        message.setBody(file);
        message.setHeader("CamelFileEventType", event.getEventType().name());
        message.setHeader("CamelFileNameOnly", event.getEventPath().getFileName().toString());
        message.setHeader("CamelFileAbsolute", true);
        String absolutePath = PathUtils.normalizeToString(event.getEventPath().toAbsolutePath());
        message.setHeader("CamelFileAbsolutePath", absolutePath);
        message.setHeader("CamelFilePath", absolutePath);
        String relativePath = PathUtils.normalizeToString(this.baseDirectory.relativize(event.getEventPath()));
        message.setHeader("CamelFileName", relativePath);
        message.setHeader("CamelFileRelativePath", relativePath);
        message.setHeader("CamelFileNameConsumed", relativePath);
        message.setHeader("CamelFileParent", PathUtils.normalizeToString(event.getEventPath().getParent().toAbsolutePath()));
        message.setHeader("CamelFileLastModified", event.getEventDate());
        message.setHeader("CamelMessageTimestamp", event.getEventDate());
        return exchange;
    }

    private boolean matchFilters(FileEvent fileEvent) {
        String pattern;
        if (!this.events.isEmpty() && !this.events.contains((Object)fileEvent.getEventType())) {
            return false;
        }
        if (!this.getEndpoint().isRecursive()) {
            try {
                if (!Files.isSameFile(fileEvent.getEventPath().getParent(), this.baseDirectory)) {
                    return false;
                }
            }
            catch (IOException e) {
                LOG.warn(String.format("Exception occurred during executing filter. Filtering file %s out.", fileEvent.getEventPath()), (Throwable)e);
                return false;
            }
        }
        if ((pattern = this.getEndpoint().getAntInclude()) == null || pattern.isBlank()) {
            return true;
        }
        return this.antPathMatcher.match(this.getEndpoint().getAntInclude(), PathUtils.normalizeToString(this.baseDirectory.relativize(fileEvent.getEventPath())));
    }

    @Override
    public FileWatchEndpoint getEndpoint() {
        return (FileWatchEndpoint)super.getEndpoint();
    }

    class FileWatchDirectoryChangeListener
    implements DirectoryChangeListener {
        FileWatchDirectoryChangeListener() {
        }

        @Override
        public void onEvent(DirectoryChangeEvent directoryChangeEvent) {
            if (directoryChangeEvent.eventType() == DirectoryChangeEvent.EventType.OVERFLOW) {
                LOG.warn("OVERFLOW occurred, some events may be lost. Consider increasing of option 'pollThreads'");
                return;
            }
            FileEvent fileEvent = new FileEvent(directoryChangeEvent);
            if (FileWatchConsumer.this.matchFilters(fileEvent)) {
                FileWatchConsumer.this.eventQueue.offer(fileEvent);
            }
        }

        @Override
        public boolean isWatching() {
            return !FileWatchConsumer.this.isStoppingOrStopped() && !FileWatchConsumer.this.isSuspendingOrSuspended();
        }

        @Override
        public void onException(Exception e) {
            FileWatchConsumer.this.handleException(e);
        }
    }

    class PollRunnable
    implements Runnable {
        PollRunnable() {
        }

        @Override
        public void run() {
            while (!FileWatchConsumer.this.isStoppingOrStopped() && !FileWatchConsumer.this.isSuspendingOrSuspended()) {
                FileEvent event;
                try {
                    event = FileWatchConsumer.this.eventQueue.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (event == null) continue;
                try {
                    Exchange exchange = FileWatchConsumer.this.prepareExchange(event);
                    FileWatchConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception t) {
                    FileWatchConsumer.this.handleException(t);
                }
            }
        }
    }
}

