/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.brparse;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultDataSet;
import net.sf.flatpack.DelimiterParser;
import net.sf.flatpack.brparse.BuffReaderDataSet;
import net.sf.flatpack.brparse.InterfaceBuffReaderParse;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.FPException;
import net.sf.flatpack.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuffReaderDelimParser
extends DelimiterParser
implements InterfaceBuffReaderParse {
    private BufferedReader br;
    private boolean processedFirst = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(BuffReaderDelimParser.class);

    public BuffReaderDelimParser(File pzmapXML, File dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(pzmapXML, dataSource, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(InputStream pzmapXMLStream, InputStream dataSourceStream, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(pzmapXMLStream, dataSourceStream, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(File dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSource, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(InputStream dataSourceStream, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceStream, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(Reader pzmapXML, Reader dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSource, pzmapXML, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(Reader dataSourceStream, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceStream, delimiter, qualifier, ignoreFirstRecord);
    }

    @Override
    protected DataSet doParse() {
        BuffReaderDataSet ds = new BuffReaderDataSet(this.getPzMetaData(), this);
        try {
            ds.setPZConvertProps(ParserUtils.loadConvertProperties());
            this.br = new BufferedReader(this.getDataSourceReader());
            return ds;
        }
        catch (IOException ex) {
            LOGGER.error("error accessing/creating inputstream", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Row buildRow(DefaultDataSet ds) {
        String mdkey;
        List<ColumnMetaData> cmds;
        List<String> columns;
        String line;
        do {
            try {
                line = this.fetchNextRecord(this.br, this.getQualifier(), this.getDelimiter());
            }
            catch (IOException e) {
                throw new FPException("Error Fetching Record From File...", e);
            }
            if (line != null) continue;
            return null;
        } while (this.shouldSkipFirstRecord(line, ds) || !this.validateColumns(ds, columns = ParserUtils.splitLine(line, this.getDelimiter(), this.getQualifier(), 10, this.isPreserveLeadingWhitespace(), this.isPreserveTrailingWhitespace()), cmds = ParserUtils.getColumnMetaData(mdkey = ParserUtils.getCMDKeyForDelimitedFile(this.getPzMetaData(), columns), this.getPzMetaData()), line));
        return this.createRow(line, columns, mdkey);
    }

    private boolean shouldSkipFirstRecord(String line, DefaultDataSet ds) {
        if (!this.processedFirst && this.isIgnoreFirstRecord()) {
            this.processedFirst = true;
            return true;
        }
        if (!this.processedFirst && this.shouldCreateMDFromFile()) {
            this.processedFirst = true;
            this.setPzMetaData(ParserUtils.getPZMetaDataFromFile(line, this.getDelimiter(), this.getQualifier(), this, this.isAddSuffixToDuplicateColumnNames()));
            ds.setMetaData(this.getPzMetaData());
            return true;
        }
        return false;
    }

    private Row createRow(String line, List<String> columns, String mdkey) {
        Row row = new Row();
        row.setMdkey(mdkey.equals("detail") ? null : mdkey);
        row.setCols(columns);
        row.setRowNumber(this.getLineCount());
        if (this.isFlagEmptyRows()) {
            row.setEmpty(ParserUtils.isListElementsEmpty(columns));
        }
        if (this.isStoreRawDataToDataSet()) {
            row.setRawData(line);
        }
        return row;
    }

    private boolean validateColumns(DefaultDataSet ds, List<String> columns, List<ColumnMetaData> cmds, String line) {
        int columnCount = cmds.size();
        if (columns.size() > columnCount) {
            return this.handleTooManyColumns(ds, columns, line, columnCount);
        }
        if (columns.size() < columnCount) {
            return this.handleTooFewColumns(ds, columns, line, columnCount, cmds);
        }
        return true;
    }

    private boolean handleTooFewColumns(DefaultDataSet ds, List<String> columns, String line, int columnCount, List<ColumnMetaData> colTitles) {
        if (this.isHandlingShortLines()) {
            while (columns.size() < columnCount) {
                columns.add("");
            }
            this.addError(ds, "Padded line to correct number of columns", this.getLineCount(), 1, this.isStoreRawDataToDataError() ? line : null);
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Too few columns expected size: ").append(columnCount).append(" Actual size: ").append(columns.size());
        String lastColumnName = colTitles != null && !colTitles.isEmpty() && !columns.isEmpty() ? colTitles.get(columns.size() - 1).getColName() : null;
        String lastColumnValue = columns != null && !columns.isEmpty() ? columns.get(columns.size() - 1) : null;
        this.addError(ds, sb.toString(), this.getLineCount(), 2, this.isStoreRawDataToDataError() ? line : null, lastColumnName, lastColumnValue);
        return false;
    }

    private boolean handleTooManyColumns(DefaultDataSet ds, List<String> columns, String line, int columnCount) {
        if (this.isIgnoreExtraColumns()) {
            columns.retainAll(columns.subList(0, columnCount));
            this.addError(ds, "TRUNCATED LINE TO CORRECT NUMBER OF COLUMNS", this.getLineCount(), 1, this.isStoreRawDataToDataError() ? line : null);
            return true;
        }
        this.addError(ds, "Too many columns expected size: " + columnCount + " Actual size: " + columns.size(), this.getLineCount(), 2, this.isStoreRawDataToDataError() ? line : null);
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.br != null) {
            this.br.close();
            this.br = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Problem trying to auto close file handles...", (Throwable)ex);
        }
        finally {
            super.finalize();
        }
    }
}

