/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.brparse;

import java.io.FileNotFoundException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import net.sf.flatpack.InitialisationException;
import net.sf.flatpack.brparse.BuffReaderFixedParser;
import net.sf.flatpack.brparse.InterfaceBuffReaderParse;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.util.ParserUtils;

public class DBBuffReaderFixedParser
extends BuffReaderFixedParser
implements InterfaceBuffReaderParse {
    private final Connection con;

    public DBBuffReaderFixedParser(Connection con, Reader dataSourceReader, String dataDefinition) {
        super(dataSourceReader, dataDefinition);
        this.con = con;
    }

    @Override
    protected void init() {
        try {
            List<ColumnMetaData> cmds = ParserUtils.buildMDFromSQLTable(this.con, this.getDataDefinition(), this);
            this.addToMetaData(cmds);
            if (cmds.isEmpty()) {
                throw new FileNotFoundException("DATA DEFINITION CAN NOT BE FOUND IN THE DATABASE " + this.getDataDefinition());
            }
            this.setInitialised(true);
        }
        catch (FileNotFoundException | SQLException e) {
            throw new InitialisationException(e);
        }
    }

    protected boolean shouldCreateMDFromFile() {
        return false;
    }
}

