/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.writer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.flatpack.writer.Writer;

public abstract class AbstractWriter
implements Writer {
    private final BufferedWriter writer;
    private Map<String, Object> rowMap;
    protected String lineSeparator = System.lineSeparator();

    public AbstractWriter(java.io.Writer output) {
        this.writer = new BufferedWriter(output);
    }

    public AbstractWriter(java.io.Writer writer, String lineSeparator) {
        this.writer = new BufferedWriter(writer);
        this.lineSeparator = lineSeparator;
    }

    @Override
    public Writer addRecordEntry(String columnName, Object value) {
        if (this.rowMap == null) {
            this.rowMap = new HashMap<String, Object>();
        }
        if (!this.validateColumnTitle(columnName)) {
            throw new IllegalArgumentException("unknown column: \"" + columnName + "\"");
        }
        this.rowMap.put(columnName, value);
        return this;
    }

    protected abstract boolean validateColumnTitle(String var1);

    @Override
    public Writer nextRecord() throws IOException {
        this.rowMap = null;
        this.writer.write(this.lineSeparator);
        return this;
    }

    protected void write(Object val2) throws IOException {
        Object value = val2 == null ? "" : val2;
        this.writer.write(value.toString());
    }

    protected void write(char character) throws IOException {
        this.writer.write(character);
    }

    protected void write(char[] characters) throws IOException {
        this.writer.write(characters);
    }

    @Override
    public Writer flush() throws IOException {
        this.writer.flush();
        return this;
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected Map<String, Object> getRowMap() {
        return this.rowMap;
    }
}

