/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupStep;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.ContractAdvice;
import org.apache.camel.processor.RoutePipeline;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.reifier.rest.RestBindingReifier;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.Contract;
import org.apache.camel.spi.ErrorHandlerAware;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteReifier
extends ProcessorReifier<RouteDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(RouteReifier.class);
    private static final String[] RESERVED_PROPERTIES = new String[]{"id", "customId", "parent", "description", "group", "nodePrefixId", "rest", "configurationId"};

    public RouteReifier(CamelContext camelContext, ProcessorDefinition<?> definition) {
        super(camelContext, (RouteDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        throw new UnsupportedOperationException("Not implemented for RouteDefinition");
    }

    public Route createRoute() {
        try {
            return this.doCreateRoute();
        }
        catch (FailedToCreateRouteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), e);
        }
    }

    protected Route doCreateRoute() throws Exception {
        List<RoutePolicy> routePolicyList;
        Long delayer;
        Boolean isStreamCache;
        Boolean isLogMask;
        Boolean isMessageHistory;
        Boolean isTrace;
        Endpoint endpoint = ((RouteDefinition)this.definition).getInput().getEndpoint();
        if (endpoint == null) {
            EndpointConsumerBuilder def = ((RouteDefinition)this.definition).getInput().getEndpointConsumerBuilder();
            endpoint = def != null ? def.resolve(this.camelContext) : this.resolveEndpoint(((RouteDefinition)this.definition).getInput().getEndpointUri());
        }
        String id = ((RouteDefinition)this.definition).idOrCreate(this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class));
        String desc = ((RouteDefinition)this.definition).getDescriptionText();
        Route route = PluginHelper.getRouteFactory(this.camelContext).createRoute(this.camelContext, this.definition, id, desc, endpoint, ((RouteDefinition)this.definition).getResource());
        route.setErrorHandlerFactory(((RouteDefinition)this.definition).getErrorHandlerFactory());
        String variable = this.parseString(((RouteDefinition)this.definition).getInput().getVariableReceive());
        if (variable != null) {
            route.setAllowUseOriginalMessage(true);
        }
        if (((RouteDefinition)this.definition).getTrace() != null && (isTrace = this.parseBoolean(((RouteDefinition)this.definition).getTrace())) != null) {
            route.setTracing(isTrace);
            if (isTrace.booleanValue()) {
                LOG.debug("Tracing is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getMessageHistory() != null && (isMessageHistory = this.parseBoolean(((RouteDefinition)this.definition).getMessageHistory())) != null) {
            route.setMessageHistory(isMessageHistory);
            if (isMessageHistory.booleanValue()) {
                LOG.debug("Message history is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getLogMask() != null && (isLogMask = this.parseBoolean(((RouteDefinition)this.definition).getLogMask())) != null) {
            route.setLogMask(isLogMask);
            if (isLogMask.booleanValue()) {
                LOG.debug("Security mask for Logging is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getStreamCache() != null && (isStreamCache = this.parseBoolean(((RouteDefinition)this.definition).getStreamCache())) != null) {
            route.setStreamCaching(isStreamCache);
            if (isStreamCache.booleanValue()) {
                LOG.debug("StreamCaching is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getDelayer() != null && (delayer = this.parseDuration(((RouteDefinition)this.definition).getDelayer())) != null) {
            route.setDelayer(delayer);
            if (delayer > 0L) {
                LOG.debug("Delayer is enabled with: {} ms. on route: {}", (Object)delayer, (Object)((RouteDefinition)this.definition).getId());
            } else {
                LOG.debug("Delayer is disabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        Boolean isAutoStartup = this.parseBoolean(((RouteDefinition)this.definition).getAutoStartup());
        Integer startupOrder = ((RouteDefinition)this.definition).getStartupOrder();
        if (((RouteDefinition)this.definition).getShutdownRoute() != null) {
            LOG.debug("Using ShutdownRoute {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRoute(), (Object)((RouteDefinition)this.definition).getId());
            route.setShutdownRoute(this.parse(ShutdownRoute.class, ((RouteDefinition)this.definition).getShutdownRoute()));
        }
        if (((RouteDefinition)this.definition).getShutdownRunningTask() != null) {
            LOG.debug("Using ShutdownRunningTask {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRunningTask(), (Object)((RouteDefinition)this.definition).getId());
            route.setShutdownRunningTask(this.parse(ShutdownRunningTask.class, ((RouteDefinition)this.definition).getShutdownRunningTask()));
        }
        route.getInterceptStrategies().addAll(((RouteDefinition)this.definition).getInterceptStrategies());
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            strategy.onRouteContextCreate(route);
        }
        if (!this.hasOutputs(((RouteDefinition)this.definition).getOutputs(), true)) {
            String at = ((RouteDefinition)this.definition).getInput().toString();
            IllegalArgumentException cause = new IllegalArgumentException("Route " + ((RouteDefinition)this.definition).getId() + " has no output processors. You need to add outputs to the route such as to(\"log:foo\").");
            throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), at, cause);
        }
        ArrayList list = new ArrayList(((RouteDefinition)this.definition).getOutputs());
        for (ProcessorDefinition processorDefinition : list) {
            try {
                ProcessorReifier<ProcessorDefinition<?>> reifier = ProcessorReifier.reifier(route, processorDefinition);
                String outputId = processorDefinition.idOrCreate(this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class));
                String eip = reifier.getClass().getSimpleName().replace("Reifier", "");
                StartupStep startupStep = this.camelContext.getCamelContextExtension().getStartupStepRecorder().beginStep(ProcessorReifier.class, outputId, "Create " + (String)eip + " Processor");
                reifier.addRoutes();
                this.camelContext.getCamelContextExtension().getStartupStepRecorder().endStep(startupStep);
            }
            catch (Exception e) {
                throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), processorDefinition.toString(), e);
            }
        }
        List<Processor> eventDrivenProcessors = route.getEventDrivenProcessors();
        if (eventDrivenProcessors.isEmpty()) {
            return null;
        }
        Map<String, Object> map = this.computeRouteProperties();
        RoutePipeline target = new RoutePipeline(this.camelContext, eventDrivenProcessors);
        target.setRouteId(id);
        InternalProcessor internal = PluginHelper.getInternalProcessorFactory(this.camelContext).addUnitOfWorkProcessorAdvice(this.camelContext, target, route);
        if (((RouteDefinition)this.definition).getRoutePolicies() != null && !((RouteDefinition)this.definition).getRoutePolicies().isEmpty()) {
            for (RoutePolicy routePolicy : ((RouteDefinition)this.definition).getRoutePolicies()) {
                LOG.debug("RoutePolicy is enabled: {} on route: {}", (Object)routePolicy, (Object)((RouteDefinition)this.definition).getId());
                route.getRoutePolicyList().add(routePolicy);
            }
        }
        if (((RouteDefinition)this.definition).getRoutePolicyRef() != null) {
            StringTokenizer policyTokens = new StringTokenizer(((RouteDefinition)this.definition).getRoutePolicyRef(), ",");
            while (policyTokens.hasMoreTokens()) {
                String string = policyTokens.nextToken().trim();
                RoutePolicy policy3 = this.mandatoryLookup(string, RoutePolicy.class);
                LOG.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy3, (Object)((RouteDefinition)this.definition).getId());
                route.getRoutePolicyList().add(policy3);
            }
        }
        if (this.camelContext.getRoutePolicyFactories() != null) {
            for (RoutePolicyFactory routePolicyFactory : this.camelContext.getRoutePolicyFactories()) {
                RoutePolicy policy = routePolicyFactory.createRoutePolicy(this.camelContext, ((RouteDefinition)this.definition).getId(), this.definition);
                if (policy == null) continue;
                LOG.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy, (Object)((RouteDefinition)this.definition).getId());
                route.getRoutePolicyList().add(policy);
            }
        }
        if ((routePolicyList = route.getRoutePolicyList()) != null && !routePolicyList.isEmpty()) {
            for (RoutePolicy policy : routePolicyList) {
                if (this.camelContext.hasService(policy)) continue;
                try {
                    if (policy instanceof RouteAware) {
                        RouteAware ra = (RouteAware)((Object)policy);
                        ra.setRoute(route);
                    }
                    this.camelContext.addService(policy);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(e);
                }
            }
            internal.addRoutePolicyAdvice(routePolicyList);
        }
        internal.addRouteInflightRepositoryAdvice(this.camelContext.getInflightRepository(), route.getRouteId());
        ManagementInterceptStrategy managementInterceptStrategy = route.getManagementInterceptStrategy();
        if (managementInterceptStrategy != null) {
            internal.addManagementInterceptStrategy(managementInterceptStrategy.createProcessor("route"));
        }
        internal.addRouteLifecycleAdvice();
        if (((RouteDefinition)this.definition).getRestBindingDefinition() != null) {
            try {
                internal.addAdvice(new RestBindingReifier(route, ((RouteDefinition)this.definition).getRestBindingDefinition()).createRestBindingAdvice());
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
        if (((RouteDefinition)this.definition).getInputType() != null || ((RouteDefinition)this.definition).getOutputType() != null) {
            Contract contract = new Contract();
            if (((RouteDefinition)this.definition).getInputType() != null) {
                contract.setInputType(this.parseString(((RouteDefinition)this.definition).getInputType().getUrn()));
                contract.setValidateInput(this.parseBoolean(((RouteDefinition)this.definition).getInputType().getValidate(), false));
            }
            if (((RouteDefinition)this.definition).getOutputType() != null) {
                contract.setOutputType(this.parseString(((RouteDefinition)this.definition).getOutputType().getUrn()));
                contract.setValidateOutput(this.parseBoolean(((RouteDefinition)this.definition).getOutputType().getValidate(), false));
            }
            internal.addAdvice(new ContractAdvice(contract));
            this.camelContext.setUseDataType(true);
        }
        if (variable != null) {
            internal.addAdvice(new VariableAdvice(variable));
        }
        route.setProcessor(internal);
        route.getProperties().putAll(map);
        route.setStartupOrder(startupOrder);
        if (isAutoStartup != null) {
            LOG.debug("Using AutoStartup {} on route: {}", (Object)isAutoStartup, (Object)((RouteDefinition)this.definition).getId());
            route.setAutoStartup(isAutoStartup);
        }
        internal.setRouteOnAdvices(route);
        if (routePolicyList != null && !routePolicyList.isEmpty()) {
            for (RoutePolicy policy4 : routePolicyList) {
                policy4.onInit(route);
            }
        }
        ErrorHandlerFactory builder = route.getErrorHandlerFactory();
        Processor errorHandler = ((ModelCamelContext)this.camelContext).getModelReifierFactory().createErrorHandler(route, builder, null);
        this.prepareErrorHandlerAware(route, errorHandler);
        if (this.camelContext.getStatus().ordinal() < ServiceStatus.Started.ordinal()) {
            this.camelContext.getCamelContextExtension().addBootstrap(route::clearRouteModel);
        }
        if (((RouteDefinition)this.definition).getRouteTemplateContext() != null) {
            ServiceSupport wrapper = new ServiceSupport(){

                @Override
                protected void doStop() throws Exception {
                    this.close();
                }

                @Override
                public void close() throws IOException {
                    BeanRepository repo = ((RouteDefinition)RouteReifier.this.definition).getRouteTemplateContext().getLocalBeanRepository();
                    if (repo instanceof Closeable) {
                        Closeable obj = (Closeable)((Object)repo);
                        IOHelper.close(obj);
                    }
                    super.close();
                }
            };
            route.addService(wrapper, true);
        }
        return route;
    }

    private void prepareErrorHandlerAware(Route route, Processor errorHandler) {
        List<Processor> processors = route.filter("*");
        for (Processor p : processors) {
            if (!(p instanceof ErrorHandlerAware)) continue;
            ErrorHandlerAware errorHandlerAware = (ErrorHandlerAware)((Object)p);
            errorHandlerAware.setErrorHandler(errorHandler);
        }
    }

    protected Map<String, Object> computeRouteProperties() {
        List<PropertyDefinition> properties;
        HashMap<String, Object> routeProperties = new HashMap<String, Object>();
        routeProperties.put("id", ((RouteDefinition)this.definition).getId());
        routeProperties.put("customId", Boolean.toString(((RouteDefinition)this.definition).hasCustomIdAssigned()));
        routeProperties.put("parent", Integer.toHexString(((RouteDefinition)this.definition).hashCode()));
        routeProperties.put("description", ((RouteDefinition)this.definition).getDescriptionText());
        if (((RouteDefinition)this.definition).getGroup() != null) {
            routeProperties.put("group", ((RouteDefinition)this.definition).getGroup());
        }
        if (((RouteDefinition)this.definition).getNodePrefixId() != null) {
            routeProperties.put("nodePrefixId", ((RouteDefinition)this.definition).getNodePrefixId());
        }
        String rest = Boolean.toString(((RouteDefinition)this.definition).isRest() != null && ((RouteDefinition)this.definition).isRest() != false);
        routeProperties.put("rest", rest);
        String template = Boolean.toString(((RouteDefinition)this.definition).isTemplate() != null && ((RouteDefinition)this.definition).isTemplate() != false);
        routeProperties.put("template", template);
        String kamelet = Boolean.toString(((RouteDefinition)this.definition).isKamelet() != null && ((RouteDefinition)this.definition).isKamelet() != false);
        routeProperties.put("kamelet", kamelet);
        if (((RouteDefinition)this.definition).getAppliedRouteConfigurationIds() != null) {
            routeProperties.put("configurationId", String.join((CharSequence)",", ((RouteDefinition)this.definition).getAppliedRouteConfigurationIds()));
        }
        if ((properties = ((RouteDefinition)this.definition).getRouteProperties()) != null) {
            for (PropertyDefinition prop : properties) {
                try {
                    String key = this.parseString(prop.getKey());
                    String val2 = this.parseString(prop.getValue());
                    for (String property : RESERVED_PROPERTIES) {
                        if (!property.equalsIgnoreCase(key)) continue;
                        throw new IllegalArgumentException("Cannot set route property " + property + " as it is a reserved property");
                    }
                    routeProperties.put(key, val2);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(e);
                }
            }
        }
        return routeProperties;
    }

    private static class VariableAdvice
    implements CamelInternalProcessorAdvice<Object> {
        private final String name;

        public VariableAdvice(String name) {
            this.name = name;
        }

        @Override
        public Object before(Exchange exchange) throws Exception {
            ExchangeHelper.setVariableFromMessageBodyAndHeaders(exchange, this.name, exchange.getMessage());
            exchange.getMessage().setBody(null);
            return null;
        }

        @Override
        public void after(Exchange exchange, Object data) throws Exception {
        }

        @Override
        public boolean hasState() {
            return false;
        }
    }
}

