/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fop;

import java.io.InputStream;
import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.fop.FopComponent;
import org.apache.camel.component.fop.FopConfigException;
import org.apache.camel.component.fop.FopConstants;
import org.apache.camel.component.fop.FopOutputType;
import org.apache.camel.component.fop.FopProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.fop.apps.FopFactory;

@UriEndpoint(firstVersion="2.10.0", scheme="fop", title="FOP", syntax="fop:outputType", producerOnly=true, remote=false, category={Category.FILE, Category.TRANSFORMATION}, headersClass=FopConstants.class)
public class FopEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private FopOutputType outputType;
    @UriParam
    @Metadata(supportFileReference=true)
    private String userConfigURL;
    @UriParam
    private FopFactory fopFactory;

    public FopEndpoint(String uri, FopComponent component, FopOutputType outputType) {
        super(uri, component);
        this.outputType = outputType;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new FopProducer(this, this.fopFactory, this.outputType.getFormatExtended());
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for FOP endpoint");
    }

    public FopOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(FopOutputType outputType) {
        this.outputType = outputType;
    }

    public String getUserConfigURL() {
        return this.userConfigURL;
    }

    public void setUserConfigURL(String userConfigURL) {
        this.userConfigURL = userConfigURL;
    }

    public FopFactory getFopFactory() {
        return this.fopFactory;
    }

    public void setFopFactory(FopFactory fopFactory) {
        this.fopFactory = fopFactory;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.fopFactory == null && this.userConfigURL == null) {
            this.fopFactory = FopFactory.newInstance(new URI("./"));
        } else {
            if (this.fopFactory != null && this.userConfigURL != null) {
                throw new FopConfigException("More than one configuration. You can configure fop either by config file or by supplying FopFactory but not both.");
            }
            if (this.fopFactory == null && this.userConfigURL != null && ResourceHelper.isClasspathUri(this.userConfigURL)) {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext(), this.userConfigURL);
                this.fopFactory = FopFactory.newInstance(new URI(this.userConfigURL), is);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.fopFactory == null && this.userConfigURL != null && !ResourceHelper.isClasspathUri(this.userConfigURL)) {
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext(), this.userConfigURL);
            this.fopFactory = FopFactory.newInstance(new URI(this.userConfigURL), is);
        }
    }
}

