/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.SVGGlyphData;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.ImageHandlerRegistry;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.w3c.dom.Document;

public abstract class AbstractIFPainter<T extends IFDocumentHandler>
implements IFPainter {
    private static Log log = LogFactory.getLog(AbstractIFPainter.class);
    protected static final String INSTREAM_OBJECT_URI = "(instream-object)";
    protected IFState state;
    private final T documentHandler;

    public AbstractIFPainter(T documentHandler) {
        this.documentHandler = documentHandler;
    }

    protected String getFontKey(FontTriplet triplet) throws IFException {
        String key = this.getFontInfo().getInternalFontKey(triplet);
        if (key == null) {
            throw new IFException("The font triplet is not available: \"" + triplet + "\" for the MIME type: \"" + this.documentHandler.getMimeType() + "\"");
        }
        return key;
    }

    public IFContext getContext() {
        return this.documentHandler.getContext();
    }

    protected FontInfo getFontInfo() {
        return this.documentHandler.getFontInfo();
    }

    protected T getDocumentHandler() {
        return this.documentHandler;
    }

    protected FOUserAgent getUserAgent() {
        return this.getContext().getUserAgent();
    }

    private AffineTransform combine(AffineTransform[] transforms) {
        AffineTransform at = new AffineTransform();
        for (AffineTransform transform : transforms) {
            at.concatenate(transform);
        }
        return at;
    }

    @Override
    public void startViewport(AffineTransform[] transforms, Dimension size, Rectangle clipRect) throws IFException {
        this.startViewport(this.combine(transforms), size, clipRect);
    }

    @Override
    public void startGroup(AffineTransform[] transforms, String layer) throws IFException {
        this.startGroup(this.combine(transforms), layer);
    }

    protected abstract RenderingContext createRenderingContext();

    protected void drawImageUsingImageHandler(ImageInfo info, Rectangle rect) throws ImageException, IOException {
        ImageManager manager = this.getUserAgent().getImageManager();
        ImageSessionContext sessionContext = this.getUserAgent().getImageSessionContext();
        ImageHandlerRegistry imageHandlerRegistry = this.getUserAgent().getImageHandlerRegistry();
        RenderingContext context = this.createRenderingContext();
        Map hints = this.createDefaultImageProcessingHints(sessionContext);
        context.putHints(hints);
        ImageFlavor[] flavors = imageHandlerRegistry.getSupportedFlavors(context);
        info.getCustomObjects().put("warningincustomobject", true);
        Image img = manager.getImage(info, flavors, hints, sessionContext);
        if (info.getCustomObjects().get("warning") != null) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageWarning(this, (String)info.getCustomObjects().get("warning"));
        }
        try {
            this.drawImage(img, rect, context);
        }
        catch (PDFConformanceException e) {
            throw e;
        }
        catch (Exception e) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageWritingError(this, e);
        }
    }

    protected Map createDefaultImageProcessingHints(ImageSessionContext sessionContext) {
        Map hints = ImageUtil.getDefaultHints(sessionContext);
        Object conversionMode = this.getContext().getForeignAttribute(ImageHandlerUtil.CONVERSION_MODE);
        if (conversionMode != null) {
            hints.put(ImageHandlerUtil.CONVERSION_MODE, conversionMode);
        }
        hints.put("page-number", this.documentHandler.getContext().getPageNumber());
        return hints;
    }

    protected void drawImage(Image image, Rectangle rect, RenderingContext context) throws IOException, ImageException {
        this.drawImage(image, rect, context, false, null);
    }

    protected void drawImage(Image image, Rectangle rect, RenderingContext context, boolean convert, Map additionalHints) throws IOException, ImageException {
        Image effImage;
        ImageManager manager = this.getUserAgent().getImageManager();
        ImageHandlerRegistry imageHandlerRegistry = this.getUserAgent().getImageHandlerRegistry();
        context.putHints(additionalHints);
        if (convert) {
            Map hints = this.createDefaultImageProcessingHints(this.getUserAgent().getImageSessionContext());
            if (additionalHints != null) {
                hints.putAll(additionalHints);
            }
            effImage = manager.convertImage(image, imageHandlerRegistry.getSupportedFlavors(context), hints);
        } else {
            effImage = image;
        }
        ImageHandler handler = imageHandlerRegistry.getHandler(context, effImage);
        if (handler == null) {
            throw new UnsupportedOperationException("No ImageHandler available for image: " + effImage.getInfo() + " (" + effImage.getClass().getName() + ")");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Using ImageHandler: " + handler.getClass().getName()));
        }
        context.putHint("fontinfo", this.getFontInfo());
        handler.handleImage(context, effImage, rect);
    }

    protected ImageInfo getImageInfo(String uri) {
        ImageManager manager = this.getUserAgent().getImageManager();
        try {
            ImageSessionContext sessionContext = this.getUserAgent().getImageSessionContext();
            return manager.getImageInfo(uri, sessionContext);
        }
        catch (ImageException ie) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageError(this, uri, ie, null);
        }
        catch (FileNotFoundException fe) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageNotFound(this, uri, fe, null);
        }
        catch (IOException ioe) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageIOError(this, uri, ioe, null);
        }
        return null;
    }

    protected void drawImageUsingURI(String uri, Rectangle rect) {
        ImageManager manager = this.getUserAgent().getImageManager();
        ImageInfo info = null;
        try {
            ImageSessionContext sessionContext = this.getUserAgent().getImageSessionContext();
            info = manager.getImageInfo(uri, sessionContext);
            this.drawImageUsingImageHandler(info, rect);
        }
        catch (ImageException ie) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageError(this, info != null ? info.toString() : uri, ie, null);
        }
        catch (FileNotFoundException fe) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageNotFound(this, info != null ? info.toString() : uri, fe, null);
        }
        catch (IOException ioe) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageIOError(this, info != null ? info.toString() : uri, ioe, null);
        }
    }

    protected void drawImageUsingDocument(Document doc, Rectangle rect) {
        ImageManager manager = this.getUserAgent().getImageManager();
        ImageInfo info = null;
        try {
            info = manager.preloadImage(null, new DOMSource(doc));
            this.drawImageUsingImageHandler(info, rect);
        }
        catch (ImageException ie) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageError(this, info != null ? info.toString() : INSTREAM_OBJECT_URI, ie, null);
        }
        catch (FileNotFoundException fe) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageNotFound(this, info != null ? info.toString() : INSTREAM_OBJECT_URI, fe, null);
        }
        catch (IOException ioe) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageIOError(this, info != null ? info.toString() : INSTREAM_OBJECT_URI, ioe, null);
        }
    }

    @Override
    public void drawBorderRect(Rectangle rect, BorderProps top, BorderProps bottom, BorderProps left, BorderProps right, Color innerBackgroundColor) throws IFException {
        Rectangle b;
        if (top != null) {
            b = new Rectangle(rect.x, rect.y, rect.width, top.width);
            this.fillRect(b, top.color);
        }
        if (right != null) {
            b = new Rectangle(rect.x + rect.width - right.width, rect.y, right.width, rect.height);
            this.fillRect(b, right.color);
        }
        if (bottom != null) {
            b = new Rectangle(rect.x, rect.y + rect.height - bottom.width, rect.width, bottom.width);
            this.fillRect(b, bottom.color);
        }
        if (left != null) {
            b = new Rectangle(rect.x, rect.y, left.width, rect.height);
            this.fillRect(b, left.color);
        }
    }

    protected boolean hasOnlySolidBorders(BorderProps top, BorderProps bottom, BorderProps left, BorderProps right) {
        if (top != null && top.style != 133) {
            return false;
        }
        if (bottom != null && bottom.style != 133) {
            return false;
        }
        if (left != null && left.style != 133) {
            return false;
        }
        return right == null || right.style == 133;
    }

    @Override
    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IFException {
        Rectangle rect = this.getLineBoundingBox(start, end, width);
        this.fillRect(rect, color);
    }

    protected Rectangle getLineBoundingBox(Point start, Point end, int width) {
        if (start.y == end.y) {
            int topy = start.y - width / 2;
            return new Rectangle(start.x, topy, end.x - start.x, width);
        }
        if (start.x == end.y) {
            int leftx = start.x - width / 2;
            return new Rectangle(leftx, start.x, width, end.y - start.y);
        }
        throw new IllegalArgumentException("Only horizontal or vertical lines are supported at the moment.");
    }

    @Override
    public void setFont(String family, String style, Integer weight, String variant, Integer size, Color color) throws IFException {
        if (family != null) {
            this.state.setFontFamily(family);
        }
        if (style != null) {
            this.state.setFontStyle(style);
        }
        if (weight != null) {
            this.state.setFontWeight(weight);
        }
        if (variant != null) {
            this.state.setFontVariant(variant);
        }
        if (size != null) {
            this.state.setFontSize(size);
        }
        if (color != null) {
            this.state.setTextColor(color);
        }
    }

    public static AffineTransform toPoints(AffineTransform transform) {
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        matrix[4] = matrix[4] / 1000.0;
        matrix[5] = matrix[5] / 1000.0;
        return new AffineTransform(matrix);
    }

    @Override
    public boolean isBackgroundRequired(BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) {
        return true;
    }

    @Override
    public void drawText(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text, boolean nextIsSpace) throws IFException {
        this.drawText(x, y, letterSpacing, wordSpacing, dp, text);
    }

    protected boolean drawSVGText(MultiByteFont multiByteFont, FontTriplet triplet, int x, int y, String text, IFState state) throws IFException {
        int c;
        int codepoint;
        for (int i = 0; i < text.length(); i += Character.charCount(codepoint)) {
            SVGGlyphData svg;
            codepoint = text.codePointAt(i);
            if (Character.isWhitespace(codepoint) || (svg = multiByteFont.getSVG(codepoint)) != null) continue;
            return false;
        }
        int sizeMillipoints = state.getFontSize();
        Font font = this.getFontInfo().getFontInstance(triplet, sizeMillipoints);
        int newx = x;
        for (int i = 0; i < text.length(); i += Character.charCount(c)) {
            c = text.codePointAt(i);
            SVGGlyphData svg = multiByteFont.getSVG(c);
            if (svg != null) {
                int codePoint = font.mapCodePoint(c);
                String dataURL = svg.getDataURL(multiByteFont.getCapHeight());
                Rectangle boundingBox = multiByteFont.getBoundingBox(codePoint, (int)((float)sizeMillipoints / 1000.0f));
                boundingBox.y = y - boundingBox.height - boundingBox.y;
                boundingBox.x = newx;
                boundingBox.width = (int)((float)sizeMillipoints * svg.scale);
                boundingBox.height = (int)((float)sizeMillipoints * svg.scale);
                this.drawImage(dataURL, boundingBox);
            }
            newx += font.getCharWidth(c);
        }
        return true;
    }
}

