/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.template.Configuration;
import org.apache.camel.CamelContext;
import org.apache.camel.component.freemarker.FreemarkerComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class FreemarkerComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        FreemarkerComponent target = (FreemarkerComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                target.setAllowContextMapAll(FreemarkerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                target.setAllowTemplateFromHeader(FreemarkerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(FreemarkerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(FreemarkerComponentConfigurer.property(camelContext, Configuration.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(FreemarkerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "localizedlookup": 
            case "localizedLookup": {
                target.setLocalizedLookup(FreemarkerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                return Boolean.TYPE;
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return Configuration.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "localizedlookup": 
            case "localizedLookup": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        FreemarkerComponent target = (FreemarkerComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                return target.isAllowContextMapAll();
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                return target.isAllowTemplateFromHeader();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "localizedlookup": 
            case "localizedLookup": {
                return target.isLocalizedLookup();
            }
        }
        return null;
    }
}

