/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.cache.NullCacheStorage;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import java.net.URL;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.freemarker.FreemarkerEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="freemarker")
public class FreemarkerComponent
extends DefaultComponent {
    @Metadata
    private boolean allowTemplateFromHeader;
    @Metadata
    private boolean allowContextMapAll;
    @Metadata
    private boolean localizedLookup;
    @Metadata(label="advanced")
    private Configuration configuration;
    private Configuration noCacheConfiguration;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Configuration config;
        String encoding = this.getAndRemoveParameter(parameters, "encoding", String.class);
        boolean cache = this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        int templateUpdateDelay = this.getAndRemoveParameter(parameters, "templateUpdateDelay", Integer.class, 0);
        if (cache) {
            config = this.getConfiguration();
            if (templateUpdateDelay > 0) {
                config.setTemplateUpdateDelay(templateUpdateDelay);
            }
        } else {
            config = this.getNoCacheConfiguration();
        }
        FreemarkerEndpoint endpoint = new FreemarkerEndpoint(uri, (Component)this, remaining);
        if (ObjectHelper.isNotEmpty(encoding)) {
            endpoint.setEncoding(encoding);
        }
        endpoint.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        endpoint.setAllowContextMapAll(this.allowContextMapAll);
        endpoint.setContentCache(cache);
        endpoint.setConfiguration(config);
        endpoint.setTemplateUpdateDelay(templateUpdateDelay);
        this.setProperties(endpoint, parameters);
        if (ResourceHelper.isHttpUri(remaining)) {
            remaining = ResourceHelper.appendParameters(remaining, parameters);
            endpoint.setResourceUri(remaining);
        }
        return endpoint;
    }

    public Configuration getConfiguration() {
        this.lock.lock();
        try {
            if (this.configuration == null) {
                this.configuration = new Configuration(Configuration.VERSION_2_3_32);
                this.configuration.setLocalizedLookup(this.isLocalizedLookup());
                this.configuration.setTemplateLoader(new URLTemplateLoader(){

                    @Override
                    protected URL getURL(String name) {
                        try {
                            return ResourceHelper.resolveMandatoryResourceAsUrl(FreemarkerComponent.this.getCamelContext(), name);
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                });
            }
            Configuration configuration = (Configuration)this.configuration.clone();
            return configuration;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isAllowContextMapAll() {
        return this.allowContextMapAll;
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }

    public boolean isLocalizedLookup() {
        return this.localizedLookup;
    }

    public void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
    }

    private Configuration getNoCacheConfiguration() {
        this.lock.lock();
        try {
            if (this.noCacheConfiguration == null) {
                this.noCacheConfiguration = (Configuration)this.getConfiguration().clone();
                this.noCacheConfiguration.setCacheStorage(new NullCacheStorage());
            }
            Configuration configuration = this.noCacheConfiguration;
            return configuration;
        }
        finally {
            this.lock.unlock();
        }
    }
}

