/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Locale;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.util.StringHelper;

public class ServicePropertiesFunction
implements PropertiesFunction {
    private static final String HOST_PREFIX = "_SERVICE_HOST";
    private static final String PORT_PREFIX = "_SERVICE_PORT";

    @Override
    public String getName() {
        return "service";
    }

    @Override
    public String apply(String remainder) {
        String key = remainder;
        String defaultValue = null;
        if (remainder.contains(":")) {
            key = StringHelper.before(remainder, ":");
            defaultValue = StringHelper.after(remainder, ":");
        }
        if (key != null) {
            key = key.toUpperCase(Locale.ENGLISH).replace('-', '_');
            String host = System.getenv(key + HOST_PREFIX);
            String port = System.getenv(key + PORT_PREFIX);
            if (host != null && port != null) {
                return host + ":" + port;
            }
            return defaultValue;
        }
        return defaultValue;
    }
}

