/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.model;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.camel.tooling.model.ApiMethodModel;
import org.apache.camel.tooling.model.ApiModel;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.model.ReleaseModel;
import org.apache.camel.tooling.model.SupportLevel;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public final class JsonMapper {
    private JsonMapper() {
    }

    public static BaseModel<?> generateModel(Path file) {
        try {
            String json = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
            return JsonMapper.generateModel(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading json file: " + file, e);
        }
    }

    public static BaseModel<?> generateModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateModel(obj);
    }

    public static BaseModel<?> generateModel(JsonObject obj) {
        if (obj.containsKey("component")) {
            return JsonMapper.generateComponentModel(obj);
        }
        if (obj.containsKey("language")) {
            return JsonMapper.generateLanguageModel(obj);
        }
        if (obj.containsKey("dataformat")) {
            return JsonMapper.generateDataFormatModel(obj);
        }
        if (obj.containsKey("other")) {
            return JsonMapper.generateOtherModel(obj);
        }
        if (obj.containsKey("model")) {
            return JsonMapper.generateEipModel(obj);
        }
        return null;
    }

    public static ComponentModel generateComponentModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateComponentModel(obj);
    }

    public static ComponentModel generateComponentModel(JsonObject obj) {
        JsonObject jsonObject;
        ApiMethodModel amm;
        ApiModel am;
        JsonObject jsonObject2;
        JsonObject jsonObject3;
        JsonObject headers;
        JsonObject mobj = (JsonObject)obj.get("component");
        ComponentModel model = new ComponentModel();
        JsonMapper.parseComponentModel(mobj, model);
        JsonObject mcprp = (JsonObject)obj.get("componentProperties");
        if (mcprp != null) {
            for (Map.Entry entry : mcprp.entrySet()) {
                JsonObject jsonObject4 = (JsonObject)entry.getValue();
                ComponentModel.ComponentOptionModel componentOptionModel = new ComponentModel.ComponentOptionModel();
                JsonMapper.parseOption(jsonObject4, componentOptionModel, (String)entry.getKey());
                model.addComponentOption(componentOptionModel);
            }
        }
        if ((headers = (JsonObject)obj.get("headers")) != null) {
            for (Map.Entry entry : headers.entrySet()) {
                JsonObject jsonObject5 = (JsonObject)entry.getValue();
                ComponentModel.EndpointHeaderModel header = new ComponentModel.EndpointHeaderModel();
                JsonMapper.parseOption(jsonObject5, header, (String)entry.getKey());
                header.setConstantName(jsonObject5.getString("constantName"));
                model.addEndpointHeader(header);
            }
        }
        if ((jsonObject3 = (JsonObject)obj.get("properties")) != null) {
            for (Map.Entry entry : jsonObject3.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                ComponentModel.EndpointOptionModel option = new ComponentModel.EndpointOptionModel();
                JsonMapper.parseOption(mp, option, (String)entry.getKey());
                model.addEndpointOption(option);
            }
        }
        if ((jsonObject2 = (JsonObject)obj.get("apis")) != null) {
            for (Map.Entry entry : jsonObject2.entrySet()) {
                JsonObject mm;
                String name = (String)entry.getKey();
                JsonObject mp = (JsonObject)entry.getValue();
                am = new ApiModel();
                am.setName(name);
                am.setDescription(mp.getStringOrDefault("description", ""));
                am.setConsumerOnly(mp.getBooleanOrDefault("consumerOnly", false));
                am.setProducerOnly(mp.getBooleanOrDefault("producerOnly", false));
                model.getApiOptions().add(am);
                String aliases = mp.getCollection("aliases");
                if (aliases != null && !aliases.isEmpty()) {
                    aliases.forEach(am::addAlias);
                }
                if ((mm = (JsonObject)mp.get("methods")) == null) continue;
                for (Map.Entry mme : mm.entrySet()) {
                    JsonObject mmp = (JsonObject)mme.getValue();
                    amm = am.newMethod((String)mme.getKey());
                    String signatures = mmp.getCollection("signatures");
                    if (signatures != null && !signatures.isEmpty()) {
                        signatures.forEach(amm::addSignature);
                    }
                    amm.setDescription(mmp.getStringOrDefault("description", ""));
                }
            }
        }
        if ((jsonObject = (JsonObject)obj.get("apiProperties")) != null) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonObject mp = (JsonObject)entry.getValue();
                String name = (String)entry.getKey();
                am = model.getApiOptions().stream().filter(a -> a.getName().equals(name)).findFirst().orElse(null);
                if (am == null) {
                    throw new RuntimeException("Invalid json. Cannot find ApiModel with name: " + name);
                }
                JsonObject mm = (JsonObject)mp.get("methods");
                if (mm == null) continue;
                for (Map.Entry mme : mm.entrySet()) {
                    JsonObject mmp = (JsonObject)mme.getValue();
                    String mname = (String)mme.getKey();
                    amm = am.getMethods().stream().filter(a -> a.getName().equals(mname)).findFirst().orElse(null);
                    if (amm == null) {
                        throw new RuntimeException("Invalid json. Cannot find ApiMethodModel with name: " + mname);
                    }
                    JsonObject properties = (JsonObject)mmp.get("properties");
                    if (properties == null) continue;
                    for (Map.Entry pe : properties.entrySet()) {
                        JsonObject prop = (JsonObject)pe.getValue();
                        ComponentModel.ApiOptionModel option = new ComponentModel.ApiOptionModel();
                        JsonMapper.parseOption(prop, option, (String)pe.getKey());
                        option.setOptional(prop.getBooleanOrDefault("optional", false));
                        amm.addApiOptionModel(option);
                    }
                }
            }
        }
        return model;
    }

    public static void parseComponentModel(JsonObject mobj, ComponentModel model) {
        JsonMapper.parseModel(mobj, model);
        model.setScheme(mobj.getString("scheme"));
        model.setExtendsScheme(mobj.getString("extendsScheme"));
        model.setAlternativeSchemes(mobj.getString("alternativeSchemes"));
        model.setSyntax(mobj.getString("syntax"));
        model.setAlternativeSyntax(mobj.getString("alternativeSyntax"));
        model.setAsync(mobj.getBooleanOrDefault("async", false));
        model.setApi(mobj.getBooleanOrDefault("api", false));
        model.setApiSyntax(mobj.getString("apiSyntax"));
        model.setConsumerOnly(mobj.getBooleanOrDefault("consumerOnly", false));
        model.setProducerOnly(mobj.getBooleanOrDefault("producerOnly", false));
        model.setLenientProperties(mobj.getBooleanOrDefault("lenientProperties", false));
        JsonMapper.parseArtifact(mobj, model);
    }

    private static void parseArtifact(JsonObject mobj, ArtifactModel<?> model) {
        model.setGroupId(mobj.getString("groupId"));
        model.setArtifactId(mobj.getString("artifactId"));
        model.setVersion(mobj.getString("version"));
    }

    public static String createParameterJsonSchema(ComponentModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(ComponentModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.put("scheme", model.getScheme());
        obj.put("extendsScheme", model.getExtendsScheme());
        obj.put("alternativeSchemes", model.getAlternativeSchemes());
        obj.put("syntax", model.getSyntax());
        obj.put("alternativeSyntax", model.getAlternativeSyntax());
        obj.put("async", model.isAsync());
        obj.put("api", model.isApi());
        if (model.isApi()) {
            obj.put("apiSyntax", model.getApiSyntax());
        }
        obj.put("consumerOnly", model.isConsumerOnly());
        obj.put("producerOnly", model.isProducerOnly());
        obj.put("lenientProperties", model.isLenientProperties());
        obj.put("verifiers", model.getVerifiers());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put("component", obj);
        wrapper.put("componentProperties", JsonMapper.asJsonObject(model.getComponentOptions()));
        List<ComponentModel.EndpointHeaderModel> headers = model.getEndpointHeaders();
        if (!headers.isEmpty()) {
            wrapper.put("headers", JsonMapper.asJsonObject(headers));
        }
        wrapper.put("properties", JsonMapper.asJsonObject(model.getEndpointOptions()));
        if (!model.getApiOptions().isEmpty()) {
            wrapper.put("apis", JsonMapper.apiModelAsJsonObject(model.getApiOptions(), false));
            wrapper.put("apiProperties", JsonMapper.apiModelAsJsonObject(model.getApiOptions(), true));
        }
        return wrapper;
    }

    public static DataFormatModel generateDataFormatModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateDataFormatModel(obj);
    }

    public static DataFormatModel generateDataFormatModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get("dataformat");
        DataFormatModel model = new DataFormatModel();
        JsonMapper.parseModel(mobj, model);
        JsonMapper.parseArtifact(mobj, model);
        model.setModelName(mobj.getString("modelName"));
        model.setModelJavaType(mobj.getString("modelJavaType"));
        JsonObject mprp = (JsonObject)obj.get("properties");
        for (Map.Entry entry : mprp.entrySet()) {
            JsonObject mp = (JsonObject)entry.getValue();
            DataFormatModel.DataFormatOptionModel option = new DataFormatModel.DataFormatOptionModel();
            JsonMapper.parseOption(mp, option, (String)entry.getKey());
            model.addOption(option);
        }
        return model;
    }

    public static String createParameterJsonSchema(DataFormatModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(DataFormatModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.put("modelName", model.getModelName());
        obj.put("modelJavaType", model.getModelJavaType());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put("dataformat", obj);
        wrapper.put("properties", JsonMapper.asJsonObject(model.getOptions()));
        return wrapper;
    }

    public static EipModel generateEipModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateEipModel(obj);
    }

    public static EipModel generateEipModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get("model");
        EipModel model = new EipModel();
        JsonMapper.parseModel(mobj, model);
        model.setAbstractModel(mobj.getBooleanOrDefault("abstract", false));
        model.setInput(mobj.getBooleanOrDefault("input", false));
        model.setOutput(mobj.getBooleanOrDefault("output", false));
        JsonObject mprp = (JsonObject)obj.get("properties");
        for (Map.Entry entry : mprp.entrySet()) {
            JsonObject mp = (JsonObject)entry.getValue();
            EipModel.EipOptionModel option = new EipModel.EipOptionModel();
            JsonMapper.parseOption(mp, option, (String)entry.getKey());
            model.addOption(option);
        }
        return model;
    }

    public static String createParameterJsonSchema(EipModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(EipModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        obj.put("abstract", model.isAbstractModel());
        obj.put("input", model.isInput());
        obj.put("output", model.isOutput());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put("model", obj);
        wrapper.put("properties", JsonMapper.asJsonObject(model.getOptions()));
        return wrapper;
    }

    public static LanguageModel generateLanguageModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateLanguageModel(obj);
    }

    public static LanguageModel generateLanguageModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get("language");
        LanguageModel model = new LanguageModel();
        JsonMapper.parseModel(mobj, model);
        model.setModelName(mobj.getString("modelName"));
        model.setModelJavaType(mobj.getString("modelJavaType"));
        JsonMapper.parseArtifact(mobj, model);
        JsonObject mprp = (JsonObject)obj.get("properties");
        for (Map.Entry entry : mprp.entrySet()) {
            JsonObject mp = (JsonObject)entry.getValue();
            LanguageModel.LanguageOptionModel option = new LanguageModel.LanguageOptionModel();
            JsonMapper.parseOption(mp, option, (String)entry.getKey());
            model.addOption(option);
        }
        return model;
    }

    public static String createParameterJsonSchema(LanguageModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(LanguageModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.put("modelName", model.getModelName());
        obj.put("modelJavaType", model.getModelJavaType());
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put("language", obj);
        wrapper.put("properties", JsonMapper.asJsonObject(model.getOptions()));
        return wrapper;
    }

    public static OtherModel generateOtherModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateOtherModel(obj);
    }

    public static OtherModel generateOtherModel(JsonObject obj) {
        JsonObject mobj = (JsonObject)obj.get("other");
        OtherModel model = new OtherModel();
        JsonMapper.parseModel(mobj, model);
        JsonMapper.parseArtifact(mobj, model);
        return model;
    }

    public static String createJsonSchema(OtherModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject asJsonObject(OtherModel model) {
        JsonObject obj = new JsonObject();
        JsonMapper.baseToJson(model, obj);
        JsonMapper.artifactToJson(model, obj);
        obj.entrySet().removeIf(e -> e.getValue() == null);
        JsonObject wrapper = new JsonObject();
        wrapper.put("other", obj);
        return wrapper;
    }

    private static void baseToJson(BaseModel<?> model, JsonObject obj) {
        obj.put("kind", model.getKind());
        obj.put("name", model.getName());
        obj.put("title", model.getTitle());
        obj.put("description", model.getDescription());
        obj.put("deprecated", model.isDeprecated());
        obj.put("deprecatedSince", model.getDeprecatedSince());
        obj.put("deprecationNote", model.getDeprecationNote());
        obj.put("firstVersion", model.getFirstVersion());
        obj.put("label", model.getLabel());
        obj.put("javaType", model.getJavaType());
        if (model.getSupportLevel() != null) {
            obj.put("supportLevel", model.getSupportLevel().name());
        }
        if (model.isNativeSupported()) {
            obj.put("nativeSupported", model.isNativeSupported());
        }
        if (!model.getMetadata().isEmpty()) {
            obj.put("metadata", model.getMetadata());
        }
    }

    private static void artifactToJson(ArtifactModel<?> model, JsonObject obj) {
        obj.put("groupId", model.getGroupId());
        obj.put("artifactId", model.getArtifactId());
        obj.put("version", model.getVersion());
    }

    private static void parseModel(JsonObject mobj, BaseModel<?> model) {
        model.setTitle(mobj.getString("title"));
        model.setName(mobj.getString("name"));
        model.setDescription(mobj.getString("description"));
        model.setFirstVersion(mobj.getString("firstVersion"));
        model.setLabel(mobj.getString("label"));
        model.setDeprecated(mobj.getBooleanOrDefault("deprecated", false));
        model.setDeprecatedSince(mobj.getString("deprecatedSince"));
        model.setDeprecationNote(mobj.getString("deprecationNote"));
        model.setJavaType(mobj.getString("javaType"));
        model.setSupportLevel(SupportLevel.safeValueOf(mobj.getString("supportLevel")));
        model.setNativeSupported(mobj.getBooleanOrDefault("nativeSupported", false));
        model.setMetadata(mobj.getMapOrDefault("metadata", new JsonObject()));
    }

    private static void parseOption(JsonObject mp, BaseOptionModel option, String name) {
        option.setName(name);
        option.setKind(mp.getString("kind"));
        option.setDisplayName(mp.getString("displayName"));
        option.setGroup(mp.getString("group"));
        option.setLabel(mp.getString("label"));
        option.setRequired(mp.getBooleanOrDefault("required", false));
        option.setType(mp.getString("type"));
        option.setJavaType(mp.getString("javaType"));
        option.setEnums(JsonMapper.asStringList(mp.getCollection("enum")));
        option.setOneOfs(JsonMapper.asStringList(mp.getCollection("oneOf")));
        option.setPrefix(mp.getString("prefix"));
        option.setOptionalPrefix(mp.getString("optionalPrefix"));
        option.setMultiValue(mp.getBooleanOrDefault("multiValue", false));
        option.setDeprecated(mp.getBooleanOrDefault("deprecated", false));
        option.setAutowired(mp.getBooleanOrDefault("autowired", false));
        option.setDeprecationNote(mp.getString("deprecationNote"));
        option.setSecret(mp.getBooleanOrDefault("secret", false));
        option.setDefaultValue(mp.get("defaultValue"));
        option.setAsPredicate(mp.getBooleanOrDefault("asPredicate", false));
        option.setConfigurationClass(mp.getString("configurationClass"));
        option.setConfigurationField(mp.getString("configurationField"));
        option.setDescription(mp.getString("description"));
        option.setGetterMethod(mp.getString("getterMethod"));
        option.setSetterMethod(mp.getString("setterMethod"));
    }

    private static void parseGroup(JsonObject mp, MainModel.MainGroupModel option) {
        option.setName(mp.getString("name"));
        option.setDescription(mp.getString("description"));
        option.setSourceType(mp.getString("sourceType"));
    }

    public static JsonObject asJsonObject(List<? extends BaseOptionModel> options) {
        JsonObject json = new JsonObject();
        options.forEach(option -> json.put(option.getName(), JsonMapper.asJsonObject(option)));
        return json;
    }

    public static JsonObject apiModelAsJsonObject(Collection<ApiModel> model, boolean options) {
        JsonObject root = new JsonObject();
        model.forEach(a -> {
            JsonObject json = new JsonObject();
            root.put(a.getName(), json);
            if (!options) {
                json.put("consumerOnly", a.isConsumerOnly());
                json.put("producerOnly", a.isProducerOnly());
                if (a.getDescription() != null) {
                    json.put("description", a.getDescription());
                }
                if (!a.getAliases().isEmpty()) {
                    json.put("aliases", new JsonArray((Collection<?>)a.getAliases()));
                }
            }
            TreeMap methods = new TreeMap();
            json.put("methods", methods);
            a.getMethods().forEach(m -> {
                JsonObject mJson = new JsonObject();
                if (!options) {
                    if (m.getDescription() != null) {
                        mJson.put("description", m.getDescription());
                    }
                    if (!m.getSignatures().isEmpty()) {
                        mJson.put("signatures", new JsonArray((Collection<?>)m.getSignatures()));
                    }
                }
                if (options) {
                    mJson.put("properties", JsonMapper.asJsonObject(m.getOptions()));
                }
                methods.put(m.getName(), mJson);
            });
        });
        return root;
    }

    public static JsonObject asJsonObject(BaseOptionModel option) {
        JsonObject prop = new JsonObject();
        prop.put("kind", option.getKind());
        prop.put("displayName", option.getDisplayName());
        prop.put("group", option.getGroup());
        prop.put("label", option.getLabel());
        prop.put("required", option.isRequired());
        prop.put("type", option.getType());
        prop.put("javaType", option.getJavaType());
        prop.put("enum", option.getEnums());
        prop.put("oneOf", option.getOneOfs());
        prop.put("prefix", option.getPrefix());
        prop.put("optionalPrefix", option.getOptionalPrefix());
        prop.put("multiValue", option.isMultiValue());
        prop.put("deprecated", option.isDeprecated());
        prop.put("deprecationNote", option.getDeprecationNote());
        prop.put("autowired", option.isAutowired());
        prop.put("secret", option.isSecret());
        prop.put("defaultValue", option.getDefaultValue());
        prop.put("asPredicate", option.isAsPredicate());
        prop.put("configurationClass", option.getConfigurationClass());
        prop.put("configurationField", option.getConfigurationField());
        prop.put("description", option.getDescription());
        prop.put("getterMethod", option.getGetterMethod());
        prop.put("setterMethod", option.getSetterMethod());
        if (option instanceof ComponentModel.ApiOptionModel) {
            prop.put("optional", ((ComponentModel.ApiOptionModel)option).isOptional());
        } else if (option instanceof ComponentModel.EndpointHeaderModel) {
            prop.put("constantName", ((ComponentModel.EndpointHeaderModel)option).getConstantName());
        }
        prop.entrySet().removeIf(e -> e.getValue() == null);
        prop.remove("prefix", "");
        prop.remove("optionalPrefix", "");
        prop.remove("defaultValue", "");
        prop.remove("multiValue", Boolean.FALSE);
        prop.remove("asPredicate", Boolean.FALSE);
        return prop;
    }

    public static MainModel generateMainModel(String json) {
        JsonObject obj = JsonMapper.deserialize(json);
        return JsonMapper.generateMainModel(obj);
    }

    public static MainModel generateMainModel(JsonObject obj) {
        MainModel model = new MainModel();
        JsonArray mgrp = (JsonArray)obj.get("groups");
        for (Object entry : mgrp) {
            JsonObject mg = (JsonObject)entry;
            MainModel.MainGroupModel group = new MainModel.MainGroupModel();
            JsonMapper.parseGroup(mg, group);
            model.addGroup(group);
        }
        JsonArray mprp = (JsonArray)obj.get("properties");
        for (Object entry : mprp) {
            JsonObject mp = (JsonObject)entry;
            MainModel.MainOptionModel option = new MainModel.MainOptionModel();
            JsonMapper.parseOption(mp, option, mp.getString("name"));
            option.setSourceType(mp.getString("sourceType"));
            model.addOption(option);
        }
        return model;
    }

    public static JsonObject asJsonObject(MainModel model) {
        JsonObject json = new JsonObject();
        JsonArray groups = new JsonArray();
        for (MainModel.MainGroupModel group : model.getGroups()) {
            JsonObject j = new JsonObject();
            j.put("name", group.getName());
            j.put("description", group.getDescription());
            j.put("sourceType", group.getSourceType());
            groups.add(j);
        }
        json.put("groups", groups);
        JsonArray props = new JsonArray();
        for (MainModel.MainOptionModel prop : model.getOptions()) {
            JsonObject j = new JsonObject();
            j.put("name", prop.getName());
            j.put("description", prop.getDescription());
            j.put("sourceType", prop.getSourceType());
            j.put("type", prop.getType());
            j.put("javaType", prop.getJavaType());
            if (prop.getDefaultValue() != null) {
                j.put("defaultValue", prop.getDefaultValue());
            }
            if (prop.getEnums() != null) {
                j.put("enum", prop.getEnums());
            }
            if (prop.isDeprecated()) {
                j.put("deprecated", prop.isDeprecated());
            }
            if (prop.isAutowired()) {
                j.put("autowired", prop.isAutowired());
            }
            props.add(j);
        }
        json.put("properties", props);
        return json;
    }

    public static JsonObject asJsonObject(ReleaseModel model) {
        JsonObject json = new JsonObject();
        json.put("version", model.getVersion());
        json.put("date", model.getDate());
        if (model.getEol() != null) {
            json.put("eol", model.getEol());
        }
        if (model.getKind() != null) {
            json.put("kind", model.getKind());
        }
        if (model.getJdk() != null) {
            json.put("jdk", model.getJdk());
        }
        return json;
    }

    public static ReleaseModel generateReleaseModel(JsonObject obj) {
        ReleaseModel model = new ReleaseModel();
        model.setVersion(obj.getString("version"));
        model.setDate(obj.getString("date"));
        model.setEol(obj.getString("eol"));
        model.setKind(obj.getString("kind"));
        model.setJdk(obj.getString("jdk"));
        return model;
    }

    public static String createJsonSchema(MainModel model) {
        JsonObject wrapper = JsonMapper.asJsonObject(model);
        return JsonMapper.serialize(wrapper);
    }

    public static JsonObject deserialize(String json) {
        try {
            return (JsonObject)Jsoner.deserialize(json);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse json", e);
        }
    }

    public static String serialize(Object json) {
        return Jsoner.prettyPrint(Jsoner.serialize(json), 2, 2);
    }

    protected static List<String> asStringList(Collection<?> col) {
        if (col != null) {
            return col.stream().map(Object::toString).collect(Collectors.toList());
        }
        return null;
    }
}

