/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public final class CatalogHelper {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    private CatalogHelper() {
    }

    public static void loadLines(InputStream in, List<String> lines) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(in);
             LineNumberReader reader = new LineNumberReader(isr);){
            String line;
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                lines.add(line);
            }
        }
    }

    public static List<String> loadLines(InputStream in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        CatalogHelper.loadLines(in, lines);
        return lines;
    }

    public static String loadText(InputStream in) throws IOException {
        return IOHelper.loadText(in);
    }

    public static boolean matchWildcard(String name, String pattern) {
        return pattern.endsWith("*") && name.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    public static boolean isEmpty(Object value) {
        return !CatalogHelper.isNotEmpty(value);
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String text = (String)value;
            return !text.isBlank();
        }
        return true;
    }

    static Map<String, Object> parseParameters(URI uri) throws URISyntaxException {
        String query = uri.getQuery();
        if (query == null) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            query = StringHelper.after(schemeSpecificPart, "?");
            if (query == null) {
                return new LinkedHashMap<String, Object>(0);
            }
        } else {
            query = URISupport.stripPrefix(query, "?");
        }
        return CatalogHelper.parseQueryManually(query);
    }

    static Map<String, Object> parseQueryManually(String uri) throws URISyntaxException {
        if (uri == null || uri.isEmpty()) {
            return Collections.emptyMap();
        }
        if (uri.endsWith("&")) {
            throw new URISyntaxException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>();
        boolean isKey = true;
        boolean isRaw = false;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < uri.length(); ++i) {
            char ch = uri.charAt(i);
            isRaw = CatalogHelper.isRaw(isRaw, value);
            if (isKey && ch == '=') {
                isKey = false;
                isRaw = false;
                continue;
            }
            if (ch == '&') {
                String aKey = key.toString();
                CatalogHelper.addKeyIfPresent(aKey, value, rc, isRaw);
                key.setLength(0);
                value.setLength(0);
                isKey = true;
                isRaw = false;
                continue;
            }
            if (isKey) {
                key.append(ch);
                continue;
            }
            value.append(ch);
        }
        if (!key.isEmpty()) {
            String aKey = key.toString();
            CatalogHelper.addKeyIfPresent(aKey, value, rc, isRaw);
        }
        return rc;
    }

    private static boolean isRaw(boolean isRaw, StringBuilder value) {
        for (int j = 0; j < URISupport.RAW_TOKEN_START.length; ++j) {
            String rawTokenStart = "RAW" + URISupport.RAW_TOKEN_START[j];
            isRaw = value.toString().startsWith(rawTokenStart);
            if (isRaw) break;
        }
        return isRaw;
    }

    private static void addKeyIfPresent(String aKey, StringBuilder value, Map<String, Object> rc, boolean isRaw) {
        boolean validKey;
        boolean bl = validKey = !aKey.startsWith("{{") && !aKey.endsWith("}}");
        if (validKey) {
            String valueStr = CatalogHelper.optionallyDecode(value.toString(), isRaw);
            CatalogHelper.addParameter(aKey, valueStr, rc, isRaw);
        }
    }

    private static void addParameter(String name, String value, Map<String, Object> map, boolean isRaw) {
        if (map.containsKey(name = URLDecoder.decode(name, CHARSET))) {
            map.computeIfPresent(name, (k, v) -> CatalogHelper.replaceWithList(v, value));
        } else {
            map.put(name, value);
        }
    }

    private static String optionallyDecode(String value, boolean isRaw) {
        if (!isRaw) {
            return URLDecoder.decode(value.replace("%", "%25"), CHARSET);
        }
        return value;
    }

    private static Object replaceWithList(Object oldValue, String newValue) {
        List<String> list;
        if (oldValue instanceof List) {
            List oldValueList = (List)oldValue;
            list = oldValueList;
            list.add(newValue);
        } else {
            String s;
            list = new ArrayList();
            String string = s = oldValue != null ? oldValue.toString() : null;
            if (s != null) {
                list.add(s);
            }
        }
        return list;
    }
}

