/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpConfiguration;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.net.ftp.FTPFile;

@Component(value="ftp")
public class FtpComponent
extends RemoteFileComponent<FTPFile> {
    public FtpComponent() {
    }

    public FtpComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected GenericFileEndpoint<FTPFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = this.getBaseUri(uri);
        FtpConfiguration config = new FtpConfiguration(new URI(baseUri));
        FtpUtils.ensureRelativeFtpDirectory(this, config);
        FtpEndpoint<FTPFile> answer = new FtpEndpoint<FTPFile>(uri, (RemoteFileComponent<FTPFile>)this, config);
        this.extractAndSetFtpClientConfigParameters(parameters, answer);
        this.extractAndSetFtpClientParameters(parameters, answer);
        return answer;
    }

    protected String getBaseUri(String uri) {
        return StringHelper.before(uri, "?", uri);
    }

    protected void extractAndSetFtpClientConfigParameters(Map<String, Object> parameters, FtpEndpoint<FTPFile> answer) {
        if (PropertiesHelper.hasProperties(parameters, "ftpClientConfig.")) {
            Map<String, Object> param = PropertiesHelper.extractProperties(parameters, "ftpClientConfig.");
            answer.setFtpClientConfigParameters(param);
        }
    }

    protected void extractAndSetFtpClientParameters(Map<String, Object> parameters, FtpEndpoint<FTPFile> answer) {
        if (PropertiesHelper.hasProperties(parameters, "ftpClient.")) {
            Map<String, Object> param = PropertiesHelper.extractProperties(parameters, "ftpClient.");
            answer.setFtpClientParameters(param);
        }
    }

    @Override
    protected void setProperties(Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        Object siteCommand = parameters.remove("siteCommand");
        if (siteCommand != null) {
            String cmd = PropertyConfigurerSupport.property(this.getCamelContext(), String.class, siteCommand);
            if (EndpointHelper.isReferenceParameter(cmd)) {
                cmd = EndpointHelper.resolveReferenceParameter(this.getCamelContext(), cmd, String.class);
            }
            ((FtpEndpoint)endpoint).getConfiguration().setSiteCommand(cmd);
        }
        super.setProperties(endpoint, parameters);
    }

    @Override
    protected void afterPropertiesSet(GenericFileEndpoint<FTPFile> endpoint) throws Exception {
    }
}

