/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.ConsumerCache;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.cache.DefaultConsumerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumerTemplate
extends ServiceSupport
implements ConsumerTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConsumerTemplate.class);
    private final CamelContext camelContext;
    private ConsumerCache consumerCache;
    private int maximumCacheSize;

    public DefaultConsumerTemplate(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    @Override
    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    @Override
    public int getCurrentCacheSize() {
        if (this.consumerCache == null) {
            return 0;
        }
        return this.consumerCache.size();
    }

    @Override
    public void cleanUp() {
        if (this.consumerCache != null) {
            this.consumerCache.cleanUp();
        }
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public Exchange receive(String endpointUri) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.getConsumerCache().receive(endpoint);
    }

    @Override
    public Exchange receive(Endpoint endpoint) {
        return this.receive(endpoint.getEndpointUri());
    }

    @Override
    public Exchange receive(String endpointUri, long timeout) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.getConsumerCache().receive(endpoint, timeout);
    }

    @Override
    public Exchange receive(Endpoint endpoint, long timeout) {
        return this.receive(endpoint.getEndpointUri(), timeout);
    }

    @Override
    public Exchange receiveNoWait(String endpointUri) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.getConsumerCache().receiveNoWait(endpoint);
    }

    @Override
    public Exchange receiveNoWait(Endpoint endpoint) {
        return this.receiveNoWait(endpoint.getEndpointUri());
    }

    @Override
    public Object receiveBody(String endpointUri) {
        return this.receiveBody(this.receive(endpointUri));
    }

    @Override
    public Object receiveBody(Endpoint endpoint) {
        return this.receiveBody(endpoint.getEndpointUri());
    }

    @Override
    public Object receiveBody(String endpointUri, long timeout) {
        return this.receiveBody(this.receive(endpointUri, timeout));
    }

    @Override
    public Object receiveBody(Endpoint endpoint, long timeout) {
        return this.receiveBody(endpoint.getEndpointUri(), timeout);
    }

    @Override
    public Object receiveBodyNoWait(String endpointUri) {
        return this.receiveBody(this.receiveNoWait(endpointUri));
    }

    private Object receiveBody(Exchange exchange) {
        Object answer;
        try {
            answer = this.extractResultBody(exchange);
        }
        finally {
            this.doneUoW(exchange);
        }
        return answer;
    }

    @Override
    public Object receiveBodyNoWait(Endpoint endpoint) {
        return this.receiveBodyNoWait(endpoint.getEndpointUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T receiveBody(String endpointUri, Class<T> type) {
        Object answer;
        Exchange exchange = this.receive(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
            answer = this.camelContext.getTypeConverter().convertTo(type, exchange, answer);
        }
        finally {
            this.doneUoW(exchange);
        }
        return (T)answer;
    }

    @Override
    public <T> T receiveBody(Endpoint endpoint, Class<T> type) {
        return this.receiveBody(endpoint.getEndpointUri(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T receiveBody(String endpointUri, long timeout, Class<T> type) {
        Object answer;
        Exchange exchange = this.receive(endpointUri, timeout);
        try {
            answer = this.extractResultBody(exchange);
            answer = this.camelContext.getTypeConverter().convertTo(type, exchange, answer);
        }
        finally {
            this.doneUoW(exchange);
        }
        return (T)answer;
    }

    @Override
    public <T> T receiveBody(Endpoint endpoint, long timeout, Class<T> type) {
        return this.receiveBody(endpoint.getEndpointUri(), timeout, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T receiveBodyNoWait(String endpointUri, Class<T> type) {
        Object answer;
        Exchange exchange = this.receiveNoWait(endpointUri);
        try {
            answer = this.extractResultBody(exchange);
            answer = this.camelContext.getTypeConverter().convertTo(type, exchange, answer);
        }
        finally {
            this.doneUoW(exchange);
        }
        return (T)answer;
    }

    @Override
    public <T> T receiveBodyNoWait(Endpoint endpoint, Class<T> type) {
        return this.receiveBodyNoWait(endpoint.getEndpointUri(), type);
    }

    @Override
    public void doneUoW(Exchange exchange) {
        try {
            if (exchange == null) {
                return;
            }
            if (exchange.getUnitOfWork() == null) {
                List<Synchronization> synchronizations = exchange.getExchangeExtension().handoverCompletions();
                UnitOfWorkHelper.doneSynchronizations(exchange, synchronizations);
            } else {
                exchange.getUnitOfWork().done(exchange);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception occurred during done UnitOfWork for Exchange: {}. This exception will be ignored.", (Object)exchange, (Object)e);
        }
    }

    protected Endpoint resolveMandatoryEndpoint(String endpointUri) {
        return CamelContextHelper.getMandatoryEndpoint(this.camelContext, endpointUri);
    }

    protected Object extractResultBody(Exchange result) {
        Object answer = null;
        if (result != null) {
            if (result.getException() != null) {
                throw RuntimeCamelException.wrapRuntimeCamelException(result.getException());
            }
            answer = result.getMessage().getBody();
            if (result.getException() != null) {
                throw RuntimeCamelException.wrapRuntimeCamelException(result.getException());
            }
        }
        return answer;
    }

    private ConsumerCache getConsumerCache() {
        if (!this.isStarted()) {
            throw new IllegalStateException("ConsumerTemplate has not been started");
        }
        return this.consumerCache;
    }

    @Override
    protected void doBuild() throws Exception {
        if (this.consumerCache == null) {
            this.consumerCache = new DefaultConsumerCache(this, this.camelContext, this.maximumCacheSize);
        }
        ServiceHelper.buildService((Object)this.consumerCache);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.consumerCache);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.consumerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.consumerCache);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.consumerCache);
        this.consumerCache = null;
    }
}

