/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.maps.GeolocationApi;
import com.google.maps.ImageResult;
import com.google.maps.PendingResult;
import com.google.maps.errors.ApiException;
import com.google.maps.errors.UnknownErrorException;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.DayOfWeekAdapter;
import com.google.maps.internal.DistanceAdapter;
import com.google.maps.internal.DurationAdapter;
import com.google.maps.internal.EncodedPolylineInstanceCreator;
import com.google.maps.internal.ExceptionsAllowedToRetry;
import com.google.maps.internal.FareAdapter;
import com.google.maps.internal.GeolocationResponseAdapter;
import com.google.maps.internal.InstantAdapter;
import com.google.maps.internal.LatLngAdapter;
import com.google.maps.internal.LocalTimeAdapter;
import com.google.maps.internal.PriceLevelAdapter;
import com.google.maps.internal.SafeEnumAdapter;
import com.google.maps.internal.ZonedDateTimeAdapter;
import com.google.maps.metrics.RequestMetrics;
import com.google.maps.model.AddressComponentType;
import com.google.maps.model.AddressType;
import com.google.maps.model.Distance;
import com.google.maps.model.Duration;
import com.google.maps.model.EncodedPolyline;
import com.google.maps.model.Fare;
import com.google.maps.model.LatLng;
import com.google.maps.model.LocationType;
import com.google.maps.model.OpeningHours;
import com.google.maps.model.PlaceDetails;
import com.google.maps.model.PriceLevel;
import com.google.maps.model.TravelMode;
import com.google.maps.model.VehicleType;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaePendingResult<T, R extends ApiResponse<T>>
implements PendingResult<T> {
    private final HTTPRequest request;
    private final URLFetchService client;
    private final Class<R> responseClass;
    private final FieldNamingPolicy fieldNamingPolicy;
    private final Integer maxRetries;
    private final ExceptionsAllowedToRetry exceptionsAllowedToRetry;
    private final RequestMetrics metrics;
    private long errorTimeOut;
    private int retryCounter = 0;
    private long cumulativeSleepTime = 0L;
    private Future<HTTPResponse> call;
    private static final Logger LOG = LoggerFactory.getLogger((String)GaePendingResult.class.getName());
    private static final List<Integer> RETRY_ERROR_CODES = Arrays.asList(500, 503, 504);

    public GaePendingResult(HTTPRequest request, URLFetchService client, Class<R> responseClass, FieldNamingPolicy fieldNamingPolicy, long errorTimeOut, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry, RequestMetrics metrics) {
        this.request = request;
        this.client = client;
        this.responseClass = responseClass;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.errorTimeOut = errorTimeOut;
        this.maxRetries = maxRetries;
        this.exceptionsAllowedToRetry = exceptionsAllowedToRetry;
        this.metrics = metrics;
        metrics.startNetwork();
        this.call = client.fetchAsync(request);
    }

    @Override
    public void setCallback(PendingResult.Callback<T> callback) {
        throw new RuntimeException("setCallback not implemented for Google App Engine");
    }

    @Override
    public T await() throws ApiException, IOException, InterruptedException {
        try {
            HTTPResponse result = this.call.get();
            this.metrics.endNetwork();
            return this.parseResponse(this, result);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new UnknownErrorException("Unexpected exception from " + e.getMessage());
        }
    }

    @Override
    public T awaitIgnoreError() {
        try {
            return this.await();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void cancel() {
        this.call.cancel(true);
    }

    private T parseResponse(GaePendingResult<T, R> request, HTTPResponse response) throws IOException, ApiException, InterruptedException {
        try {
            T result = this.parseResponseInternal(request, response);
            this.metrics.endRequest(null, response.getResponseCode(), this.retryCounter);
            return result;
        }
        catch (Exception e) {
            this.metrics.endRequest(e, response.getResponseCode(), this.retryCounter);
            throw e;
        }
    }

    private T parseResponseInternal(GaePendingResult<T, R> request, HTTPResponse response) throws IOException, ApiException, InterruptedException {
        ApiResponse resp;
        if (this.shouldRetry(response)) {
            return super.retry();
        }
        byte[] bytes = response.getContent();
        String contentType = null;
        for (HTTPHeader header : response.getHeaders()) {
            if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
            contentType = header.getValue();
        }
        if (contentType != null && contentType.startsWith("image") && this.responseClass == ImageResult.Response.class && response.getResponseCode() == 200) {
            ImageResult result = new ImageResult(contentType, bytes);
            return (T)result;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)ZonedDateTime.class), new ZonedDateTimeAdapter()).registerTypeAdapter((Type)((Object)Distance.class), new DistanceAdapter()).registerTypeAdapter((Type)((Object)Duration.class), new DurationAdapter()).registerTypeAdapter((Type)((Object)Fare.class), new FareAdapter()).registerTypeAdapter((Type)((Object)LatLng.class), new LatLngAdapter()).registerTypeAdapter((Type)((Object)AddressComponentType.class), new SafeEnumAdapter<AddressComponentType>(AddressComponentType.UNKNOWN)).registerTypeAdapter((Type)((Object)AddressType.class), new SafeEnumAdapter<AddressType>(AddressType.UNKNOWN)).registerTypeAdapter((Type)((Object)TravelMode.class), new SafeEnumAdapter<TravelMode>(TravelMode.UNKNOWN)).registerTypeAdapter((Type)((Object)LocationType.class), new SafeEnumAdapter<LocationType>(LocationType.UNKNOWN)).registerTypeAdapter((Type)((Object)PlaceDetails.Review.AspectRating.RatingType.class), new SafeEnumAdapter<PlaceDetails.Review.AspectRating.RatingType>(PlaceDetails.Review.AspectRating.RatingType.UNKNOWN)).registerTypeAdapter((Type)((Object)VehicleType.class), new SafeEnumAdapter<VehicleType>(VehicleType.OTHER)).registerTypeAdapter((Type)((Object)OpeningHours.Period.OpenClose.DayOfWeek.class), new DayOfWeekAdapter()).registerTypeAdapter((Type)((Object)PriceLevel.class), new PriceLevelAdapter()).registerTypeAdapter((Type)((Object)Instant.class), new InstantAdapter()).registerTypeAdapter((Type)((Object)LocalTime.class), new LocalTimeAdapter()).registerTypeAdapter((Type)((Object)GeolocationApi.Response.class), new GeolocationResponseAdapter()).registerTypeAdapter((Type)((Object)EncodedPolyline.class), new EncodedPolylineInstanceCreator("")).setFieldNamingPolicy(this.fieldNamingPolicy).create();
        try {
            resp = (ApiResponse)gson.fromJson(new String(bytes, "utf8"), this.responseClass);
        }
        catch (JsonSyntaxException e) {
            if (response.getResponseCode() > 399) {
                throw new IOException(String.format("Server Error: %d %s", response.getResponseCode(), new String(response.getContent(), Charset.defaultCharset())));
            }
            throw e;
        }
        if (resp.successful()) {
            return resp.getResult();
        }
        ApiException e = resp.getError();
        if (this.shouldRetry(e)) {
            return super.retry();
        }
        throw e;
    }

    private T retry() throws IOException, ApiException, InterruptedException {
        ++this.retryCounter;
        LOG.info("Retrying request. Retry #{}", (Object)this.retryCounter);
        this.metrics.startNetwork();
        this.call = this.client.fetchAsync(this.request);
        return this.await();
    }

    private boolean shouldRetry(HTTPResponse response) {
        return RETRY_ERROR_CODES.contains(response.getResponseCode()) && this.cumulativeSleepTime < this.errorTimeOut && (this.maxRetries == null || this.retryCounter < this.maxRetries);
    }

    private boolean shouldRetry(ApiException exception) {
        return this.exceptionsAllowedToRetry.contains(exception.getClass()) && this.cumulativeSleepTime < this.errorTimeOut && (this.maxRetries == null || this.retryCounter < this.maxRetries);
    }
}

