/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.mapper;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;

public class JacksonMappingProvider
implements MappingProvider {
    private final ObjectMapper objectMapper;

    public JacksonMappingProvider() {
        this(new ObjectMapper());
    }

    public JacksonMappingProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T map(Object source2, Class<T> targetType, Configuration configuration) {
        if (source2 == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.convertValue(source2, targetType);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    @Override
    public <T> T map(Object source2, TypeRef<T> targetType, Configuration configuration) {
        if (source2 == null) {
            return null;
        }
        JavaType type = this.objectMapper.getTypeFactory().constructType(targetType.getType());
        try {
            return (T)this.objectMapper.convertValue(source2, type);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }
}

