/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

import com.google.maps.android.AndroidAuthenticationConfig;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class AndroidAuthenticationInterceptor
implements Interceptor {
    private final AndroidAuthenticationConfig config;

    public AndroidAuthenticationInterceptor(AndroidAuthenticationConfig config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.config == AndroidAuthenticationConfig.EMPTY) {
            return chain.proceed(request);
        }
        Request.Builder builder = chain.request().newBuilder();
        if (this.config.packageName != null) {
            builder.addHeader("X-Android-Package", this.config.packageName);
        }
        if (this.config.certFingerprint != null) {
            builder.addHeader("X-Android-Cert", this.config.certFingerprint);
        }
        return chain.proceed(builder.build());
    }
}

