/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.CustomConfigSystemReader;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.SystemReader;

public abstract class RepositoryFactory {
    private static final SystemReader DEFAULT_INSTANCE;
    private static final List<String> VALID_SCHEMES;

    private RepositoryFactory() {
    }

    public static Repository of(GitEndpoint endpoint) {
        if (ObjectHelper.isNotEmpty(endpoint.getGitConfigFile())) {
            return RepositoryFactory.resolveConfigFile(endpoint, endpoint.getGitConfigFile());
        }
        return RepositoryFactory.getRepository(endpoint, DEFAULT_INSTANCE);
    }

    private static Repository resolveConfigFile(GitEndpoint endpoint, String uri) {
        File gitConfigFile;
        if (ObjectHelper.isEmpty(uri)) {
            throw new IllegalArgumentException("URI to git config file must be supplied");
        }
        if (!ResourceHelper.hasScheme(uri) || !VALID_SCHEMES.contains(ResourceHelper.getScheme(uri))) {
            throw new IllegalArgumentException("URI to git config file must have scheme:path pattern where scheme could be classpath, file, http or https");
        }
        String schema = ResourceHelper.getScheme(uri);
        String path = uri.substring(schema.length());
        if (ResourceHelper.isClasspathUri(uri)) {
            gitConfigFile = new File(endpoint.getClass().getClassLoader().getResource(path).getFile());
        } else if (ResourceHelper.isHttpUri(uri)) {
            try {
                gitConfigFile = RepositoryFactory.getTempFileFromHttp(uri);
            }
            catch (IOException e) {
                throw new RuntimeCamelException(String.format("Something went wrong when loading: %s", uri), e);
            }
        } else {
            gitConfigFile = new File(path);
            if (Files.isDirectory(gitConfigFile.toPath(), new LinkOption[0]) || !Files.isReadable(gitConfigFile.toPath())) {
                throw new IllegalArgumentException(String.format("The configuration file at %s is unreadable (either missing, lacking proper access permission or is not a regular file)", path));
            }
        }
        return RepositoryFactory.getRepository(endpoint, new CustomConfigSystemReader(gitConfigFile));
    }

    private static Repository getRepository(GitEndpoint endpoint, SystemReader instance) {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        try {
            SystemReader.setInstance(instance);
            return ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(endpoint.getLocalPath(), ".git"))).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new RuntimeCamelException(String.format("There was an error opening the repository at %s", endpoint.getLocalPath()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getTempFileFromHttp(String url) throws IOException {
        Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
        FileOutputStream outputStream = new FileOutputStream(tempFile.toString());
        try {
            ReadableByteChannel byteChannel = Channels.newChannel(new URL(url).openStream());
            outputStream.getChannel().transferFrom(byteChannel, 0L, Long.MAX_VALUE);
        }
        finally {
            IOHelper.close((Closeable)outputStream);
        }
        return tempFile.toFile();
    }

    static {
        VALID_SCHEMES = Arrays.asList("classpath:", "file:", "http:", "https:");
        DEFAULT_INSTANCE = SystemReader.getInstance();
    }
}

