/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.component.git.consumer.AbstractGitConsumer;
import org.eclipse.jgit.lib.Ref;

public class GitTagConsumer
extends AbstractGitConsumer {
    private final List<String> tagsConsumed = new ArrayList<String>();

    public GitTagConsumer(GitEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected int poll() throws Exception {
        int count = 0;
        Object call = this.getGit().tagList().call();
        Iterator iterator = call.iterator();
        while (iterator.hasNext()) {
            Ref ref = (Ref)iterator.next();
            if (this.tagsConsumed.contains(ref.getName())) continue;
            Exchange e = this.createExchange(true);
            e.getMessage().setBody(ref.getName());
            e.getMessage().setHeader("CamelGitBranchLeaf", ref.getLeaf().getName());
            e.getMessage().setHeader("CamelGitBranchObjectId", ref.getObjectId().getName());
            this.getProcessor().process(e);
            this.tagsConsumed.add(ref.getName());
            ++count;
        }
        return count;
    }
}

