/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import org.apache.camel.Processor;
import org.apache.camel.component.RepositoryFactory;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;

public abstract class AbstractGitConsumer
extends ScheduledPollConsumer {
    private final GitEndpoint endpoint;
    private Repository repo;
    private Git git;

    protected AbstractGitConsumer(GitEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.repo = this.getLocalRepository();
        this.git = new Git(this.repo);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.repo.close();
        this.git.close();
    }

    private Repository getLocalRepository() {
        return RepositoryFactory.of(this.endpoint);
    }

    public Repository getRepository() {
        return this.repo;
    }

    protected Git getGit() {
        return this.git;
    }

    @Override
    protected abstract int poll() throws Exception;
}

