/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.component.git.consumer.AbstractGitConsumer;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitCommitConsumer
extends AbstractGitConsumer {
    private final List<ObjectId> commitsConsumed = new ArrayList<ObjectId>();

    public GitCommitConsumer(GitEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected int poll() throws Exception {
        int count = 0;
        Object commits = ObjectHelper.isNotEmpty(((GitEndpoint)this.getEndpoint()).getBranchName()) ? this.getGit().log().add(this.getGit().getRepository().resolve(((GitEndpoint)this.getEndpoint()).getBranchName())).call() : this.getGit().log().all().call();
        Iterator iterator = commits.iterator();
        while (iterator.hasNext()) {
            RevCommit commit = (RevCommit)iterator.next();
            if (this.commitsConsumed.contains(commit.getId())) continue;
            Exchange e = this.createExchange(true);
            e.getMessage().setBody(commit.getFullMessage());
            e.getMessage().setHeader("CamelGitCommitId", commit.getId());
            e.getMessage().setHeader("CamelGitAuthorName", commit.getAuthorIdent().getName());
            e.getMessage().setHeader("CamelGitCommiterName", commit.getCommitterIdent().getName());
            e.getMessage().setHeader("CamelGitCommitTime", commit.getCommitTime());
            this.getProcessor().process(e);
            this.commitsConsumed.add(commit.getId());
            ++count;
        }
        return count;
    }
}

