/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.component.github.event.GitHubEventFetchStrategy;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.event.Event;
import org.eclipse.egit.github.core.service.EventService;

public class EventsConsumer
extends AbstractGitHubConsumer {
    private final EventService eventService;
    private final GitHubEventFetchStrategy eventFetchStrategy;
    private long lastEventId;

    public EventsConsumer(GitHubEndpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
        Registry registry = endpoint.getCamelContext().getRegistry();
        EventService service = registry.lookupByNameAndType("GitHubEventService", EventService.class);
        this.eventService = service != null ? service : new EventService();
        this.initService(this.eventService);
        GitHubEventFetchStrategy strategy = endpoint.getEventFetchStrategy();
        this.eventFetchStrategy = strategy != null ? strategy : new DefaultGitHubEventFetchStrategy(this.getRepository());
    }

    @Override
    protected int poll() throws Exception {
        ArrayList<Event> newEvents = new ArrayList<Event>();
        PageIterator<Event> iterator = this.eventFetchStrategy.fetchEvents(this.eventService);
        while (iterator.hasNext()) {
            Object events = iterator.next();
            Iterator iterator2 = events.iterator();
            while (iterator2.hasNext()) {
                Event event = (Event)iterator2.next();
                if (Long.parseLong(event.getId()) <= this.lastEventId) continue;
                newEvents.add(event);
            }
        }
        int counter = 0;
        if (!newEvents.isEmpty()) {
            newEvents.sort((e1, e2) -> Long.valueOf(e1.getId()).compareTo(Long.parseLong(e2.getId())));
            Event latestEvent = (Event)newEvents.get(newEvents.size() - 1);
            this.lastEventId = Long.parseLong(latestEvent.getId());
            for (Event event : newEvents) {
                Exchange exchange = this.createExchange(true);
                exchange.getMessage().setBody(event.getType());
                exchange.getMessage().setHeader("CamelGitHubEventPayload", event.getPayload());
                this.getProcessor().process(exchange);
                ++counter;
            }
        }
        return counter;
    }

    private static final class DefaultGitHubEventFetchStrategy
    implements GitHubEventFetchStrategy {
        private final Repository repository;

        private DefaultGitHubEventFetchStrategy(Repository repository) {
            this.repository = repository;
        }

        @Override
        public PageIterator<Event> fetchEvents(EventService eventService) {
            return eventService.pageEvents(this.repository);
        }
    }
}

