/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultProducer;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.RepositoryService;

public abstract class AbstractGitHubProducer
extends DefaultProducer {
    private final GitHubEndpoint endpoint;
    private RepositoryService repositoryService;
    private Repository repository;

    protected AbstractGitHubProducer(GitHubEndpoint endpoint) throws Exception {
        super(endpoint);
        this.endpoint = endpoint;
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubRepositoryService");
        this.repositoryService = service != null ? (RepositoryService)service : new RepositoryService();
        this.initService(this.repositoryService);
        this.repository = this.repositoryService.getRepository(endpoint.getRepoOwner(), endpoint.getRepoName());
    }

    protected void initService(GitHubService service) {
        service.getClient().setOAuth2Token(this.endpoint.getOauthToken());
    }

    protected RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    @Override
    public abstract void process(Exchange var1) throws Exception;
}

