/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.CommitComment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestCommentConsumer
extends AbstractGitHubConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(PullRequestCommentConsumer.class);
    private PullRequestService pullRequestService;
    private IssueService issueService;
    private List<Long> commentIds = new ArrayList<Long>();

    public PullRequestCommentConsumer(GitHubEndpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubPullRequestService");
        if (service != null) {
            LOG.debug("Using PullRequestService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.pullRequestService = (PullRequestService)service;
        } else {
            this.pullRequestService = new PullRequestService();
        }
        this.initService(this.pullRequestService);
        service = registry.lookupByName("githbIssueService");
        this.issueService = service != null ? (IssueService)service : new IssueService();
        this.initService(this.issueService);
        LOG.info("GitHub PullRequestCommentConsumer: Indexing current pull request comments...");
        List<PullRequest> pullRequests = this.pullRequestService.getPullRequests(this.getRepository(), "open");
        for (PullRequest pullRequest : pullRequests) {
            List<CommitComment> commitComments = this.pullRequestService.getComments(this.getRepository(), pullRequest.getNumber());
            for (Comment comment : commitComments) {
                this.commentIds.add(comment.getId());
            }
            List<Comment> comments = this.issueService.getComments((IRepositoryIdProvider)this.getRepository(), pullRequest.getNumber());
            for (Comment comment : comments) {
                this.commentIds.add(comment.getId());
            }
        }
    }

    @Override
    protected int poll() throws Exception {
        HashMap<Long, PullRequest> commentIdToPullRequest = new HashMap<Long, PullRequest>();
        List<PullRequest> pullRequests = this.pullRequestService.getPullRequests(this.getRepository(), "open");
        ArrayDeque<Comment> newComments = new ArrayDeque<Comment>();
        for (PullRequest pullRequest : pullRequests) {
            List<CommitComment> commitComments = this.pullRequestService.getComments(this.getRepository(), pullRequest.getNumber());
            for (Comment comment : commitComments) {
                if (this.commentIds.contains(comment.getId())) continue;
                newComments.add(comment);
                this.commentIds.add(comment.getId());
                commentIdToPullRequest.put(comment.getId(), pullRequest);
            }
            List<Comment> comments = this.issueService.getComments((IRepositoryIdProvider)this.getRepository(), pullRequest.getNumber());
            for (Comment comment : comments) {
                if (this.commentIds.contains(comment.getId())) continue;
                newComments.add(comment);
                this.commentIds.add(comment.getId());
                commentIdToPullRequest.put(comment.getId(), pullRequest);
            }
        }
        int counter = 0;
        while (!newComments.isEmpty()) {
            Comment newComment = (Comment)newComments.pop();
            Exchange e = this.createExchange(true);
            e.getIn().setBody(newComment);
            e.getIn().setHeader("GitHubPullRequest", commentIdToPullRequest.get(newComment.getId()));
            this.getProcessor().process(e);
            ++counter;
        }
        return counter;
    }
}

