/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.producer;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.producer.AbstractGitHubProducer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestFilesProducer
extends AbstractGitHubProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(PullRequestFilesProducer.class);
    private PullRequestService pullRequestService;

    public PullRequestFilesProducer(GitHubEndpoint endpoint) throws Exception {
        super(endpoint);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubPullRequestService");
        if (service != null) {
            LOG.debug("Using PullRequestService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.pullRequestService = (PullRequestService)service;
        } else {
            this.pullRequestService = new PullRequestService();
        }
        this.initService(this.pullRequestService);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Integer pullRequestNumber = exchange.getIn().getHeader("GitHubPullRequest", Integer.class);
        List<CommitFile> response = this.pullRequestService.getFiles(this.getRepository(), pullRequestNumber);
        exchange.getOut().copyFrom(exchange.getIn());
        exchange.getOut().setBody(response);
    }
}

