/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.apache.camel.support.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchGoogleDriveClientFactory
implements GoogleDriveClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BatchGoogleDriveClientFactory.class);
    private NetHttpTransport transport;
    private JacksonFactory jsonFactory;

    public BatchGoogleDriveClientFactory() {
        this.transport = new NetHttpTransport();
        this.jsonFactory = new JacksonFactory();
    }

    public BatchGoogleDriveClientFactory(String proxyHost, int proxyPort) {
        try {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(InetAddress.getByName(proxyHost), proxyPort));
            this.transport = new NetHttpTransport.Builder().setProxy(proxy).build();
            this.jsonFactory = new JacksonFactory();
        }
        catch (UnknownHostException e) {
            LOG.error("Unknow proxy host", (Throwable)e);
        }
    }

    @Override
    public Drive makeClient(String clientId, String clientSecret, Collection<String> scopes, String applicationName, String refreshToken, String accessToken) {
        if (clientId == null || clientSecret == null) {
            throw new IllegalArgumentException("clientId and clientSecret are required to create Google Drive client.");
        }
        try {
            Credential credential = this.authorize(clientId, clientSecret, scopes);
            if (refreshToken != null && !refreshToken.isEmpty()) {
                credential.setRefreshToken(refreshToken);
            }
            if (accessToken != null && !accessToken.isEmpty()) {
                credential.setAccessToken(accessToken);
            }
            return new Drive.Builder(this.transport, this.jsonFactory, credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Google Drive client.", e);
        }
    }

    private Credential authorize(String clientId, String clientSecret, Collection<String> scopes) {
        return new GoogleCredential.Builder().setJsonFactory(this.jsonFactory).setTransport(this.transport).setClientSecrets(clientId, clientSecret).setServiceAccountScopes(scopes).build();
    }

    @Override
    public Drive makeClient(CamelContext camelContext, String serviceAccountKey, Collection<String> scopes, String applicationName, String delegate) {
        if (serviceAccountKey == null) {
            throw new IllegalArgumentException("serviceAccountKey is required to create Gmail client.");
        }
        try {
            Credential credential = this.authorizeServiceAccount(camelContext, serviceAccountKey, delegate, scopes);
            return new Drive.Builder(this.transport, this.jsonFactory, credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Gmail client.", e);
        }
    }

    private Credential authorizeServiceAccount(CamelContext camelContext, String serviceAccountKey, String delegate, Collection<String> scopes) {
        try {
            GoogleCredential cred = GoogleCredential.fromStream(ResourceHelper.resolveMandatoryResourceAsInputStream(camelContext, serviceAccountKey), this.transport, this.jsonFactory).createScoped(scopes != null && !scopes.isEmpty() ? scopes : null).createDelegated(delegate);
            cred.refreshToken();
            return cred;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

