/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.drive.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import com.google.api.services.drive.model.ContentRestriction;
import com.google.api.services.drive.model.Label;
import com.google.api.services.drive.model.Permission;
import com.google.api.services.drive.model.User;
import java.util.List;
import java.util.Map;

public final class File
extends GenericJson {
    @Key
    private Map<String, String> appProperties;
    @Key
    private Capabilities capabilities;
    @Key
    private ContentHints contentHints;
    @Key
    private List<ContentRestriction> contentRestrictions;
    @Key
    private Boolean copyRequiresWriterPermission;
    @Key
    private DateTime createdTime;
    @Key
    private String description;
    @Key
    private String driveId;
    @Key
    private Boolean explicitlyTrashed;
    @Key
    private Map<String, String> exportLinks;
    @Key
    private String fileExtension;
    @Key
    private String folderColorRgb;
    @Key
    private String fullFileExtension;
    @Key
    private Boolean hasAugmentedPermissions;
    @Key
    private Boolean hasThumbnail;
    @Key
    private String headRevisionId;
    @Key
    private String iconLink;
    @Key
    private String id;
    @Key
    private ImageMediaMetadata imageMediaMetadata;
    @Key
    private Boolean isAppAuthorized;
    @Key
    private String kind;
    @Key
    private LabelInfo labelInfo;
    @Key
    private User lastModifyingUser;
    @Key
    private LinkShareMetadata linkShareMetadata;
    @Key
    private String md5Checksum;
    @Key
    private String mimeType;
    @Key
    private Boolean modifiedByMe;
    @Key
    private DateTime modifiedByMeTime;
    @Key
    private DateTime modifiedTime;
    @Key
    private String name;
    @Key
    private String originalFilename;
    @Key
    private Boolean ownedByMe;
    @Key
    private List<User> owners;
    @Key
    private List<String> parents;
    @Key
    private List<String> permissionIds;
    @Key
    private List<Permission> permissions;
    @Key
    private Map<String, String> properties;
    @Key
    @JsonString
    private Long quotaBytesUsed;
    @Key
    private String resourceKey;
    @Key
    private String sha1Checksum;
    @Key
    private String sha256Checksum;
    @Key
    private Boolean shared;
    @Key
    private DateTime sharedWithMeTime;
    @Key
    private User sharingUser;
    @Key
    private ShortcutDetails shortcutDetails;
    @Key
    @JsonString
    private Long size;
    @Key
    private List<String> spaces;
    @Key
    private Boolean starred;
    @Key
    private String teamDriveId;
    @Key
    private String thumbnailLink;
    @Key
    @JsonString
    private Long thumbnailVersion;
    @Key
    private Boolean trashed;
    @Key
    private DateTime trashedTime;
    @Key
    private User trashingUser;
    @Key
    @JsonString
    private Long version;
    @Key
    private VideoMediaMetadata videoMediaMetadata;
    @Key
    private Boolean viewedByMe;
    @Key
    private DateTime viewedByMeTime;
    @Key
    private Boolean viewersCanCopyContent;
    @Key
    private String webContentLink;
    @Key
    private String webViewLink;
    @Key
    private Boolean writersCanShare;

    public Map<String, String> getAppProperties() {
        return this.appProperties;
    }

    public File setAppProperties(Map<String, String> appProperties) {
        this.appProperties = appProperties;
        return this;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public File setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public ContentHints getContentHints() {
        return this.contentHints;
    }

    public File setContentHints(ContentHints contentHints) {
        this.contentHints = contentHints;
        return this;
    }

    public List<ContentRestriction> getContentRestrictions() {
        return this.contentRestrictions;
    }

    public File setContentRestrictions(List<ContentRestriction> contentRestrictions) {
        this.contentRestrictions = contentRestrictions;
        return this;
    }

    public Boolean getCopyRequiresWriterPermission() {
        return this.copyRequiresWriterPermission;
    }

    public File setCopyRequiresWriterPermission(Boolean copyRequiresWriterPermission) {
        this.copyRequiresWriterPermission = copyRequiresWriterPermission;
        return this;
    }

    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    public File setCreatedTime(DateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public File setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDriveId() {
        return this.driveId;
    }

    public File setDriveId(String driveId) {
        this.driveId = driveId;
        return this;
    }

    public Boolean getExplicitlyTrashed() {
        return this.explicitlyTrashed;
    }

    public File setExplicitlyTrashed(Boolean explicitlyTrashed) {
        this.explicitlyTrashed = explicitlyTrashed;
        return this;
    }

    public Map<String, String> getExportLinks() {
        return this.exportLinks;
    }

    public File setExportLinks(Map<String, String> exportLinks) {
        this.exportLinks = exportLinks;
        return this;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public File setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    public String getFolderColorRgb() {
        return this.folderColorRgb;
    }

    public File setFolderColorRgb(String folderColorRgb) {
        this.folderColorRgb = folderColorRgb;
        return this;
    }

    public String getFullFileExtension() {
        return this.fullFileExtension;
    }

    public File setFullFileExtension(String fullFileExtension) {
        this.fullFileExtension = fullFileExtension;
        return this;
    }

    public Boolean getHasAugmentedPermissions() {
        return this.hasAugmentedPermissions;
    }

    public File setHasAugmentedPermissions(Boolean hasAugmentedPermissions) {
        this.hasAugmentedPermissions = hasAugmentedPermissions;
        return this;
    }

    public Boolean getHasThumbnail() {
        return this.hasThumbnail;
    }

    public File setHasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
        return this;
    }

    public String getHeadRevisionId() {
        return this.headRevisionId;
    }

    public File setHeadRevisionId(String headRevisionId) {
        this.headRevisionId = headRevisionId;
        return this;
    }

    public String getIconLink() {
        return this.iconLink;
    }

    public File setIconLink(String iconLink) {
        this.iconLink = iconLink;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public File setId(String id) {
        this.id = id;
        return this;
    }

    public ImageMediaMetadata getImageMediaMetadata() {
        return this.imageMediaMetadata;
    }

    public File setImageMediaMetadata(ImageMediaMetadata imageMediaMetadata) {
        this.imageMediaMetadata = imageMediaMetadata;
        return this;
    }

    public Boolean getIsAppAuthorized() {
        return this.isAppAuthorized;
    }

    public File setIsAppAuthorized(Boolean isAppAuthorized) {
        this.isAppAuthorized = isAppAuthorized;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public File setKind(String kind) {
        this.kind = kind;
        return this;
    }

    public LabelInfo getLabelInfo() {
        return this.labelInfo;
    }

    public File setLabelInfo(LabelInfo labelInfo) {
        this.labelInfo = labelInfo;
        return this;
    }

    public User getLastModifyingUser() {
        return this.lastModifyingUser;
    }

    public File setLastModifyingUser(User lastModifyingUser) {
        this.lastModifyingUser = lastModifyingUser;
        return this;
    }

    public LinkShareMetadata getLinkShareMetadata() {
        return this.linkShareMetadata;
    }

    public File setLinkShareMetadata(LinkShareMetadata linkShareMetadata) {
        this.linkShareMetadata = linkShareMetadata;
        return this;
    }

    public String getMd5Checksum() {
        return this.md5Checksum;
    }

    public File setMd5Checksum(String md5Checksum) {
        this.md5Checksum = md5Checksum;
        return this;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public File setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public Boolean getModifiedByMe() {
        return this.modifiedByMe;
    }

    public File setModifiedByMe(Boolean modifiedByMe) {
        this.modifiedByMe = modifiedByMe;
        return this;
    }

    public DateTime getModifiedByMeTime() {
        return this.modifiedByMeTime;
    }

    public File setModifiedByMeTime(DateTime modifiedByMeTime) {
        this.modifiedByMeTime = modifiedByMeTime;
        return this;
    }

    public DateTime getModifiedTime() {
        return this.modifiedTime;
    }

    public File setModifiedTime(DateTime modifiedTime) {
        this.modifiedTime = modifiedTime;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public File setName(String name) {
        this.name = name;
        return this;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public File setOriginalFilename(String originalFilename) {
        this.originalFilename = originalFilename;
        return this;
    }

    public Boolean getOwnedByMe() {
        return this.ownedByMe;
    }

    public File setOwnedByMe(Boolean ownedByMe) {
        this.ownedByMe = ownedByMe;
        return this;
    }

    public List<User> getOwners() {
        return this.owners;
    }

    public File setOwners(List<User> owners) {
        this.owners = owners;
        return this;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public File setParents(List<String> parents) {
        this.parents = parents;
        return this;
    }

    public List<String> getPermissionIds() {
        return this.permissionIds;
    }

    public File setPermissionIds(List<String> permissionIds) {
        this.permissionIds = permissionIds;
        return this;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public File setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public File setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Long getQuotaBytesUsed() {
        return this.quotaBytesUsed;
    }

    public File setQuotaBytesUsed(Long quotaBytesUsed) {
        this.quotaBytesUsed = quotaBytesUsed;
        return this;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public File setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
        return this;
    }

    public String getSha1Checksum() {
        return this.sha1Checksum;
    }

    public File setSha1Checksum(String sha1Checksum) {
        this.sha1Checksum = sha1Checksum;
        return this;
    }

    public String getSha256Checksum() {
        return this.sha256Checksum;
    }

    public File setSha256Checksum(String sha256Checksum) {
        this.sha256Checksum = sha256Checksum;
        return this;
    }

    public Boolean getShared() {
        return this.shared;
    }

    public File setShared(Boolean shared) {
        this.shared = shared;
        return this;
    }

    public DateTime getSharedWithMeTime() {
        return this.sharedWithMeTime;
    }

    public File setSharedWithMeTime(DateTime sharedWithMeTime) {
        this.sharedWithMeTime = sharedWithMeTime;
        return this;
    }

    public User getSharingUser() {
        return this.sharingUser;
    }

    public File setSharingUser(User sharingUser) {
        this.sharingUser = sharingUser;
        return this;
    }

    public ShortcutDetails getShortcutDetails() {
        return this.shortcutDetails;
    }

    public File setShortcutDetails(ShortcutDetails shortcutDetails) {
        this.shortcutDetails = shortcutDetails;
        return this;
    }

    public Long getSize() {
        return this.size;
    }

    public File setSize(Long size) {
        this.size = size;
        return this;
    }

    public List<String> getSpaces() {
        return this.spaces;
    }

    public File setSpaces(List<String> spaces) {
        this.spaces = spaces;
        return this;
    }

    public Boolean getStarred() {
        return this.starred;
    }

    public File setStarred(Boolean starred) {
        this.starred = starred;
        return this;
    }

    public String getTeamDriveId() {
        return this.teamDriveId;
    }

    public File setTeamDriveId(String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
    }

    public String getThumbnailLink() {
        return this.thumbnailLink;
    }

    public File setThumbnailLink(String thumbnailLink) {
        this.thumbnailLink = thumbnailLink;
        return this;
    }

    public Long getThumbnailVersion() {
        return this.thumbnailVersion;
    }

    public File setThumbnailVersion(Long thumbnailVersion) {
        this.thumbnailVersion = thumbnailVersion;
        return this;
    }

    public Boolean getTrashed() {
        return this.trashed;
    }

    public File setTrashed(Boolean trashed) {
        this.trashed = trashed;
        return this;
    }

    public DateTime getTrashedTime() {
        return this.trashedTime;
    }

    public File setTrashedTime(DateTime trashedTime) {
        this.trashedTime = trashedTime;
        return this;
    }

    public User getTrashingUser() {
        return this.trashingUser;
    }

    public File setTrashingUser(User trashingUser) {
        this.trashingUser = trashingUser;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public File setVersion(Long version) {
        this.version = version;
        return this;
    }

    public VideoMediaMetadata getVideoMediaMetadata() {
        return this.videoMediaMetadata;
    }

    public File setVideoMediaMetadata(VideoMediaMetadata videoMediaMetadata) {
        this.videoMediaMetadata = videoMediaMetadata;
        return this;
    }

    public Boolean getViewedByMe() {
        return this.viewedByMe;
    }

    public File setViewedByMe(Boolean viewedByMe) {
        this.viewedByMe = viewedByMe;
        return this;
    }

    public DateTime getViewedByMeTime() {
        return this.viewedByMeTime;
    }

    public File setViewedByMeTime(DateTime viewedByMeTime) {
        this.viewedByMeTime = viewedByMeTime;
        return this;
    }

    public Boolean getViewersCanCopyContent() {
        return this.viewersCanCopyContent;
    }

    public File setViewersCanCopyContent(Boolean viewersCanCopyContent) {
        this.viewersCanCopyContent = viewersCanCopyContent;
        return this;
    }

    public String getWebContentLink() {
        return this.webContentLink;
    }

    public File setWebContentLink(String webContentLink) {
        this.webContentLink = webContentLink;
        return this;
    }

    public String getWebViewLink() {
        return this.webViewLink;
    }

    public File setWebViewLink(String webViewLink) {
        this.webViewLink = webViewLink;
        return this;
    }

    public Boolean getWritersCanShare() {
        return this.writersCanShare;
    }

    public File setWritersCanShare(Boolean writersCanShare) {
        this.writersCanShare = writersCanShare;
        return this;
    }

    @Override
    public File set(String fieldName, Object value) {
        return (File)super.set(fieldName, value);
    }

    @Override
    public File clone() {
        return (File)super.clone();
    }

    static {
        Data.nullOf(ContentRestriction.class);
    }

    public static final class VideoMediaMetadata
    extends GenericJson {
        @Key
        @JsonString
        private Long durationMillis;
        @Key
        private Integer height;
        @Key
        private Integer width;

        public Long getDurationMillis() {
            return this.durationMillis;
        }

        public VideoMediaMetadata setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public Integer getHeight() {
            return this.height;
        }

        public VideoMediaMetadata setHeight(Integer height) {
            this.height = height;
            return this;
        }

        public Integer getWidth() {
            return this.width;
        }

        public VideoMediaMetadata setWidth(Integer width) {
            this.width = width;
            return this;
        }

        @Override
        public VideoMediaMetadata set(String fieldName, Object value) {
            return (VideoMediaMetadata)super.set(fieldName, value);
        }

        @Override
        public VideoMediaMetadata clone() {
            return (VideoMediaMetadata)super.clone();
        }
    }

    public static final class ShortcutDetails
    extends GenericJson {
        @Key
        private String targetId;
        @Key
        private String targetMimeType;
        @Key
        private String targetResourceKey;

        public String getTargetId() {
            return this.targetId;
        }

        public ShortcutDetails setTargetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public String getTargetMimeType() {
            return this.targetMimeType;
        }

        public ShortcutDetails setTargetMimeType(String targetMimeType) {
            this.targetMimeType = targetMimeType;
            return this;
        }

        public String getTargetResourceKey() {
            return this.targetResourceKey;
        }

        public ShortcutDetails setTargetResourceKey(String targetResourceKey) {
            this.targetResourceKey = targetResourceKey;
            return this;
        }

        @Override
        public ShortcutDetails set(String fieldName, Object value) {
            return (ShortcutDetails)super.set(fieldName, value);
        }

        @Override
        public ShortcutDetails clone() {
            return (ShortcutDetails)super.clone();
        }
    }

    public static final class LinkShareMetadata
    extends GenericJson {
        @Key
        private Boolean securityUpdateEligible;
        @Key
        private Boolean securityUpdateEnabled;

        public Boolean getSecurityUpdateEligible() {
            return this.securityUpdateEligible;
        }

        public LinkShareMetadata setSecurityUpdateEligible(Boolean securityUpdateEligible) {
            this.securityUpdateEligible = securityUpdateEligible;
            return this;
        }

        public Boolean getSecurityUpdateEnabled() {
            return this.securityUpdateEnabled;
        }

        public LinkShareMetadata setSecurityUpdateEnabled(Boolean securityUpdateEnabled) {
            this.securityUpdateEnabled = securityUpdateEnabled;
            return this;
        }

        @Override
        public LinkShareMetadata set(String fieldName, Object value) {
            return (LinkShareMetadata)super.set(fieldName, value);
        }

        @Override
        public LinkShareMetadata clone() {
            return (LinkShareMetadata)super.clone();
        }
    }

    public static final class LabelInfo
    extends GenericJson {
        @Key
        private List<Label> labels;

        public List<Label> getLabels() {
            return this.labels;
        }

        public LabelInfo setLabels(List<Label> labels) {
            this.labels = labels;
            return this;
        }

        @Override
        public LabelInfo set(String fieldName, Object value) {
            return (LabelInfo)super.set(fieldName, value);
        }

        @Override
        public LabelInfo clone() {
            return (LabelInfo)super.clone();
        }
    }

    public static final class ImageMediaMetadata
    extends GenericJson {
        @Key
        private Float aperture;
        @Key
        private String cameraMake;
        @Key
        private String cameraModel;
        @Key
        private String colorSpace;
        @Key
        private Float exposureBias;
        @Key
        private String exposureMode;
        @Key
        private Float exposureTime;
        @Key
        private Boolean flashUsed;
        @Key
        private Float focalLength;
        @Key
        private Integer height;
        @Key
        private Integer isoSpeed;
        @Key
        private String lens;
        @Key
        private Location location;
        @Key
        private Float maxApertureValue;
        @Key
        private String meteringMode;
        @Key
        private Integer rotation;
        @Key
        private String sensor;
        @Key
        private Integer subjectDistance;
        @Key
        private String time;
        @Key
        private String whiteBalance;
        @Key
        private Integer width;

        public Float getAperture() {
            return this.aperture;
        }

        public ImageMediaMetadata setAperture(Float aperture) {
            this.aperture = aperture;
            return this;
        }

        public String getCameraMake() {
            return this.cameraMake;
        }

        public ImageMediaMetadata setCameraMake(String cameraMake) {
            this.cameraMake = cameraMake;
            return this;
        }

        public String getCameraModel() {
            return this.cameraModel;
        }

        public ImageMediaMetadata setCameraModel(String cameraModel) {
            this.cameraModel = cameraModel;
            return this;
        }

        public String getColorSpace() {
            return this.colorSpace;
        }

        public ImageMediaMetadata setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        public Float getExposureBias() {
            return this.exposureBias;
        }

        public ImageMediaMetadata setExposureBias(Float exposureBias) {
            this.exposureBias = exposureBias;
            return this;
        }

        public String getExposureMode() {
            return this.exposureMode;
        }

        public ImageMediaMetadata setExposureMode(String exposureMode) {
            this.exposureMode = exposureMode;
            return this;
        }

        public Float getExposureTime() {
            return this.exposureTime;
        }

        public ImageMediaMetadata setExposureTime(Float exposureTime) {
            this.exposureTime = exposureTime;
            return this;
        }

        public Boolean getFlashUsed() {
            return this.flashUsed;
        }

        public ImageMediaMetadata setFlashUsed(Boolean flashUsed) {
            this.flashUsed = flashUsed;
            return this;
        }

        public Float getFocalLength() {
            return this.focalLength;
        }

        public ImageMediaMetadata setFocalLength(Float focalLength) {
            this.focalLength = focalLength;
            return this;
        }

        public Integer getHeight() {
            return this.height;
        }

        public ImageMediaMetadata setHeight(Integer height) {
            this.height = height;
            return this;
        }

        public Integer getIsoSpeed() {
            return this.isoSpeed;
        }

        public ImageMediaMetadata setIsoSpeed(Integer isoSpeed) {
            this.isoSpeed = isoSpeed;
            return this;
        }

        public String getLens() {
            return this.lens;
        }

        public ImageMediaMetadata setLens(String lens) {
            this.lens = lens;
            return this;
        }

        public Location getLocation() {
            return this.location;
        }

        public ImageMediaMetadata setLocation(Location location) {
            this.location = location;
            return this;
        }

        public Float getMaxApertureValue() {
            return this.maxApertureValue;
        }

        public ImageMediaMetadata setMaxApertureValue(Float maxApertureValue) {
            this.maxApertureValue = maxApertureValue;
            return this;
        }

        public String getMeteringMode() {
            return this.meteringMode;
        }

        public ImageMediaMetadata setMeteringMode(String meteringMode) {
            this.meteringMode = meteringMode;
            return this;
        }

        public Integer getRotation() {
            return this.rotation;
        }

        public ImageMediaMetadata setRotation(Integer rotation) {
            this.rotation = rotation;
            return this;
        }

        public String getSensor() {
            return this.sensor;
        }

        public ImageMediaMetadata setSensor(String sensor) {
            this.sensor = sensor;
            return this;
        }

        public Integer getSubjectDistance() {
            return this.subjectDistance;
        }

        public ImageMediaMetadata setSubjectDistance(Integer subjectDistance) {
            this.subjectDistance = subjectDistance;
            return this;
        }

        public String getTime() {
            return this.time;
        }

        public ImageMediaMetadata setTime(String time) {
            this.time = time;
            return this;
        }

        public String getWhiteBalance() {
            return this.whiteBalance;
        }

        public ImageMediaMetadata setWhiteBalance(String whiteBalance) {
            this.whiteBalance = whiteBalance;
            return this;
        }

        public Integer getWidth() {
            return this.width;
        }

        public ImageMediaMetadata setWidth(Integer width) {
            this.width = width;
            return this;
        }

        @Override
        public ImageMediaMetadata set(String fieldName, Object value) {
            return (ImageMediaMetadata)super.set(fieldName, value);
        }

        @Override
        public ImageMediaMetadata clone() {
            return (ImageMediaMetadata)super.clone();
        }

        public static final class Location
        extends GenericJson {
            @Key
            private Double altitude;
            @Key
            private Double latitude;
            @Key
            private Double longitude;

            public Double getAltitude() {
                return this.altitude;
            }

            public Location setAltitude(Double altitude) {
                this.altitude = altitude;
                return this;
            }

            public Double getLatitude() {
                return this.latitude;
            }

            public Location setLatitude(Double latitude) {
                this.latitude = latitude;
                return this;
            }

            public Double getLongitude() {
                return this.longitude;
            }

            public Location setLongitude(Double longitude) {
                this.longitude = longitude;
                return this;
            }

            @Override
            public Location set(String fieldName, Object value) {
                return (Location)super.set(fieldName, value);
            }

            @Override
            public Location clone() {
                return (Location)super.clone();
            }
        }
    }

    public static final class ContentHints
    extends GenericJson {
        @Key
        private String indexableText;
        @Key
        private Thumbnail thumbnail;

        public String getIndexableText() {
            return this.indexableText;
        }

        public ContentHints setIndexableText(String indexableText) {
            this.indexableText = indexableText;
            return this;
        }

        public Thumbnail getThumbnail() {
            return this.thumbnail;
        }

        public ContentHints setThumbnail(Thumbnail thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        @Override
        public ContentHints set(String fieldName, Object value) {
            return (ContentHints)super.set(fieldName, value);
        }

        @Override
        public ContentHints clone() {
            return (ContentHints)super.clone();
        }

        public static final class Thumbnail
        extends GenericJson {
            @Key
            private String image;
            @Key
            private String mimeType;

            public String getImage() {
                return this.image;
            }

            public byte[] decodeImage() {
                return Base64.decodeBase64(this.image);
            }

            public Thumbnail setImage(String image) {
                this.image = image;
                return this;
            }

            public Thumbnail encodeImage(byte[] image) {
                this.image = Base64.encodeBase64URLSafeString(image);
                return this;
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public Thumbnail setMimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            @Override
            public Thumbnail set(String fieldName, Object value) {
                return (Thumbnail)super.set(fieldName, value);
            }

            @Override
            public Thumbnail clone() {
                return (Thumbnail)super.clone();
            }
        }
    }

    public static final class Capabilities
    extends GenericJson {
        @Key
        private Boolean canAcceptOwnership;
        @Key
        private Boolean canAddChildren;
        @Key
        private Boolean canAddFolderFromAnotherDrive;
        @Key
        private Boolean canAddMyDriveParent;
        @Key
        private Boolean canChangeCopyRequiresWriterPermission;
        @Key
        private Boolean canChangeSecurityUpdateEnabled;
        @Key
        private Boolean canChangeViewersCanCopyContent;
        @Key
        private Boolean canComment;
        @Key
        private Boolean canCopy;
        @Key
        private Boolean canDelete;
        @Key
        private Boolean canDeleteChildren;
        @Key
        private Boolean canDownload;
        @Key
        private Boolean canEdit;
        @Key
        private Boolean canListChildren;
        @Key
        private Boolean canModifyContent;
        @Key
        private Boolean canModifyContentRestriction;
        @Key
        private Boolean canModifyEditorContentRestriction;
        @Key
        private Boolean canModifyLabels;
        @Key
        private Boolean canModifyOwnerContentRestriction;
        @Key
        private Boolean canMoveChildrenOutOfDrive;
        @Key
        private Boolean canMoveChildrenOutOfTeamDrive;
        @Key
        private Boolean canMoveChildrenWithinDrive;
        @Key
        private Boolean canMoveChildrenWithinTeamDrive;
        @Key
        private Boolean canMoveItemIntoTeamDrive;
        @Key
        private Boolean canMoveItemOutOfDrive;
        @Key
        private Boolean canMoveItemOutOfTeamDrive;
        @Key
        private Boolean canMoveItemWithinDrive;
        @Key
        private Boolean canMoveItemWithinTeamDrive;
        @Key
        private Boolean canMoveTeamDriveItem;
        @Key
        private Boolean canReadDrive;
        @Key
        private Boolean canReadLabels;
        @Key
        private Boolean canReadRevisions;
        @Key
        private Boolean canReadTeamDrive;
        @Key
        private Boolean canRemoveChildren;
        @Key
        private Boolean canRemoveContentRestriction;
        @Key
        private Boolean canRemoveMyDriveParent;
        @Key
        private Boolean canRename;
        @Key
        private Boolean canShare;
        @Key
        private Boolean canTrash;
        @Key
        private Boolean canTrashChildren;
        @Key
        private Boolean canUntrash;

        public Boolean getCanAcceptOwnership() {
            return this.canAcceptOwnership;
        }

        public Capabilities setCanAcceptOwnership(Boolean canAcceptOwnership) {
            this.canAcceptOwnership = canAcceptOwnership;
            return this;
        }

        public Boolean getCanAddChildren() {
            return this.canAddChildren;
        }

        public Capabilities setCanAddChildren(Boolean canAddChildren) {
            this.canAddChildren = canAddChildren;
            return this;
        }

        public Boolean getCanAddFolderFromAnotherDrive() {
            return this.canAddFolderFromAnotherDrive;
        }

        public Capabilities setCanAddFolderFromAnotherDrive(Boolean canAddFolderFromAnotherDrive) {
            this.canAddFolderFromAnotherDrive = canAddFolderFromAnotherDrive;
            return this;
        }

        public Boolean getCanAddMyDriveParent() {
            return this.canAddMyDriveParent;
        }

        public Capabilities setCanAddMyDriveParent(Boolean canAddMyDriveParent) {
            this.canAddMyDriveParent = canAddMyDriveParent;
            return this;
        }

        public Boolean getCanChangeCopyRequiresWriterPermission() {
            return this.canChangeCopyRequiresWriterPermission;
        }

        public Capabilities setCanChangeCopyRequiresWriterPermission(Boolean canChangeCopyRequiresWriterPermission) {
            this.canChangeCopyRequiresWriterPermission = canChangeCopyRequiresWriterPermission;
            return this;
        }

        public Boolean getCanChangeSecurityUpdateEnabled() {
            return this.canChangeSecurityUpdateEnabled;
        }

        public Capabilities setCanChangeSecurityUpdateEnabled(Boolean canChangeSecurityUpdateEnabled) {
            this.canChangeSecurityUpdateEnabled = canChangeSecurityUpdateEnabled;
            return this;
        }

        public Boolean getCanChangeViewersCanCopyContent() {
            return this.canChangeViewersCanCopyContent;
        }

        public Capabilities setCanChangeViewersCanCopyContent(Boolean canChangeViewersCanCopyContent) {
            this.canChangeViewersCanCopyContent = canChangeViewersCanCopyContent;
            return this;
        }

        public Boolean getCanComment() {
            return this.canComment;
        }

        public Capabilities setCanComment(Boolean canComment) {
            this.canComment = canComment;
            return this;
        }

        public Boolean getCanCopy() {
            return this.canCopy;
        }

        public Capabilities setCanCopy(Boolean canCopy) {
            this.canCopy = canCopy;
            return this;
        }

        public Boolean getCanDelete() {
            return this.canDelete;
        }

        public Capabilities setCanDelete(Boolean canDelete) {
            this.canDelete = canDelete;
            return this;
        }

        public Boolean getCanDeleteChildren() {
            return this.canDeleteChildren;
        }

        public Capabilities setCanDeleteChildren(Boolean canDeleteChildren) {
            this.canDeleteChildren = canDeleteChildren;
            return this;
        }

        public Boolean getCanDownload() {
            return this.canDownload;
        }

        public Capabilities setCanDownload(Boolean canDownload) {
            this.canDownload = canDownload;
            return this;
        }

        public Boolean getCanEdit() {
            return this.canEdit;
        }

        public Capabilities setCanEdit(Boolean canEdit) {
            this.canEdit = canEdit;
            return this;
        }

        public Boolean getCanListChildren() {
            return this.canListChildren;
        }

        public Capabilities setCanListChildren(Boolean canListChildren) {
            this.canListChildren = canListChildren;
            return this;
        }

        public Boolean getCanModifyContent() {
            return this.canModifyContent;
        }

        public Capabilities setCanModifyContent(Boolean canModifyContent) {
            this.canModifyContent = canModifyContent;
            return this;
        }

        public Boolean getCanModifyContentRestriction() {
            return this.canModifyContentRestriction;
        }

        public Capabilities setCanModifyContentRestriction(Boolean canModifyContentRestriction) {
            this.canModifyContentRestriction = canModifyContentRestriction;
            return this;
        }

        public Boolean getCanModifyEditorContentRestriction() {
            return this.canModifyEditorContentRestriction;
        }

        public Capabilities setCanModifyEditorContentRestriction(Boolean canModifyEditorContentRestriction) {
            this.canModifyEditorContentRestriction = canModifyEditorContentRestriction;
            return this;
        }

        public Boolean getCanModifyLabels() {
            return this.canModifyLabels;
        }

        public Capabilities setCanModifyLabels(Boolean canModifyLabels) {
            this.canModifyLabels = canModifyLabels;
            return this;
        }

        public Boolean getCanModifyOwnerContentRestriction() {
            return this.canModifyOwnerContentRestriction;
        }

        public Capabilities setCanModifyOwnerContentRestriction(Boolean canModifyOwnerContentRestriction) {
            this.canModifyOwnerContentRestriction = canModifyOwnerContentRestriction;
            return this;
        }

        public Boolean getCanMoveChildrenOutOfDrive() {
            return this.canMoveChildrenOutOfDrive;
        }

        public Capabilities setCanMoveChildrenOutOfDrive(Boolean canMoveChildrenOutOfDrive) {
            this.canMoveChildrenOutOfDrive = canMoveChildrenOutOfDrive;
            return this;
        }

        public Boolean getCanMoveChildrenOutOfTeamDrive() {
            return this.canMoveChildrenOutOfTeamDrive;
        }

        public Capabilities setCanMoveChildrenOutOfTeamDrive(Boolean canMoveChildrenOutOfTeamDrive) {
            this.canMoveChildrenOutOfTeamDrive = canMoveChildrenOutOfTeamDrive;
            return this;
        }

        public Boolean getCanMoveChildrenWithinDrive() {
            return this.canMoveChildrenWithinDrive;
        }

        public Capabilities setCanMoveChildrenWithinDrive(Boolean canMoveChildrenWithinDrive) {
            this.canMoveChildrenWithinDrive = canMoveChildrenWithinDrive;
            return this;
        }

        public Boolean getCanMoveChildrenWithinTeamDrive() {
            return this.canMoveChildrenWithinTeamDrive;
        }

        public Capabilities setCanMoveChildrenWithinTeamDrive(Boolean canMoveChildrenWithinTeamDrive) {
            this.canMoveChildrenWithinTeamDrive = canMoveChildrenWithinTeamDrive;
            return this;
        }

        public Boolean getCanMoveItemIntoTeamDrive() {
            return this.canMoveItemIntoTeamDrive;
        }

        public Capabilities setCanMoveItemIntoTeamDrive(Boolean canMoveItemIntoTeamDrive) {
            this.canMoveItemIntoTeamDrive = canMoveItemIntoTeamDrive;
            return this;
        }

        public Boolean getCanMoveItemOutOfDrive() {
            return this.canMoveItemOutOfDrive;
        }

        public Capabilities setCanMoveItemOutOfDrive(Boolean canMoveItemOutOfDrive) {
            this.canMoveItemOutOfDrive = canMoveItemOutOfDrive;
            return this;
        }

        public Boolean getCanMoveItemOutOfTeamDrive() {
            return this.canMoveItemOutOfTeamDrive;
        }

        public Capabilities setCanMoveItemOutOfTeamDrive(Boolean canMoveItemOutOfTeamDrive) {
            this.canMoveItemOutOfTeamDrive = canMoveItemOutOfTeamDrive;
            return this;
        }

        public Boolean getCanMoveItemWithinDrive() {
            return this.canMoveItemWithinDrive;
        }

        public Capabilities setCanMoveItemWithinDrive(Boolean canMoveItemWithinDrive) {
            this.canMoveItemWithinDrive = canMoveItemWithinDrive;
            return this;
        }

        public Boolean getCanMoveItemWithinTeamDrive() {
            return this.canMoveItemWithinTeamDrive;
        }

        public Capabilities setCanMoveItemWithinTeamDrive(Boolean canMoveItemWithinTeamDrive) {
            this.canMoveItemWithinTeamDrive = canMoveItemWithinTeamDrive;
            return this;
        }

        public Boolean getCanMoveTeamDriveItem() {
            return this.canMoveTeamDriveItem;
        }

        public Capabilities setCanMoveTeamDriveItem(Boolean canMoveTeamDriveItem) {
            this.canMoveTeamDriveItem = canMoveTeamDriveItem;
            return this;
        }

        public Boolean getCanReadDrive() {
            return this.canReadDrive;
        }

        public Capabilities setCanReadDrive(Boolean canReadDrive) {
            this.canReadDrive = canReadDrive;
            return this;
        }

        public Boolean getCanReadLabels() {
            return this.canReadLabels;
        }

        public Capabilities setCanReadLabels(Boolean canReadLabels) {
            this.canReadLabels = canReadLabels;
            return this;
        }

        public Boolean getCanReadRevisions() {
            return this.canReadRevisions;
        }

        public Capabilities setCanReadRevisions(Boolean canReadRevisions) {
            this.canReadRevisions = canReadRevisions;
            return this;
        }

        public Boolean getCanReadTeamDrive() {
            return this.canReadTeamDrive;
        }

        public Capabilities setCanReadTeamDrive(Boolean canReadTeamDrive) {
            this.canReadTeamDrive = canReadTeamDrive;
            return this;
        }

        public Boolean getCanRemoveChildren() {
            return this.canRemoveChildren;
        }

        public Capabilities setCanRemoveChildren(Boolean canRemoveChildren) {
            this.canRemoveChildren = canRemoveChildren;
            return this;
        }

        public Boolean getCanRemoveContentRestriction() {
            return this.canRemoveContentRestriction;
        }

        public Capabilities setCanRemoveContentRestriction(Boolean canRemoveContentRestriction) {
            this.canRemoveContentRestriction = canRemoveContentRestriction;
            return this;
        }

        public Boolean getCanRemoveMyDriveParent() {
            return this.canRemoveMyDriveParent;
        }

        public Capabilities setCanRemoveMyDriveParent(Boolean canRemoveMyDriveParent) {
            this.canRemoveMyDriveParent = canRemoveMyDriveParent;
            return this;
        }

        public Boolean getCanRename() {
            return this.canRename;
        }

        public Capabilities setCanRename(Boolean canRename) {
            this.canRename = canRename;
            return this;
        }

        public Boolean getCanShare() {
            return this.canShare;
        }

        public Capabilities setCanShare(Boolean canShare) {
            this.canShare = canShare;
            return this;
        }

        public Boolean getCanTrash() {
            return this.canTrash;
        }

        public Capabilities setCanTrash(Boolean canTrash) {
            this.canTrash = canTrash;
            return this;
        }

        public Boolean getCanTrashChildren() {
            return this.canTrashChildren;
        }

        public Capabilities setCanTrashChildren(Boolean canTrashChildren) {
            this.canTrashChildren = canTrashChildren;
            return this;
        }

        public Boolean getCanUntrash() {
            return this.canUntrash;
        }

        public Capabilities setCanUntrash(Boolean canUntrash) {
            this.canUntrash = canUntrash;
            return this;
        }

        @Override
        public Capabilities set(String fieldName, Object value) {
            return (Capabilities)super.set(fieldName, value);
        }

        @Override
        public Capabilities clone() {
            return (Capabilities)super.clone();
        }
    }
}

