/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.drive.Drive;
import java.io.File;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractiveGoogleDriveClientFactory
implements GoogleDriveClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InteractiveGoogleDriveClientFactory.class);
    private static final File DATA_STORE_DIR = new File(".google_drive");
    private NetHttpTransport transport = new NetHttpTransport();
    private JacksonFactory jsonFactory = new JacksonFactory();
    private FileDataStoreFactory dataStoreFactory;

    @Override
    public Drive makeClient(String clientId, String clientSecret, Collection<String> scopes, String applicationName, String refreshToken, String accessToken) {
        try {
            Credential credential = this.authorize(clientId, clientSecret, scopes);
            return new Drive.Builder(this.transport, this.jsonFactory, credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            LOG.error("Could not create Google Drive client.", (Throwable)e);
            return null;
        }
    }

    private Credential authorize(String clientId, String clientSecret, Collection<String> scopes) throws Exception {
        this.dataStoreFactory = new FileDataStoreFactory(DATA_STORE_DIR);
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(this.transport, this.jsonFactory, clientId, clientSecret, scopes).setDataStoreFactory(this.dataStoreFactory).setAccessType("offline").build();
        return new AuthorizationCodeInstalledApp(flow, new LocalServerReceiver()).authorize("user");
    }

    @Override
    public Drive makeClient(CamelContext camelContext, String serviceAccountKey, Collection<String> scopes, String applicationName, String delegate) {
        throw new IllegalArgumentException("Not implemented");
    }
}

