/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFormatTransformer
extends Transformer {
    private static final Logger LOG = LoggerFactory.getLogger(DataFormatTransformer.class);
    private DataFormat dataFormat;
    private String transformerString;

    public DataFormatTransformer() {
    }

    public DataFormatTransformer(CamelContext context) {
        this.setCamelContext(context);
    }

    @Override
    public void transform(Message message, DataType from, DataType to) throws Exception {
        Exchange exchange = message.getExchange();
        CamelContext context = exchange.getContext();
        if ((DataType.isAnyType(to) || to.isJavaType()) && (from.equals(this.getFrom()) || from.getScheme().equals(this.getName()))) {
            Class<?> toClass;
            LOG.debug("Unmarshaling with: {}", (Object)this.dataFormat);
            Object answer = this.dataFormat.unmarshal(exchange, message.getBody());
            if (!DataType.isAnyType(to) && to.getName() != null && !(toClass = context.getClassResolver().resolveClass(to.getName())).isAssignableFrom(answer.getClass())) {
                LOG.debug("Converting to: {}", (Object)toClass.getName());
                answer = context.getTypeConverter().mandatoryConvertTo(toClass, answer);
            }
            message.setBody(answer);
        } else if ((DataType.isAnyType(from) || from.isJavaType()) && (to.equals(this.getTo()) || to.getScheme().equals(this.getName()))) {
            Class<?> fromClass;
            Object input = message.getBody();
            if (!DataType.isAnyType(from) && from.getName() != null && !(fromClass = context.getClassResolver().resolveClass(from.getName())).isAssignableFrom(input.getClass())) {
                LOG.debug("Converting to: {}", (Object)fromClass.getName());
                input = context.getTypeConverter().mandatoryConvertTo(fromClass, input);
            }
            OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange);
            LOG.debug("Marshaling with: {}", (Object)this.dataFormat);
            this.dataFormat.marshal(exchange, input, osb);
            message.setBody(osb.build());
        } else {
            throw new IllegalArgumentException("Unsupported transformation: from='" + from + ", to='" + to + "'");
        }
    }

    public DataFormatTransformer setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
        this.transformerString = null;
        return this;
    }

    @Override
    public String toString() {
        if (this.transformerString == null) {
            this.transformerString = String.format("DataFormatTransformer[name='%s', from='%s', to='%s', dataFormat='%s']", this.getName(), this.getFrom(), this.getTo(), this.dataFormat);
        }
        return this.transformerString;
    }

    @Override
    public void doStart() throws Exception {
        ObjectHelper.notNull(this.dataFormat, "dataFormat");
        this.getCamelContext().addService(this.dataFormat, false);
    }

    @Override
    public void doStop() throws Exception {
        ServiceHelper.stopService(this.dataFormat);
        this.getCamelContext().removeService(this.dataFormat);
    }
}

