/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail;

import java.util.Collection;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.apache.camel.component.google.mail.GoogleMailComponent;
import org.apache.camel.component.google.mail.GoogleMailConfiguration;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class GoogleMailComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private GoogleMailConfiguration getOrCreateConfiguration(GoogleMailComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new GoogleMailConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        GoogleMailComponent target = (GoogleMailComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                this.getOrCreateConfiguration(target).setAccessToken(GoogleMailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "applicationname": 
            case "applicationName": {
                this.getOrCreateConfiguration(target).setApplicationName(GoogleMailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(GoogleMailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(GoogleMailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "clientfactory": 
            case "clientFactory": {
                target.setClientFactory(GoogleMailComponentConfigurer.property(camelContext, GoogleMailClientFactory.class, value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                this.getOrCreateConfiguration(target).setClientId(GoogleMailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "clientsecret": 
            case "clientSecret": {
                this.getOrCreateConfiguration(target).setClientSecret(GoogleMailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(GoogleMailComponentConfigurer.property(camelContext, GoogleMailConfiguration.class, value));
                return true;
            }
            case "delegate": {
                this.getOrCreateConfiguration(target).setDelegate(GoogleMailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(GoogleMailComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "refreshtoken": 
            case "refreshToken": {
                this.getOrCreateConfiguration(target).setRefreshToken(GoogleMailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "scopes": {
                this.getOrCreateConfiguration(target).setScopes(GoogleMailComponentConfigurer.property(camelContext, Collection.class, value));
                return true;
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                this.getOrCreateConfiguration(target).setServiceAccountKey(GoogleMailComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                return String.class;
            }
            case "applicationname": 
            case "applicationName": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "clientfactory": 
            case "clientFactory": {
                return GoogleMailClientFactory.class;
            }
            case "clientid": 
            case "clientId": {
                return String.class;
            }
            case "clientsecret": 
            case "clientSecret": {
                return String.class;
            }
            case "configuration": {
                return GoogleMailConfiguration.class;
            }
            case "delegate": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "refreshtoken": 
            case "refreshToken": {
                return String.class;
            }
            case "scopes": {
                return Collection.class;
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        GoogleMailComponent target = (GoogleMailComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                return this.getOrCreateConfiguration(target).getAccessToken();
            }
            case "applicationname": 
            case "applicationName": {
                return this.getOrCreateConfiguration(target).getApplicationName();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "clientfactory": 
            case "clientFactory": {
                return target.getClientFactory();
            }
            case "clientid": 
            case "clientId": {
                return this.getOrCreateConfiguration(target).getClientId();
            }
            case "clientsecret": 
            case "clientSecret": {
                return this.getOrCreateConfiguration(target).getClientSecret();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "delegate": {
                return this.getOrCreateConfiguration(target).getDelegate();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "refreshtoken": 
            case "refreshToken": {
                return this.getOrCreateConfiguration(target).getRefreshToken();
            }
            case "scopes": {
                return this.getOrCreateConfiguration(target).getScopes();
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                return this.getOrCreateConfiguration(target).getServiceAccountKey();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "scopes": {
                return String.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("ApplicationName", String.class);
        map.put("ClientId", String.class);
        map.put("Configuration", GoogleMailConfiguration.class);
        map.put("Delegate", String.class);
        map.put("Scopes", Collection.class);
        map.put("BridgeErrorHandler", Boolean.TYPE);
        map.put("LazyStartProducer", Boolean.TYPE);
        map.put("AutowiredEnabled", Boolean.TYPE);
        map.put("ClientFactory", GoogleMailClientFactory.class);
        map.put("AccessToken", String.class);
        map.put("ClientSecret", String.class);
        map.put("RefreshToken", String.class);
        map.put("ServiceAccountKey", String.class);
        ALL_OPTIONS = map;
    }
}

