/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFunction;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.pubsub.v1.PubsubMessage;
import io.opencensus.common.Scope;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import io.opencensus.tags.propagation.TagContextBinarySerializer;
import io.opencensus.trace.Link;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.propagation.SpanContextParseException;
import io.opencensus.trace.propagation.TextFormat;
import io.opencensus.trace.samplers.Samplers;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenCensusUtil {
    private static final Logger logger = Logger.getLogger(OpenCensusUtil.class.getName());
    public static final String TAG_CONTEXT_KEY = "googclient_OpenCensusTagContextKey";
    public static final String TRACE_CONTEXT_KEY = "googclient_OpenCensusTraceContextKey";
    @VisibleForTesting
    static final String MESSAGE_RECEIVER_SPAN_NAME = "OpenCensusMessageReceiver";
    private static final String TRACEPARENT_KEY = "traceparent";
    private static final Tagger tagger = Tags.getTagger();
    private static final TagContextBinarySerializer serializer = Tags.getTagPropagationComponent().getBinarySerializer();
    private static final Tracer tracer = Tracing.getTracer();
    private static final TextFormat traceContextTextFormat = Tracing.getPropagationComponent().getTraceContextFormat();
    public static final ApiFunction<PubsubMessage, PubsubMessage> OPEN_CENSUS_MESSAGE_TRANSFORM = new ApiFunction<PubsubMessage, PubsubMessage>(){

        @Override
        public PubsubMessage apply(PubsubMessage message) {
            PubsubMessage.Builder builder = PubsubMessage.newBuilder(message);
            String encodedSpanContext = OpenCensusUtil.encodeSpanContext(tracer.getCurrentSpan().getContext());
            String encodedTagContext = OpenCensusUtil.encodeTagContext(tagger.getCurrentTagContext());
            if (encodedSpanContext.isEmpty() && encodedTagContext.isEmpty()) {
                return message;
            }
            if (!encodedSpanContext.isEmpty()) {
                builder.putAttributes(OpenCensusUtil.TRACE_CONTEXT_KEY, encodedSpanContext);
            }
            if (!encodedTagContext.isEmpty()) {
                builder.putAttributes(OpenCensusUtil.TAG_CONTEXT_KEY, encodedTagContext);
            }
            return builder.build();
        }
    };
    private static final TextFormat.Setter<StringBuilder> setter = new TextFormat.Setter<StringBuilder>(){

        @Override
        public void put(StringBuilder carrier, String key, String value) {
            if (key.equals(OpenCensusUtil.TRACEPARENT_KEY)) {
                carrier.append(value);
            }
        }
    };
    private static final TextFormat.Getter<String> getter = new TextFormat.Getter<String>(){

        @Override
        public String get(String carrier, String key) {
            return key.equals(OpenCensusUtil.TRACEPARENT_KEY) ? carrier : null;
        }
    };

    @VisibleForTesting
    static String encodeSpanContext(SpanContext ctxt) {
        StringBuilder builder = new StringBuilder();
        traceContextTextFormat.inject(ctxt, builder, setter);
        return builder.toString();
    }

    private static String encodeTagContext(TagContext tags) {
        return "";
    }

    private static Scope createScopedTagContext(String encodedTags) {
        return tagger.withTagContext(tagger.getCurrentTagContext());
    }

    @VisibleForTesting
    @MustBeClosed
    static Scope createScopedSpan(String name) {
        return tracer.spanBuilderWithExplicitParent(name, tracer.getCurrentSpan()).setRecordEvents(true).setSampler(Samplers.alwaysSample()).startScopedSpan();
    }

    private static void addParentLink(String encodedParentSpanContext) {
        try {
            SpanContext ctxt = traceContextTextFormat.extract(encodedParentSpanContext, getter);
            tracer.getCurrentSpan().addLink(Link.fromSpanContext(ctxt, Link.Type.PARENT_LINKED_SPAN));
        }
        catch (SpanContextParseException exn) {
            logger.log(Level.INFO, "OpenCensus: Trace Context Deserialization Exception: " + exn);
        }
    }

    public static class OpenCensusMessageReceiver
    implements MessageReceiver {
        private final MessageReceiver receiver;

        public OpenCensusMessageReceiver(MessageReceiver receiver) {
            this.receiver = receiver;
        }

        @Override
        public void receiveMessage(PubsubMessage message, AckReplyConsumer consumer) {
            String encodedTagContext = message.getAttributesOrDefault(OpenCensusUtil.TAG_CONTEXT_KEY, "");
            if (encodedTagContext.isEmpty()) {
                this.addTraceScope(message, consumer);
                return;
            }
            try (Scope statsScope = OpenCensusUtil.createScopedTagContext(encodedTagContext);){
                this.addTraceScope(message, consumer);
            }
        }

        private void addTraceScope(PubsubMessage message, AckReplyConsumer consumer) {
            String encodedSpanContext = message.getAttributesOrDefault(OpenCensusUtil.TRACE_CONTEXT_KEY, "");
            if (encodedSpanContext.isEmpty()) {
                this.receiver.receiveMessage(message, consumer);
                return;
            }
            try (Scope spanScope = OpenCensusUtil.createScopedSpan(OpenCensusUtil.MESSAGE_RECEIVER_SPAN_NAME);){
                OpenCensusUtil.addParentLink(encodedSpanContext);
                this.receiver.receiveMessage(message, consumer);
            }
        }
    }
}

