/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SchemaName
implements ResourceName {
    private static final PathTemplate PROJECT_SCHEMA = PathTemplate.createWithoutUrlEncoding("projects/{project}/schemas/{schema}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String schema;

    @Deprecated
    protected SchemaName() {
        this.project = null;
        this.schema = null;
    }

    private SchemaName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.schema = Preconditions.checkNotNull(builder.getSchema());
    }

    public String getProject() {
        return this.project;
    }

    public String getSchema() {
        return this.schema;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SchemaName of(String project, String schema) {
        return SchemaName.newBuilder().setProject(project).setSchema(schema).build();
    }

    public static String format(String project, String schema) {
        return SchemaName.newBuilder().setProject(project).setSchema(schema).build().toString();
    }

    public static SchemaName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_SCHEMA.validatedMatch(formattedString, "SchemaName.parse: formattedString not in valid format");
        return SchemaName.of(matchMap.get("project"), matchMap.get("schema"));
    }

    public static List<SchemaName> parseList(List<String> formattedStrings) {
        ArrayList<SchemaName> list = new ArrayList<SchemaName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SchemaName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SchemaName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SchemaName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SCHEMA.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SchemaName schemaName = this;
            synchronized (schemaName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.schema != null) {
                        fieldMapBuilder.put("schema", this.schema);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_SCHEMA.instantiate("project", this.project, "schema", this.schema);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SchemaName that = (SchemaName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.schema, that.schema);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.schema);
    }

    public static class Builder {
        private String project;
        private String schema;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSchema() {
            return this.schema;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        private Builder(SchemaName schemaName) {
            this.project = schemaName.project;
            this.schema = schemaName.schema;
        }

        public SchemaName build() {
            return new SchemaName(this);
        }
    }
}

