/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.stub.HttpJsonPublisherCallableFactory;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.TypeRegistry;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.DetachSubscriptionRequest;
import com.google.pubsub.v1.DetachSubscriptionResponse;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSnapshotsRequest;
import com.google.pubsub.v1.ListTopicSnapshotsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.UpdateTopicRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonPublisherStub
extends PublisherStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<Topic, Topic> createTopicMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Publisher/CreateTopic").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/topics/*}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearName().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Topic.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateTopicRequest, Topic> updateTopicMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Publisher/UpdateTopic").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{topic.name=projects/*/topics/*}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "topic.name", request.getTopic().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Topic.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PublishRequest, PublishResponse> publishMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Publisher/Publish").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{topic=projects/*/topics/*}:publish", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "topic", request.getTopic());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearTopic().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(PublishResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTopicRequest, Topic> getTopicMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Publisher/GetTopic").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{topic=projects/*/topics/*}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "topic", request.getTopic());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Topic.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTopicsRequest, ListTopicsResponse> listTopicsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Publisher/ListTopics").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{project=projects/*}/topics", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", request.getPageToken());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(ListTopicsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Publisher/ListTopicSubscriptions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{topic=projects/*/topics/*}/subscriptions", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "topic", request.getTopic());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", request.getPageToken());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(ListTopicSubscriptionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Publisher/ListTopicSnapshots").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{topic=projects/*/topics/*}/snapshots", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "topic", request.getTopic());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", request.getPageToken());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(ListTopicSnapshotsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteTopicRequest, Empty> deleteTopicMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Publisher/DeleteTopic").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{topic=projects/*/topics/*}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "topic", request.getTopic());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Publisher/DetachSubscription").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription=projects/*/subscriptions/*}:detach", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription", request.getSubscription());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(DetachSubscriptionResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/topics/*}:setIamPolicy", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", request.getResource());
        return fields;
    }).setAdditionalPaths("/v1/{resource=projects/*/subscriptions/*}:setIamPolicy", "/v1/{resource=projects/*/snapshots/*}:setIamPolicy", "/v1/{resource=projects/*/schemas/*}:setIamPolicy").setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearResource().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/topics/*}:getIamPolicy", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", request.getResource());
        return fields;
    }).setAdditionalPaths("/v1/{resource=projects/*/subscriptions/*}:getIamPolicy", "/v1/{resource=projects/*/snapshots/*}:getIamPolicy", "/v1/{resource=projects/*/schemas/*}:getIamPolicy").setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/subscriptions/*}:testIamPermissions", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", request.getResource());
        return fields;
    }).setAdditionalPaths("/v1/{resource=projects/*/topics/*}:testIamPermissions", "/v1/{resource=projects/*/snapshots/*}:testIamPermissions", "/v1/{resource=projects/*/schemas/*}:testIamPermissions").setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearResource().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<Topic, Topic> createTopicCallable;
    private final UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable;
    private final UnaryCallable<PublishRequest, PublishResponse> publishCallable;
    private final UnaryCallable<GetTopicRequest, Topic> getTopicCallable;
    private final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable;
    private final UnaryCallable<ListTopicsRequest, TopicAdminClient.ListTopicsPagedResponse> listTopicsPagedCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable;
    private final UnaryCallable<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsCallable;
    private final UnaryCallable<ListTopicSnapshotsRequest, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsPagedCallable;
    private final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable;
    private final UnaryCallable<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonPublisherStub create(PublisherStubSettings settings) throws IOException {
        return new HttpJsonPublisherStub(settings, ClientContext.create(settings));
    }

    public static final HttpJsonPublisherStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonPublisherStub(PublisherStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonPublisherStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonPublisherStub(PublisherStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonPublisherStub(PublisherStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonPublisherCallableFactory());
    }

    protected HttpJsonPublisherStub(PublisherStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings<Topic, Topic> createTopicTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTopicMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<UpdateTopicRequest, Topic> updateTopicTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateTopicMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic.name", String.valueOf(request.getTopic().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<PublishRequest, PublishResponse> publishTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(publishMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<GetTopicRequest, Topic> getTopicTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTopicMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<ListTopicsRequest, ListTopicsResponse> listTopicsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTopicsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTopicSubscriptionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTopicSnapshotsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<DeleteTopicRequest, Empty> deleteTopicTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTopicMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic", String.valueOf(request.getTopic()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(detachSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("subscription", String.valueOf(request.getSubscription()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<SetIamPolicyRequest, Policy> setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<GetIamPolicyRequest, Policy> getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createTopicCallable = callableFactory.createUnaryCallable(createTopicTransportSettings, settings.createTopicSettings(), clientContext);
        this.updateTopicCallable = callableFactory.createUnaryCallable(updateTopicTransportSettings, settings.updateTopicSettings(), clientContext);
        this.publishCallable = callableFactory.createBatchingCallable(publishTransportSettings, settings.publishSettings(), clientContext);
        this.getTopicCallable = callableFactory.createUnaryCallable(getTopicTransportSettings, settings.getTopicSettings(), clientContext);
        this.listTopicsCallable = callableFactory.createUnaryCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.listTopicsPagedCallable = callableFactory.createPagedCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.listTopicSubscriptionsCallable = callableFactory.createUnaryCallable(listTopicSubscriptionsTransportSettings, settings.listTopicSubscriptionsSettings(), clientContext);
        this.listTopicSubscriptionsPagedCallable = callableFactory.createPagedCallable(listTopicSubscriptionsTransportSettings, settings.listTopicSubscriptionsSettings(), clientContext);
        this.listTopicSnapshotsCallable = callableFactory.createUnaryCallable(listTopicSnapshotsTransportSettings, settings.listTopicSnapshotsSettings(), clientContext);
        this.listTopicSnapshotsPagedCallable = callableFactory.createPagedCallable(listTopicSnapshotsTransportSettings, settings.listTopicSnapshotsSettings(), clientContext);
        this.deleteTopicCallable = callableFactory.createUnaryCallable(deleteTopicTransportSettings, settings.deleteTopicSettings(), clientContext);
        this.detachSubscriptionCallable = callableFactory.createUnaryCallable(detachSubscriptionTransportSettings, settings.detachSubscriptionSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createTopicMethodDescriptor);
        methodDescriptors.add(updateTopicMethodDescriptor);
        methodDescriptors.add(publishMethodDescriptor);
        methodDescriptors.add(getTopicMethodDescriptor);
        methodDescriptors.add(listTopicsMethodDescriptor);
        methodDescriptors.add(listTopicSubscriptionsMethodDescriptor);
        methodDescriptors.add(listTopicSnapshotsMethodDescriptor);
        methodDescriptors.add(deleteTopicMethodDescriptor);
        methodDescriptors.add(detachSubscriptionMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<Topic, Topic> createTopicCallable() {
        return this.createTopicCallable;
    }

    @Override
    public UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable() {
        return this.updateTopicCallable;
    }

    @Override
    public UnaryCallable<PublishRequest, PublishResponse> publishCallable() {
        return this.publishCallable;
    }

    @Override
    public UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.getTopicCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.listTopicsCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, TopicAdminClient.ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.listTopicsPagedCallable;
    }

    @Override
    public UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable() {
        return this.listTopicSubscriptionsCallable;
    }

    @Override
    public UnaryCallable<ListTopicSubscriptionsRequest, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable() {
        return this.listTopicSubscriptionsPagedCallable;
    }

    @Override
    public UnaryCallable<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsCallable() {
        return this.listTopicSnapshotsCallable;
    }

    @Override
    public UnaryCallable<ListTopicSnapshotsRequest, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsPagedCallable() {
        return this.listTopicSnapshotsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.deleteTopicCallable;
    }

    @Override
    public UnaryCallable<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionCallable() {
        return this.detachSubscriptionCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

