/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectSubscriptionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/subscriptions/{subscription}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String subscription;

    public String getProject() {
        return this.project;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectSubscriptionName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.subscription = Preconditions.checkNotNull(builder.getSubscription());
    }

    public static ProjectSubscriptionName of(String project, String subscription) {
        return ProjectSubscriptionName.newBuilder().setProject(project).setSubscription(subscription).build();
    }

    public static String format(String project, String subscription) {
        return ProjectSubscriptionName.newBuilder().setProject(project).setSubscription(subscription).build().toString();
    }

    public static ProjectSubscriptionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectSubscriptionName.parse: formattedString not in valid format");
        return ProjectSubscriptionName.of(matchMap.get("project"), matchMap.get("subscription"));
    }

    public static List<ProjectSubscriptionName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectSubscriptionName> list = new ArrayList<ProjectSubscriptionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectSubscriptionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectSubscriptionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectSubscriptionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectSubscriptionName projectSubscriptionName = this;
            synchronized (projectSubscriptionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put("project", this.project);
                    fieldMapBuilder.put("subscription", this.subscription);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate("project", this.project, "subscription", this.subscription);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectSubscriptionName) {
            ProjectSubscriptionName that = (ProjectSubscriptionName)o;
            return this.project.equals(that.project) && this.subscription.equals(that.subscription);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.project.hashCode();
        h2 *= 1000003;
        return h2 ^= this.subscription.hashCode();
    }

    public static class Builder {
        private String project;
        private String subscription;

        public String getProject() {
            return this.project;
        }

        public String getSubscription() {
            return this.subscription;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectSubscriptionName projectSubscriptionName) {
            this.project = projectSubscriptionName.project;
            this.subscription = projectSubscriptionName.subscription;
        }

        public ProjectSubscriptionName build() {
            return new ProjectSubscriptionName(this);
        }
    }
}

