/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.stream;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.BatchGetValuesResponse;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConfiguration;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamEndpoint;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;

public class GoogleSheetsStreamConsumer
extends ScheduledBatchPollingConsumer {
    public GoogleSheetsStreamConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    protected GoogleSheetsStreamConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected Sheets getClient() {
        return this.getEndpoint().getClient();
    }

    @Override
    public GoogleSheetsStreamEndpoint getEndpoint() {
        return (GoogleSheetsStreamEndpoint)super.getEndpoint();
    }

    @Override
    protected int poll() throws Exception {
        ArrayDeque<Exchange> answer = new ArrayDeque<Exchange>();
        if (ObjectHelper.isNotEmpty(this.getConfiguration().getRange())) {
            Sheets.Spreadsheets.Values.BatchGet request = this.getClient().spreadsheets().values().batchGet(this.getConfiguration().getSpreadsheetId());
            request.setMajorDimension(this.getConfiguration().getMajorDimension());
            request.setValueRenderOption(this.getConfiguration().getValueRenderOption());
            if (this.getConfiguration().getRange().contains(",")) {
                request.setRanges(Arrays.stream(this.getConfiguration().getRange().split(",")).map(String::trim).collect(Collectors.toList()));
            } else {
                request.setRanges(Collections.singletonList(this.getConfiguration().getRange()));
            }
            BatchGetValuesResponse response = (BatchGetValuesResponse)request.execute();
            this.forceConsumerAsReady();
            if (response.getValueRanges() != null) {
                if (this.getConfiguration().isSplitResults()) {
                    for (ValueRange valueRange2 : response.getValueRanges()) {
                        AtomicInteger rangeIndex = new AtomicInteger(1);
                        AtomicInteger valueIndex = new AtomicInteger();
                        if (this.getConfiguration().getMaxResults() > 0) {
                            valueRange2.getValues().stream().limit(this.getConfiguration().getMaxResults()).map(values -> this.createExchange(rangeIndex.get(), valueIndex.incrementAndGet(), valueRange2.getRange(), valueRange2.getMajorDimension(), (List<Object>)values)).forEach(answer::add);
                        } else {
                            valueRange2.getValues().stream().map(values -> this.createExchange(rangeIndex.get(), valueIndex.incrementAndGet(), valueRange2.getRange(), valueRange2.getMajorDimension(), (List<Object>)values)).forEach(answer::add);
                        }
                        rangeIndex.incrementAndGet();
                    }
                } else {
                    AtomicInteger rangeIndex = new AtomicInteger();
                    response.getValueRanges().stream().peek(valueRange -> {
                        if (this.getConfiguration().getMaxResults() > 0) {
                            valueRange.setValues(valueRange.getValues().stream().limit(this.getConfiguration().getMaxResults()).collect(Collectors.toList()));
                        }
                    }).map(valueRange -> this.createExchange(rangeIndex.incrementAndGet(), (ValueRange)valueRange)).forEach(answer::add);
                }
            }
        } else {
            Sheets.Spreadsheets.Get request = this.getClient().spreadsheets().get(this.getConfiguration().getSpreadsheetId());
            request.setIncludeGridData(this.getConfiguration().isIncludeGridData());
            Spreadsheet spreadsheet = (Spreadsheet)request.execute();
            answer.add(this.createExchange(spreadsheet));
        }
        return this.processBatch(CastUtils.cast(answer));
    }

    @Override
    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = ObjectHelper.cast(Exchange.class, exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
        }
        return total;
    }

    public Exchange createExchange(int rangeIndex, ValueRange valueRange) {
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(this.getEndpoint().getExchangePattern());
        Message message = exchange.getIn();
        exchange.getIn().setHeader("CamelGoogleSheetsSpreadsheetId", this.getEndpoint().getConfiguration().getSpreadsheetId());
        exchange.getIn().setHeader("CamelGoogleSheetsRange", valueRange.getRange());
        exchange.getIn().setHeader("CamelGoogleSheetsRangeIndex", rangeIndex);
        exchange.getIn().setHeader("CamelGoogleSheetsMajorDimension", valueRange.getMajorDimension());
        message.setBody(valueRange);
        return exchange;
    }

    public Exchange createExchange(int rangeIndex, int valueIndex, String range, String majorDimension, List<Object> values) {
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(this.getEndpoint().getExchangePattern());
        Message message = exchange.getIn();
        exchange.getIn().setHeader("CamelGoogleSheetsSpreadsheetId", this.getEndpoint().getConfiguration().getSpreadsheetId());
        exchange.getIn().setHeader("CamelGoogleSheetsRangeIndex", rangeIndex);
        exchange.getIn().setHeader("CamelGoogleSheetsValueIndex", valueIndex);
        exchange.getIn().setHeader("CamelGoogleSheetsRange", range);
        exchange.getIn().setHeader("CamelGoogleSheetsMajorDimension", majorDimension);
        message.setBody(values);
        return exchange;
    }

    public Exchange createExchange(Spreadsheet spreadsheet) {
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(this.getEndpoint().getExchangePattern());
        Message message = exchange.getIn();
        exchange.getIn().setHeader("CamelGoogleSheetsSpreadsheetId", spreadsheet.getSpreadsheetId());
        exchange.getIn().setHeader("CamelGoogleSheetsSpreadsheetUrl", spreadsheet.getSpreadsheetUrl());
        message.setBody(spreadsheet);
        return exchange;
    }
}

