/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.transfermanager.DownloadResult;
import com.google.cloud.storage.transfermanager.ParallelDownloadConfig;
import com.google.cloud.storage.transfermanager.TransferManagerUtils;
import com.google.cloud.storage.transfermanager.TransferStatus;
import com.google.common.io.ByteStreams;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Callable;

final class DirectDownloadCallable
implements Callable<DownloadResult> {
    private final BlobInfo originalBlob;
    private final ParallelDownloadConfig parallelDownloadConfig;
    private final Storage storage;
    private final Storage.BlobSourceOption[] opts;

    DirectDownloadCallable(Storage storage, BlobInfo originalBlob, ParallelDownloadConfig parallelDownloadConfig, Storage.BlobSourceOption[] opts) {
        this.originalBlob = originalBlob;
        this.parallelDownloadConfig = parallelDownloadConfig;
        this.storage = storage;
        this.opts = opts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DownloadResult call() {
        Path path = TransferManagerUtils.createDestPath(this.parallelDownloadConfig, this.originalBlob);
        long bytesCopied = -1L;
        try (ReadChannel rc = this.storage.reader(BlobId.of(this.parallelDownloadConfig.getBucketName(), this.originalBlob.getName()), this.opts);
             FileChannel wc = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            rc.setChunkSize(0);
            bytesCopied = ByteStreams.copy(rc, wc);
            if (this.originalBlob.getSize() == null) return DownloadResult.newBuilder(this.originalBlob, TransferStatus.SUCCESS).setOutputDestination(path.toAbsolutePath()).build();
            if (bytesCopied == this.originalBlob.getSize()) return DownloadResult.newBuilder(this.originalBlob, TransferStatus.SUCCESS).setOutputDestination(path.toAbsolutePath()).build();
            DownloadResult downloadResult = DownloadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(new StorageException(0, "Unexpected end of stream, read " + bytesCopied + " expected " + this.originalBlob.getSize() + " from object " + this.originalBlob.getBlobId().toGsUtilUriWithGeneration())).build();
            return downloadResult;
        }
        catch (Exception e) {
            if (bytesCopied != -1L) return DownloadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(e).build();
            return DownloadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_START).setException(e).build();
        }
    }
}

