/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.cloud.storage.Storage;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ParallelDownloadConfig {
    private final @NonNull String stripPrefix;
    private final @NonNull Path downloadDirectory;
    private final @NonNull String bucketName;
    private final @NonNull List<Storage.BlobSourceOption> optionsPerRequest;

    private ParallelDownloadConfig(@NonNull String stripPrefix, @NonNull Path downloadDirectory, @NonNull String bucketName, @NonNull List<Storage.BlobSourceOption> optionsPerRequest) {
        this.stripPrefix = stripPrefix;
        this.downloadDirectory = downloadDirectory;
        this.bucketName = bucketName;
        this.optionsPerRequest = optionsPerRequest;
    }

    public @NonNull String getStripPrefix() {
        return this.stripPrefix;
    }

    public @NonNull Path getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public @NonNull String getBucketName() {
        return this.bucketName;
    }

    public @NonNull List<Storage.BlobSourceOption> getOptionsPerRequest() {
        return this.optionsPerRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParallelDownloadConfig)) {
            return false;
        }
        ParallelDownloadConfig that = (ParallelDownloadConfig)o;
        return this.stripPrefix.equals(that.stripPrefix) && this.downloadDirectory.equals(that.downloadDirectory) && this.bucketName.equals(that.bucketName) && this.optionsPerRequest.equals(that.optionsPerRequest);
    }

    public int hashCode() {
        return Objects.hash(this.stripPrefix, this.downloadDirectory, this.bucketName, this.optionsPerRequest);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("stripPrefix", this.stripPrefix).add("downloadDirectory", this.downloadDirectory).add("bucketName", this.bucketName).add("optionsPerRequest", this.optionsPerRequest).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private @NonNull String stripPrefix = "";
        private @NonNull Path downloadDirectory = Paths.get("", new String[0]);
        private @NonNull String bucketName = "";
        private @NonNull List<Storage.BlobSourceOption> optionsPerRequest = ImmutableList.of();

        private Builder() {
        }

        public Builder setStripPrefix(String stripPrefix) {
            this.stripPrefix = stripPrefix;
            return this;
        }

        public Builder setDownloadDirectory(Path downloadDirectory) {
            this.downloadDirectory = downloadDirectory;
            return this;
        }

        public Builder setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder setOptionsPerRequest(List<Storage.BlobSourceOption> optionsPerRequest) {
            this.optionsPerRequest = ImmutableList.copyOf(optionsPerRequest);
            return this;
        }

        public ParallelDownloadConfig build() {
            Preconditions.checkNotNull(this.bucketName);
            Preconditions.checkNotNull(this.stripPrefix);
            Preconditions.checkNotNull(this.downloadDirectory);
            Preconditions.checkNotNull(this.optionsPerRequest);
            return new ParallelDownloadConfig(this.stripPrefix, this.downloadDirectory, this.bucketName, this.optionsPerRequest);
        }
    }
}

