/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.MethodName;
import com.google.api.gax.tracing.MetricsRecorder;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@BetaApi
@InternalApi
public class MetricsTracer
implements ApiTracer {
    public static final String METHOD_ATTRIBUTE = "method";
    public static final String LANGUAGE_ATTRIBUTE = "language";
    public static final String STATUS_ATTRIBUTE = "status";
    public static final String DEFAULT_LANGUAGE = "Java";
    private static final String OPERATION_FINISHED_STATUS_MESSAGE = "Operation has already been completed";
    private Stopwatch attemptTimer;
    private final Stopwatch operationTimer = Stopwatch.createStarted();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final MetricsRecorder metricsRecorder;
    private final AtomicBoolean operationFinished;

    public MetricsTracer(MethodName methodName, MetricsRecorder metricsRecorder) {
        this.attributes.put(METHOD_ATTRIBUTE, methodName.toString());
        this.attributes.put(LANGUAGE_ATTRIBUTE, DEFAULT_LANGUAGE);
        this.metricsRecorder = metricsRecorder;
        this.operationFinished = new AtomicBoolean();
    }

    @Override
    public void operationSucceeded() {
        if (this.operationFinished.getAndSet(true)) {
            throw new IllegalStateException(OPERATION_FINISHED_STATUS_MESSAGE);
        }
        this.attributes.put(STATUS_ATTRIBUTE, StatusCode.Code.OK.toString());
        this.metricsRecorder.recordOperationLatency(this.operationTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordOperationCount(1L, this.attributes);
    }

    @Override
    public void operationCancelled() {
        if (this.operationFinished.getAndSet(true)) {
            throw new IllegalStateException(OPERATION_FINISHED_STATUS_MESSAGE);
        }
        this.attributes.put(STATUS_ATTRIBUTE, StatusCode.Code.CANCELLED.toString());
        this.metricsRecorder.recordOperationLatency(this.operationTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordOperationCount(1L, this.attributes);
    }

    @Override
    public void operationFailed(Throwable error) {
        if (this.operationFinished.getAndSet(true)) {
            throw new IllegalStateException(OPERATION_FINISHED_STATUS_MESSAGE);
        }
        this.attributes.put(STATUS_ATTRIBUTE, MetricsTracer.extractStatus(error));
        this.metricsRecorder.recordOperationLatency(this.operationTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordOperationCount(1L, this.attributes);
    }

    @Override
    public void attemptStarted(Object request, int attemptNumber) {
        this.attemptTimer = Stopwatch.createStarted();
    }

    @Override
    public void attemptSucceeded() {
        this.attributes.put(STATUS_ATTRIBUTE, StatusCode.Code.OK.toString());
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @Override
    public void attemptCancelled() {
        this.attributes.put(STATUS_ATTRIBUTE, StatusCode.Code.CANCELLED.toString());
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @Override
    public void attemptFailedDuration(Throwable error, java.time.Duration delay) {
        this.attributes.put(STATUS_ATTRIBUTE, MetricsTracer.extractStatus(error));
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @Override
    @ObsoleteApi(value="Use attemptFailedDuration(Throwable, java.time.Duration) instead")
    public void attemptFailed(Throwable error, Duration delay) {
        this.attemptFailedDuration(error, TimeConversionUtils.toJavaTimeDuration(delay));
    }

    @Override
    public void attemptFailedRetriesExhausted(Throwable error) {
        this.attributes.put(STATUS_ATTRIBUTE, MetricsTracer.extractStatus(error));
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @Override
    public void attemptPermanentFailure(Throwable error) {
        this.attributes.put(STATUS_ATTRIBUTE, MetricsTracer.extractStatus(error));
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @VisibleForTesting
    static String extractStatus(@Nullable Throwable error) {
        if (error == null) {
            return StatusCode.Code.OK.toString();
        }
        String statusString = error instanceof CancellationException ? StatusCode.Code.CANCELLED.toString() : (error instanceof ApiException ? ((ApiException)error).getStatusCode().getCode().toString() : StatusCode.Code.UNKNOWN.toString());
        return statusString;
    }

    public void addAttributes(String key, String value) {
        this.attributes.put(key, value);
    }

    @VisibleForTesting
    Map<String, String> getAttributes() {
        return this.attributes;
    }
}

