/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.BaseServiceException;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.storage.Utils;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ApiaryUnbufferedReadableByteChannel
implements UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel {
    private final ApiaryReadRequest apiaryReadRequest;
    private final Storage storage;
    private final SettableApiFuture<StorageObject> result;
    private final HttpStorageOptions options;
    private final ResultRetryAlgorithm<?> resultRetryAlgorithm;
    private long position;
    private ScatteringByteChannel sbc;
    private boolean open;
    private boolean returnEOF;
    private Long xGoogGeneration;

    ApiaryUnbufferedReadableByteChannel(ApiaryReadRequest apiaryReadRequest, Storage storage, SettableApiFuture<StorageObject> result, HttpStorageOptions options, ResultRetryAlgorithm<?> resultRetryAlgorithm) {
        this.apiaryReadRequest = apiaryReadRequest;
        this.storage = storage;
        this.result = result;
        this.options = options;
        this.resultRetryAlgorithm = resultRetryAlgorithm;
        this.open = true;
        this.returnEOF = false;
        this.position = apiaryReadRequest.getByteRangeSpec().beginOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.returnEOF) {
            this.close();
            return -1L;
        }
        if (!this.open) {
            throw new ClosedChannelException();
        }
        long totalRead = 0L;
        while (true) {
            if (this.sbc == null) {
                this.sbc = (ScatteringByteChannel)Retrying.run(this.options, this.resultRetryAlgorithm, this::open, Function.identity());
            }
            long totalRemaining = Buffers.totalRemaining(dsts, offset, length);
            try {
                long read = this.sbc.read(dsts, offset, length);
                if (read == -1L) {
                    this.returnEOF = true;
                } else {
                    totalRead += read;
                }
                long l = totalRead;
                return l;
            }
            catch (Exception t2) {
                if (this.resultRetryAlgorithm.shouldRetry(t2, null)) {
                    this.sbc = null;
                    continue;
                }
                if (t2 instanceof IOException) {
                    IOException ioE = (IOException)t2;
                    if (this.resultRetryAlgorithm.shouldRetry(StorageException.translate(ioE), null)) {
                        this.sbc = null;
                        continue;
                    }
                    throw ioE;
                }
                throw new IOException(StorageException.coalesce(t2));
            }
            finally {
                long totalRemainingAfter = Buffers.totalRemaining(dsts, offset, length);
                long delta = totalRemaining - totalRemainingAfter;
                if (delta <= 0L) continue;
                this.position += delta;
                totalRead += delta;
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        if (this.sbc != null) {
            this.sbc.close();
        }
    }

    private void setXGoogGeneration(long xGoogGeneration) {
        this.xGoogGeneration = xGoogGeneration;
    }

    private ScatteringByteChannel open() {
        try {
            HttpHeaders responseHeaders;
            String xGoogGenHeader;
            ApiaryReadRequest request = this.apiaryReadRequest.withNewBeginOffset(this.position);
            Storage.Objects.Get get = ApiaryUnbufferedReadableByteChannel.createGetRequest(request, this.storage.objects(), this.xGoogGeneration);
            HttpResponse media = get.executeMedia();
            InputStream content = media.getContent();
            if (this.xGoogGeneration == null && (xGoogGenHeader = ApiaryUnbufferedReadableByteChannel.getHeaderValue(responseHeaders = media.getHeaders(), "x-goog-generation")) != null) {
                StorageObject clone = this.apiaryReadRequest.getObject().clone();
                Utils.ifNonNull(xGoogGenHeader, Long::valueOf, clone::setGeneration);
                Utils.ifNonNull(xGoogGenHeader, Long::valueOf, this::setXGoogGeneration);
                Utils.ifNonNull(ApiaryUnbufferedReadableByteChannel.getHeaderValue(responseHeaders, "x-goog-metageneration"), Long::valueOf, clone::setMetageneration);
                Utils.ifNonNull(ApiaryUnbufferedReadableByteChannel.getHeaderValue(responseHeaders, "x-goog-storage-class"), clone::setStorageClass);
                Utils.ifNonNull(ApiaryUnbufferedReadableByteChannel.getHeaderValue(responseHeaders, "x-goog-stored-content-length"), BigInteger::new, clone::setSize);
                Utils.ifNonNull(ApiaryUnbufferedReadableByteChannel.getHeaderValue(responseHeaders, "content-disposition"), clone::setContentDisposition);
                Utils.ifNonNull(ApiaryUnbufferedReadableByteChannel.getHeaderValue(responseHeaders, "content-type"), clone::setContentType);
                Utils.ifNonNull(ApiaryUnbufferedReadableByteChannel.getHeaderValue(responseHeaders, "etag"), clone::setEtag);
                String encoding = ApiaryUnbufferedReadableByteChannel.getHeaderValue(responseHeaders, "x-goog-stored-content-encoding");
                if (encoding != null && !encoding.equalsIgnoreCase("identity")) {
                    clone.setContentEncoding(encoding);
                }
                if (!this.result.isDone()) {
                    this.result.set(clone);
                }
            }
            ReadableByteChannel rbc = Channels.newChannel(content);
            return StorageByteChannels.readable().asScatteringByteChannel(rbc);
        }
        catch (HttpResponseException e) {
            int statusCode;
            if (this.xGoogGeneration != null && (statusCode = e.getStatusCode()) == 404) {
                throw new StorageException(404, "Failure while trying to resume download", e);
            }
            StorageException translate = StorageException.translate(e);
            this.result.setException(translate);
            throw translate;
        }
        catch (IOException e) {
            StorageException translate = StorageException.translate(e);
            this.result.setException(translate);
            throw translate;
        }
        catch (Throwable t2) {
            BaseServiceException coalesce = StorageException.coalesce(t2);
            this.result.setException(coalesce);
            throw coalesce;
        }
    }

    @VisibleForTesting
    static Storage.Objects.Get createGetRequest(ApiaryReadRequest apiaryReadRequest, Storage.Objects objects, Long xGoogGeneration) throws IOException {
        StorageObject from = apiaryReadRequest.getObject();
        Map<StorageRpc.Option, ?> options = apiaryReadRequest.getOptions();
        Storage.Objects.Get get = objects.get(from.getBucket(), from.getName());
        if (from.getGeneration() != null) {
            get.setGeneration(from.getGeneration());
        } else if (xGoogGeneration != null) {
            get.setGeneration(xGoogGeneration);
        }
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.IF_GENERATION_MATCH), ApiaryUnbufferedReadableByteChannel::cast, get::setIfGenerationMatch);
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.IF_GENERATION_NOT_MATCH), ApiaryUnbufferedReadableByteChannel::cast, get::setIfGenerationNotMatch);
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.IF_METAGENERATION_MATCH), ApiaryUnbufferedReadableByteChannel::cast, get::setIfMetagenerationMatch);
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.IF_METAGENERATION_NOT_MATCH), ApiaryUnbufferedReadableByteChannel::cast, get::setIfMetagenerationNotMatch);
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.USER_PROJECT), ApiaryUnbufferedReadableByteChannel::cast, get::setUserProject);
        HttpHeaders headers = get.getRequestHeaders();
        Utils.ifNonNull(options.get((Object)StorageRpc.Option.CUSTOMER_SUPPLIED_KEY), ApiaryUnbufferedReadableByteChannel::cast, key -> {
            BaseEncoding base64 = BaseEncoding.base64();
            HashFunction hashFunction = Hashing.sha256();
            headers.set("x-goog-encryption-algorithm", "AES256");
            headers.set("x-goog-encryption-key", key);
            headers.set("x-goog-encryption-key-sha256", base64.encode(hashFunction.hashBytes(base64.decode((CharSequence)key)).asBytes()));
        });
        get.setReturnRawInputStream(true);
        String range = apiaryReadRequest.getByteRangeSpec().getHttpRangeHeader();
        if (range != null) {
            get.getRequestHeaders().setRange(range);
        }
        get.getMediaHttpDownloader().setDirectDownloadEnabled(true);
        return get;
    }

    private static <T> T cast(Object o) {
        return (T)o;
    }

    private static @Nullable String getHeaderValue(@NonNull HttpHeaders headers, @NonNull String headerName) {
        Object o = headers.get(headerName);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List list = (List)o;
            if (list.isEmpty()) {
                return null;
            }
            return ((String)list.get(0)).trim().toLowerCase(Locale.ENGLISH);
        }
        if (o instanceof String) {
            return (String)o;
        }
        throw new IllegalStateException(String.format("Unexpected header type '%s' for header %s", o.getClass().getName(), headerName));
    }

    @Immutable
    static final class ApiaryReadRequest
    implements Serializable {
        private static final long serialVersionUID = -4059435314115374448L;
        private static final Gson gson = new Gson();
        private transient @NonNull StorageObject object;
        private final @NonNull Map<StorageRpc.Option, ?> options;
        private final @NonNull ByteRangeSpec byteRangeSpec;
        private volatile String objectJson;

        ApiaryReadRequest(@NonNull StorageObject object, @NonNull Map<StorageRpc.Option, ?> options, @NonNull ByteRangeSpec byteRangeSpec) {
            this.object = Objects.requireNonNull(object, "object must be non null");
            this.options = Objects.requireNonNull(options, "options must be non null");
            this.byteRangeSpec = Objects.requireNonNull(byteRangeSpec, "byteRangeSpec must be non null");
        }

        @NonNull StorageObject getObject() {
            return this.object;
        }

        @NonNull Map<StorageRpc.Option, ?> getOptions() {
            return this.options;
        }

        @NonNull ByteRangeSpec getByteRangeSpec() {
            return this.byteRangeSpec;
        }

        ApiaryReadRequest withNewBeginOffset(long beginOffset) {
            if (beginOffset > 0L && beginOffset != this.byteRangeSpec.beginOffset()) {
                return new ApiaryReadRequest(this.object, this.options, this.byteRangeSpec.withNewBeginOffset(beginOffset));
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ApiaryReadRequest)) {
                return false;
            }
            ApiaryReadRequest that = (ApiaryReadRequest)o;
            return Objects.equals(this.object, that.object) && Objects.equals(this.options, that.options) && Objects.equals(this.byteRangeSpec, that.byteRangeSpec);
        }

        public int hashCode() {
            return Objects.hash(this.object, this.options, this.byteRangeSpec);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("byteRangeSpec", this.byteRangeSpec).add("options", this.options).add("object", this.getObjectJson()).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getObjectJson() {
            if (this.objectJson == null) {
                ApiaryReadRequest apiaryReadRequest = this;
                synchronized (apiaryReadRequest) {
                    if (this.objectJson == null) {
                        this.objectJson = gson.toJson(this.object);
                    }
                }
            }
            return this.objectJson;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            String ignore = this.getObjectJson();
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            JsonReader jsonReader = gson.newJsonReader(new StringReader(this.objectJson));
            this.object = (StorageObject)gson.fromJson(jsonReader, (Type)((Object)StorageObject.class));
        }
    }
}

