/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.MonitoredResource;
import com.google.api.MonitoredResourceOrBuilder;
import com.google.monitoring.v3.GroupResourceType;
import com.google.monitoring.v3.InternalChecker;
import com.google.monitoring.v3.InternalCheckerOrBuilder;
import com.google.monitoring.v3.UptimeCheckConfigOrBuilder;
import com.google.monitoring.v3.UptimeCheckRegion;
import com.google.monitoring.v3.UptimeProto;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class UptimeCheckConfig
extends GeneratedMessageV3
implements UptimeCheckConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    private int resourceCase_ = 0;
    private Object resource_;
    private int checkRequestTypeCase_ = 0;
    private Object checkRequestType_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
    private volatile Object displayName_ = "";
    public static final int MONITORED_RESOURCE_FIELD_NUMBER = 3;
    public static final int RESOURCE_GROUP_FIELD_NUMBER = 4;
    public static final int HTTP_CHECK_FIELD_NUMBER = 5;
    public static final int TCP_CHECK_FIELD_NUMBER = 6;
    public static final int PERIOD_FIELD_NUMBER = 7;
    private Duration period_;
    public static final int TIMEOUT_FIELD_NUMBER = 8;
    private Duration timeout_;
    public static final int CONTENT_MATCHERS_FIELD_NUMBER = 9;
    private List<ContentMatcher> contentMatchers_;
    public static final int CHECKER_TYPE_FIELD_NUMBER = 17;
    private int checkerType_ = 0;
    public static final int SELECTED_REGIONS_FIELD_NUMBER = 10;
    private List<Integer> selectedRegions_;
    private static final Internal.ListAdapter.Converter<Integer, UptimeCheckRegion> selectedRegions_converter_ = new Internal.ListAdapter.Converter<Integer, UptimeCheckRegion>(){

        @Override
        public UptimeCheckRegion convert(Integer from) {
            UptimeCheckRegion result = UptimeCheckRegion.forNumber(from);
            return result == null ? UptimeCheckRegion.UNRECOGNIZED : result;
        }
    };
    private int selectedRegionsMemoizedSerializedSize;
    public static final int IS_INTERNAL_FIELD_NUMBER = 15;
    private boolean isInternal_ = false;
    public static final int INTERNAL_CHECKERS_FIELD_NUMBER = 14;
    private List<InternalChecker> internalCheckers_;
    public static final int USER_LABELS_FIELD_NUMBER = 20;
    private MapField<String, String> userLabels_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final UptimeCheckConfig DEFAULT_INSTANCE = new UptimeCheckConfig();
    private static final Parser<UptimeCheckConfig> PARSER = new AbstractParser<UptimeCheckConfig>(){

        @Override
        public UptimeCheckConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = UptimeCheckConfig.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private UptimeCheckConfig(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private UptimeCheckConfig() {
        this.name_ = "";
        this.displayName_ = "";
        this.contentMatchers_ = Collections.emptyList();
        this.checkerType_ = 0;
        this.selectedRegions_ = Collections.emptyList();
        this.internalCheckers_ = Collections.emptyList();
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new UptimeCheckConfig();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_descriptor;
    }

    @Override
    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 20: {
                return this.internalGetUserLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(UptimeCheckConfig.class, Builder.class);
    }

    @Override
    public ResourceCase getResourceCase() {
        return ResourceCase.forNumber(this.resourceCase_);
    }

    @Override
    public CheckRequestTypeCase getCheckRequestTypeCase() {
        return CheckRequestTypeCase.forNumber(this.checkRequestTypeCase_);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s2 = bs.toStringUtf8();
        this.name_ = s2;
        return s2;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDisplayName() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s2 = bs.toStringUtf8();
        this.displayName_ = s2;
        return s2;
    }

    @Override
    public ByteString getDisplayNameBytes() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.displayName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasMonitoredResource() {
        return this.resourceCase_ == 3;
    }

    @Override
    public MonitoredResource getMonitoredResource() {
        if (this.resourceCase_ == 3) {
            return (MonitoredResource)this.resource_;
        }
        return MonitoredResource.getDefaultInstance();
    }

    @Override
    public MonitoredResourceOrBuilder getMonitoredResourceOrBuilder() {
        if (this.resourceCase_ == 3) {
            return (MonitoredResource)this.resource_;
        }
        return MonitoredResource.getDefaultInstance();
    }

    @Override
    public boolean hasResourceGroup() {
        return this.resourceCase_ == 4;
    }

    @Override
    public ResourceGroup getResourceGroup() {
        if (this.resourceCase_ == 4) {
            return (ResourceGroup)this.resource_;
        }
        return ResourceGroup.getDefaultInstance();
    }

    @Override
    public ResourceGroupOrBuilder getResourceGroupOrBuilder() {
        if (this.resourceCase_ == 4) {
            return (ResourceGroup)this.resource_;
        }
        return ResourceGroup.getDefaultInstance();
    }

    @Override
    public boolean hasHttpCheck() {
        return this.checkRequestTypeCase_ == 5;
    }

    @Override
    public HttpCheck getHttpCheck() {
        if (this.checkRequestTypeCase_ == 5) {
            return (HttpCheck)this.checkRequestType_;
        }
        return HttpCheck.getDefaultInstance();
    }

    @Override
    public HttpCheckOrBuilder getHttpCheckOrBuilder() {
        if (this.checkRequestTypeCase_ == 5) {
            return (HttpCheck)this.checkRequestType_;
        }
        return HttpCheck.getDefaultInstance();
    }

    @Override
    public boolean hasTcpCheck() {
        return this.checkRequestTypeCase_ == 6;
    }

    @Override
    public TcpCheck getTcpCheck() {
        if (this.checkRequestTypeCase_ == 6) {
            return (TcpCheck)this.checkRequestType_;
        }
        return TcpCheck.getDefaultInstance();
    }

    @Override
    public TcpCheckOrBuilder getTcpCheckOrBuilder() {
        if (this.checkRequestTypeCase_ == 6) {
            return (TcpCheck)this.checkRequestType_;
        }
        return TcpCheck.getDefaultInstance();
    }

    @Override
    public boolean hasPeriod() {
        return this.period_ != null;
    }

    @Override
    public Duration getPeriod() {
        return this.period_ == null ? Duration.getDefaultInstance() : this.period_;
    }

    @Override
    public DurationOrBuilder getPeriodOrBuilder() {
        return this.period_ == null ? Duration.getDefaultInstance() : this.period_;
    }

    @Override
    public boolean hasTimeout() {
        return this.timeout_ != null;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
    }

    @Override
    public DurationOrBuilder getTimeoutOrBuilder() {
        return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
    }

    @Override
    public List<ContentMatcher> getContentMatchersList() {
        return this.contentMatchers_;
    }

    @Override
    public List<? extends ContentMatcherOrBuilder> getContentMatchersOrBuilderList() {
        return this.contentMatchers_;
    }

    @Override
    public int getContentMatchersCount() {
        return this.contentMatchers_.size();
    }

    @Override
    public ContentMatcher getContentMatchers(int index) {
        return this.contentMatchers_.get(index);
    }

    @Override
    public ContentMatcherOrBuilder getContentMatchersOrBuilder(int index) {
        return this.contentMatchers_.get(index);
    }

    @Override
    public int getCheckerTypeValue() {
        return this.checkerType_;
    }

    @Override
    public CheckerType getCheckerType() {
        CheckerType result = CheckerType.forNumber(this.checkerType_);
        return result == null ? CheckerType.UNRECOGNIZED : result;
    }

    @Override
    public List<UptimeCheckRegion> getSelectedRegionsList() {
        return new Internal.ListAdapter<Integer, UptimeCheckRegion>(this.selectedRegions_, selectedRegions_converter_);
    }

    @Override
    public int getSelectedRegionsCount() {
        return this.selectedRegions_.size();
    }

    @Override
    public UptimeCheckRegion getSelectedRegions(int index) {
        return selectedRegions_converter_.convert(this.selectedRegions_.get(index));
    }

    @Override
    public List<Integer> getSelectedRegionsValueList() {
        return this.selectedRegions_;
    }

    @Override
    public int getSelectedRegionsValue(int index) {
        return this.selectedRegions_.get(index);
    }

    @Override
    @Deprecated
    public boolean getIsInternal() {
        return this.isInternal_;
    }

    @Override
    @Deprecated
    public List<InternalChecker> getInternalCheckersList() {
        return this.internalCheckers_;
    }

    @Override
    @Deprecated
    public List<? extends InternalCheckerOrBuilder> getInternalCheckersOrBuilderList() {
        return this.internalCheckers_;
    }

    @Override
    @Deprecated
    public int getInternalCheckersCount() {
        return this.internalCheckers_.size();
    }

    @Override
    @Deprecated
    public InternalChecker getInternalCheckers(int index) {
        return this.internalCheckers_.get(index);
    }

    @Override
    @Deprecated
    public InternalCheckerOrBuilder getInternalCheckersOrBuilder(int index) {
        return this.internalCheckers_.get(index);
    }

    private MapField<String, String> internalGetUserLabels() {
        if (this.userLabels_ == null) {
            return MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
        }
        return this.userLabels_;
    }

    @Override
    public int getUserLabelsCount() {
        return this.internalGetUserLabels().getMap().size();
    }

    @Override
    public boolean containsUserLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetUserLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getUserLabels() {
        return this.getUserLabelsMap();
    }

    @Override
    public Map<String, String> getUserLabelsMap() {
        return this.internalGetUserLabels().getMap();
    }

    @Override
    public String getUserLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map<String, String> map = this.internalGetUserLabels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    @Override
    public String getUserLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map<String, String> map = this.internalGetUserLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return map.get(key);
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
            GeneratedMessageV3.writeString(output, 1, this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.displayName_)) {
            GeneratedMessageV3.writeString(output, 2, this.displayName_);
        }
        if (this.resourceCase_ == 3) {
            output.writeMessage(3, (MonitoredResource)this.resource_);
        }
        if (this.resourceCase_ == 4) {
            output.writeMessage(4, (ResourceGroup)this.resource_);
        }
        if (this.checkRequestTypeCase_ == 5) {
            output.writeMessage(5, (HttpCheck)this.checkRequestType_);
        }
        if (this.checkRequestTypeCase_ == 6) {
            output.writeMessage(6, (TcpCheck)this.checkRequestType_);
        }
        if (this.period_ != null) {
            output.writeMessage(7, this.getPeriod());
        }
        if (this.timeout_ != null) {
            output.writeMessage(8, this.getTimeout());
        }
        for (i = 0; i < this.contentMatchers_.size(); ++i) {
            output.writeMessage(9, this.contentMatchers_.get(i));
        }
        if (this.getSelectedRegionsList().size() > 0) {
            output.writeUInt32NoTag(82);
            output.writeUInt32NoTag(this.selectedRegionsMemoizedSerializedSize);
        }
        for (i = 0; i < this.selectedRegions_.size(); ++i) {
            output.writeEnumNoTag(this.selectedRegions_.get(i));
        }
        for (i = 0; i < this.internalCheckers_.size(); ++i) {
            output.writeMessage(14, this.internalCheckers_.get(i));
        }
        if (this.isInternal_) {
            output.writeBool(15, this.isInternal_);
        }
        if (this.checkerType_ != CheckerType.CHECKER_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(17, this.checkerType_);
        }
        GeneratedMessageV3.serializeStringMapTo(output, this.internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 20);
        this.getUnknownFields().writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
            size += GeneratedMessageV3.computeStringSize(1, this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.displayName_)) {
            size += GeneratedMessageV3.computeStringSize(2, this.displayName_);
        }
        if (this.resourceCase_ == 3) {
            size += CodedOutputStream.computeMessageSize(3, (MonitoredResource)this.resource_);
        }
        if (this.resourceCase_ == 4) {
            size += CodedOutputStream.computeMessageSize(4, (ResourceGroup)this.resource_);
        }
        if (this.checkRequestTypeCase_ == 5) {
            size += CodedOutputStream.computeMessageSize(5, (HttpCheck)this.checkRequestType_);
        }
        if (this.checkRequestTypeCase_ == 6) {
            size += CodedOutputStream.computeMessageSize(6, (TcpCheck)this.checkRequestType_);
        }
        if (this.period_ != null) {
            size += CodedOutputStream.computeMessageSize(7, this.getPeriod());
        }
        if (this.timeout_ != null) {
            size += CodedOutputStream.computeMessageSize(8, this.getTimeout());
        }
        for (i = 0; i < this.contentMatchers_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(9, this.contentMatchers_.get(i));
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.selectedRegions_.size(); ++i2) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag(this.selectedRegions_.get(i2));
        }
        size += dataSize;
        if (!this.getSelectedRegionsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        this.selectedRegionsMemoizedSerializedSize = dataSize;
        for (i = 0; i < this.internalCheckers_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(14, this.internalCheckers_.get(i));
        }
        if (this.isInternal_) {
            size += CodedOutputStream.computeBoolSize(15, this.isInternal_);
        }
        if (this.checkerType_ != CheckerType.CHECKER_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(17, this.checkerType_);
        }
        for (Map.Entry<String, String> entry : this.internalGetUserLabels().getMap().entrySet()) {
            Message userLabels__ = ((MapEntry.Builder)UserLabelsDefaultEntryHolder.defaultEntry.newBuilderForType()).setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize(20, userLabels__);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UptimeCheckConfig)) {
            return super.equals(obj);
        }
        UptimeCheckConfig other = (UptimeCheckConfig)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDisplayName().equals(other.getDisplayName())) {
            return false;
        }
        if (this.hasPeriod() != other.hasPeriod()) {
            return false;
        }
        if (this.hasPeriod() && !this.getPeriod().equals(other.getPeriod())) {
            return false;
        }
        if (this.hasTimeout() != other.hasTimeout()) {
            return false;
        }
        if (this.hasTimeout() && !this.getTimeout().equals(other.getTimeout())) {
            return false;
        }
        if (!this.getContentMatchersList().equals(other.getContentMatchersList())) {
            return false;
        }
        if (this.checkerType_ != other.checkerType_) {
            return false;
        }
        if (!this.selectedRegions_.equals(other.selectedRegions_)) {
            return false;
        }
        if (this.getIsInternal() != other.getIsInternal()) {
            return false;
        }
        if (!this.getInternalCheckersList().equals(other.getInternalCheckersList())) {
            return false;
        }
        if (!this.internalGetUserLabels().equals(other.internalGetUserLabels())) {
            return false;
        }
        if (!this.getResourceCase().equals(other.getResourceCase())) {
            return false;
        }
        switch (this.resourceCase_) {
            case 3: {
                if (this.getMonitoredResource().equals(other.getMonitoredResource())) break;
                return false;
            }
            case 4: {
                if (this.getResourceGroup().equals(other.getResourceGroup())) break;
                return false;
            }
        }
        if (!this.getCheckRequestTypeCase().equals(other.getCheckRequestTypeCase())) {
            return false;
        }
        switch (this.checkRequestTypeCase_) {
            case 5: {
                if (this.getHttpCheck().equals(other.getHttpCheck())) break;
                return false;
            }
            case 6: {
                if (this.getTcpCheck().equals(other.getTcpCheck())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + UptimeCheckConfig.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDisplayName().hashCode();
        if (this.hasPeriod()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getPeriod().hashCode();
        }
        if (this.hasTimeout()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getTimeout().hashCode();
        }
        if (this.getContentMatchersCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getContentMatchersList().hashCode();
        }
        hash = 37 * hash + 17;
        hash = 53 * hash + this.checkerType_;
        if (this.getSelectedRegionsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.selectedRegions_.hashCode();
        }
        hash = 37 * hash + 15;
        hash = 53 * hash + Internal.hashBoolean(this.getIsInternal());
        if (this.getInternalCheckersCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getInternalCheckersList().hashCode();
        }
        if (!this.internalGetUserLabels().getMap().isEmpty()) {
            hash = 37 * hash + 20;
            hash = 53 * hash + this.internalGetUserLabels().hashCode();
        }
        switch (this.resourceCase_) {
            case 3: {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getMonitoredResource().hashCode();
                break;
            }
            case 4: {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getResourceGroup().hashCode();
                break;
            }
        }
        switch (this.checkRequestTypeCase_) {
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getHttpCheck().hashCode();
                break;
            }
            case 6: {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getTcpCheck().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static UptimeCheckConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static UptimeCheckConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static UptimeCheckConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static UptimeCheckConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static UptimeCheckConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static UptimeCheckConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static UptimeCheckConfig parseFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static UptimeCheckConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static UptimeCheckConfig parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static UptimeCheckConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static UptimeCheckConfig parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static UptimeCheckConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return UptimeCheckConfig.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(UptimeCheckConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static UptimeCheckConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<UptimeCheckConfig> parser() {
        return PARSER;
    }

    public Parser<UptimeCheckConfig> getParserForType() {
        return PARSER;
    }

    @Override
    public UptimeCheckConfig getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements UptimeCheckConfigOrBuilder {
        private int resourceCase_ = 0;
        private Object resource_;
        private int checkRequestTypeCase_ = 0;
        private Object checkRequestType_;
        private int bitField0_;
        private Object name_ = "";
        private Object displayName_ = "";
        private SingleFieldBuilderV3<MonitoredResource, MonitoredResource.Builder, MonitoredResourceOrBuilder> monitoredResourceBuilder_;
        private SingleFieldBuilderV3<ResourceGroup, ResourceGroup.Builder, ResourceGroupOrBuilder> resourceGroupBuilder_;
        private SingleFieldBuilderV3<HttpCheck, HttpCheck.Builder, HttpCheckOrBuilder> httpCheckBuilder_;
        private SingleFieldBuilderV3<TcpCheck, TcpCheck.Builder, TcpCheckOrBuilder> tcpCheckBuilder_;
        private Duration period_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> periodBuilder_;
        private Duration timeout_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> timeoutBuilder_;
        private List<ContentMatcher> contentMatchers_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ContentMatcher, ContentMatcher.Builder, ContentMatcherOrBuilder> contentMatchersBuilder_;
        private int checkerType_ = 0;
        private List<Integer> selectedRegions_ = Collections.emptyList();
        private boolean isInternal_;
        private List<InternalChecker> internalCheckers_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<InternalChecker, InternalChecker.Builder, InternalCheckerOrBuilder> internalCheckersBuilder_;
        private MapField<String, String> userLabels_;

        public static final Descriptors.Descriptor getDescriptor() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_descriptor;
        }

        @Override
        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 20: {
                    return this.internalGetUserLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        @Override
        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 20: {
                    return this.internalGetMutableUserLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(UptimeCheckConfig.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.displayName_ = "";
            if (this.monitoredResourceBuilder_ != null) {
                this.monitoredResourceBuilder_.clear();
            }
            if (this.resourceGroupBuilder_ != null) {
                this.resourceGroupBuilder_.clear();
            }
            if (this.httpCheckBuilder_ != null) {
                this.httpCheckBuilder_.clear();
            }
            if (this.tcpCheckBuilder_ != null) {
                this.tcpCheckBuilder_.clear();
            }
            this.period_ = null;
            if (this.periodBuilder_ != null) {
                this.periodBuilder_.dispose();
                this.periodBuilder_ = null;
            }
            this.timeout_ = null;
            if (this.timeoutBuilder_ != null) {
                this.timeoutBuilder_.dispose();
                this.timeoutBuilder_ = null;
            }
            if (this.contentMatchersBuilder_ == null) {
                this.contentMatchers_ = Collections.emptyList();
            } else {
                this.contentMatchers_ = null;
                this.contentMatchersBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFEFF;
            this.checkerType_ = 0;
            this.selectedRegions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFBFF;
            this.isInternal_ = false;
            if (this.internalCheckersBuilder_ == null) {
                this.internalCheckers_ = Collections.emptyList();
            } else {
                this.internalCheckers_ = null;
                this.internalCheckersBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFEFFF;
            this.internalGetMutableUserLabels().clear();
            this.resourceCase_ = 0;
            this.resource_ = null;
            this.checkRequestTypeCase_ = 0;
            this.checkRequestType_ = null;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_descriptor;
        }

        @Override
        public UptimeCheckConfig getDefaultInstanceForType() {
            return UptimeCheckConfig.getDefaultInstance();
        }

        @Override
        public UptimeCheckConfig build() {
            UptimeCheckConfig result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public UptimeCheckConfig buildPartial() {
            UptimeCheckConfig result = new UptimeCheckConfig(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(UptimeCheckConfig result) {
            if (this.contentMatchersBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0) {
                    this.contentMatchers_ = Collections.unmodifiableList(this.contentMatchers_);
                    this.bitField0_ &= 0xFFFFFEFF;
                }
                result.contentMatchers_ = this.contentMatchers_;
            } else {
                result.contentMatchers_ = this.contentMatchersBuilder_.build();
            }
            if ((this.bitField0_ & 0x400) != 0) {
                this.selectedRegions_ = Collections.unmodifiableList(this.selectedRegions_);
                this.bitField0_ &= 0xFFFFFBFF;
            }
            result.selectedRegions_ = this.selectedRegions_;
            if (this.internalCheckersBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0) {
                    this.internalCheckers_ = Collections.unmodifiableList(this.internalCheckers_);
                    this.bitField0_ &= 0xFFFFEFFF;
                }
                result.internalCheckers_ = this.internalCheckers_;
            } else {
                result.internalCheckers_ = this.internalCheckersBuilder_.build();
            }
        }

        private void buildPartial0(UptimeCheckConfig result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.displayName_ = this.displayName_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.period_ = this.periodBuilder_ == null ? this.period_ : this.periodBuilder_.build();
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.timeout_ = this.timeoutBuilder_ == null ? this.timeout_ : this.timeoutBuilder_.build();
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.checkerType_ = this.checkerType_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.isInternal_ = this.isInternal_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.userLabels_ = this.internalGetUserLabels();
                result.userLabels_.makeImmutable();
            }
        }

        private void buildPartialOneofs(UptimeCheckConfig result) {
            result.resourceCase_ = this.resourceCase_;
            result.resource_ = this.resource_;
            if (this.resourceCase_ == 3 && this.monitoredResourceBuilder_ != null) {
                result.resource_ = this.monitoredResourceBuilder_.build();
            }
            if (this.resourceCase_ == 4 && this.resourceGroupBuilder_ != null) {
                result.resource_ = this.resourceGroupBuilder_.build();
            }
            result.checkRequestTypeCase_ = this.checkRequestTypeCase_;
            result.checkRequestType_ = this.checkRequestType_;
            if (this.checkRequestTypeCase_ == 5 && this.httpCheckBuilder_ != null) {
                result.checkRequestType_ = this.httpCheckBuilder_.build();
            }
            if (this.checkRequestTypeCase_ == 6 && this.tcpCheckBuilder_ != null) {
                result.checkRequestType_ = this.tcpCheckBuilder_.build();
            }
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        @Override
        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        @Override
        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        @Override
        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof UptimeCheckConfig) {
                return this.mergeFrom((UptimeCheckConfig)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(UptimeCheckConfig other) {
            if (other == UptimeCheckConfig.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getDisplayName().isEmpty()) {
                this.displayName_ = other.displayName_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasPeriod()) {
                this.mergePeriod(other.getPeriod());
            }
            if (other.hasTimeout()) {
                this.mergeTimeout(other.getTimeout());
            }
            if (this.contentMatchersBuilder_ == null) {
                if (!other.contentMatchers_.isEmpty()) {
                    if (this.contentMatchers_.isEmpty()) {
                        this.contentMatchers_ = other.contentMatchers_;
                        this.bitField0_ &= 0xFFFFFEFF;
                    } else {
                        this.ensureContentMatchersIsMutable();
                        this.contentMatchers_.addAll(other.contentMatchers_);
                    }
                    this.onChanged();
                }
            } else if (!other.contentMatchers_.isEmpty()) {
                if (this.contentMatchersBuilder_.isEmpty()) {
                    this.contentMatchersBuilder_.dispose();
                    this.contentMatchersBuilder_ = null;
                    this.contentMatchers_ = other.contentMatchers_;
                    this.bitField0_ &= 0xFFFFFEFF;
                    this.contentMatchersBuilder_ = alwaysUseFieldBuilders ? this.getContentMatchersFieldBuilder() : null;
                } else {
                    this.contentMatchersBuilder_.addAllMessages(other.contentMatchers_);
                }
            }
            if (other.checkerType_ != 0) {
                this.setCheckerTypeValue(other.getCheckerTypeValue());
            }
            if (!other.selectedRegions_.isEmpty()) {
                if (this.selectedRegions_.isEmpty()) {
                    this.selectedRegions_ = other.selectedRegions_;
                    this.bitField0_ &= 0xFFFFFBFF;
                } else {
                    this.ensureSelectedRegionsIsMutable();
                    this.selectedRegions_.addAll(other.selectedRegions_);
                }
                this.onChanged();
            }
            if (other.getIsInternal()) {
                this.setIsInternal(other.getIsInternal());
            }
            if (this.internalCheckersBuilder_ == null) {
                if (!other.internalCheckers_.isEmpty()) {
                    if (this.internalCheckers_.isEmpty()) {
                        this.internalCheckers_ = other.internalCheckers_;
                        this.bitField0_ &= 0xFFFFEFFF;
                    } else {
                        this.ensureInternalCheckersIsMutable();
                        this.internalCheckers_.addAll(other.internalCheckers_);
                    }
                    this.onChanged();
                }
            } else if (!other.internalCheckers_.isEmpty()) {
                if (this.internalCheckersBuilder_.isEmpty()) {
                    this.internalCheckersBuilder_.dispose();
                    this.internalCheckersBuilder_ = null;
                    this.internalCheckers_ = other.internalCheckers_;
                    this.bitField0_ &= 0xFFFFEFFF;
                    this.internalCheckersBuilder_ = alwaysUseFieldBuilders ? this.getInternalCheckersFieldBuilder() : null;
                } else {
                    this.internalCheckersBuilder_.addAllMessages(other.internalCheckers_);
                }
            }
            this.internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
            this.bitField0_ |= 0x2000;
            switch (other.getResourceCase()) {
                case MONITORED_RESOURCE: {
                    this.mergeMonitoredResource(other.getMonitoredResource());
                    break;
                }
                case RESOURCE_GROUP: {
                    this.mergeResourceGroup(other.getResourceGroup());
                    break;
                }
            }
            switch (other.getCheckRequestTypeCase()) {
                case HTTP_CHECK: {
                    this.mergeHttpCheck(other.getHttpCheck());
                    break;
                }
                case TCP_CHECK: {
                    this.mergeTcpCheck(other.getTcpCheck());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block23: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block23;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block23;
                        }
                        case 18: {
                            this.displayName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block23;
                        }
                        case 26: {
                            input.readMessage(this.getMonitoredResourceFieldBuilder().getBuilder(), extensionRegistry);
                            this.resourceCase_ = 3;
                            continue block23;
                        }
                        case 34: {
                            input.readMessage(this.getResourceGroupFieldBuilder().getBuilder(), extensionRegistry);
                            this.resourceCase_ = 4;
                            continue block23;
                        }
                        case 42: {
                            input.readMessage(this.getHttpCheckFieldBuilder().getBuilder(), extensionRegistry);
                            this.checkRequestTypeCase_ = 5;
                            continue block23;
                        }
                        case 50: {
                            input.readMessage(this.getTcpCheckFieldBuilder().getBuilder(), extensionRegistry);
                            this.checkRequestTypeCase_ = 6;
                            continue block23;
                        }
                        case 58: {
                            input.readMessage(this.getPeriodFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block23;
                        }
                        case 66: {
                            input.readMessage(this.getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block23;
                        }
                        case 74: {
                            GeneratedMessageV3 m4 = input.readMessage(ContentMatcher.parser(), extensionRegistry);
                            if (this.contentMatchersBuilder_ == null) {
                                this.ensureContentMatchersIsMutable();
                                this.contentMatchers_.add((ContentMatcher)m4);
                                continue block23;
                            }
                            this.contentMatchersBuilder_.addMessage((ContentMatcher)m4);
                            continue block23;
                        }
                        case 80: {
                            int tmpRaw = input.readEnum();
                            this.ensureSelectedRegionsIsMutable();
                            this.selectedRegions_.add(tmpRaw);
                            continue block23;
                        }
                        case 82: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureSelectedRegionsIsMutable();
                                this.selectedRegions_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block23;
                        }
                        case 114: {
                            GeneratedMessageV3 m4 = input.readMessage(InternalChecker.parser(), extensionRegistry);
                            if (this.internalCheckersBuilder_ == null) {
                                this.ensureInternalCheckersIsMutable();
                                this.internalCheckers_.add((InternalChecker)m4);
                                continue block23;
                            }
                            this.internalCheckersBuilder_.addMessage((InternalChecker)m4);
                            continue block23;
                        }
                        case 120: {
                            this.isInternal_ = input.readBool();
                            this.bitField0_ |= 0x800;
                            continue block23;
                        }
                        case 136: {
                            this.checkerType_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block23;
                        }
                        case 162: {
                            MapEntry<String, String> userLabels__ = input.readMessage(UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableUserLabels().getMutableMap().put(userLabels__.getKey(), userLabels__.getValue());
                            this.bitField0_ |= 0x2000;
                            continue block23;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public ResourceCase getResourceCase() {
            return ResourceCase.forNumber(this.resourceCase_);
        }

        public Builder clearResource() {
            this.resourceCase_ = 0;
            this.resource_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public CheckRequestTypeCase getCheckRequestTypeCase() {
            return CheckRequestTypeCase.forNumber(this.checkRequestTypeCase_);
        }

        public Builder clearCheckRequestType() {
            this.checkRequestTypeCase_ = 0;
            this.checkRequestType_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.name_ = s2;
                return s2;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = UptimeCheckConfig.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            UptimeCheckConfig.checkByteStringIsUtf8(value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getDisplayName() {
            Object ref = this.displayName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.displayName_ = s2;
                return s2;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDisplayNameBytes() {
            Object ref = this.displayName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.displayName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDisplayName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.displayName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearDisplayName() {
            this.displayName_ = UptimeCheckConfig.getDefaultInstance().getDisplayName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setDisplayNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            UptimeCheckConfig.checkByteStringIsUtf8(value);
            this.displayName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMonitoredResource() {
            return this.resourceCase_ == 3;
        }

        @Override
        public MonitoredResource getMonitoredResource() {
            if (this.monitoredResourceBuilder_ == null) {
                if (this.resourceCase_ == 3) {
                    return (MonitoredResource)this.resource_;
                }
                return MonitoredResource.getDefaultInstance();
            }
            if (this.resourceCase_ == 3) {
                return this.monitoredResourceBuilder_.getMessage();
            }
            return MonitoredResource.getDefaultInstance();
        }

        public Builder setMonitoredResource(MonitoredResource value) {
            if (this.monitoredResourceBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.resource_ = value;
                this.onChanged();
            } else {
                this.monitoredResourceBuilder_.setMessage(value);
            }
            this.resourceCase_ = 3;
            return this;
        }

        public Builder setMonitoredResource(MonitoredResource.Builder builderForValue) {
            if (this.monitoredResourceBuilder_ == null) {
                this.resource_ = builderForValue.build();
                this.onChanged();
            } else {
                this.monitoredResourceBuilder_.setMessage(builderForValue.build());
            }
            this.resourceCase_ = 3;
            return this;
        }

        public Builder mergeMonitoredResource(MonitoredResource value) {
            if (this.monitoredResourceBuilder_ == null) {
                this.resource_ = this.resourceCase_ == 3 && this.resource_ != MonitoredResource.getDefaultInstance() ? MonitoredResource.newBuilder((MonitoredResource)this.resource_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.resourceCase_ == 3) {
                this.monitoredResourceBuilder_.mergeFrom(value);
            } else {
                this.monitoredResourceBuilder_.setMessage(value);
            }
            this.resourceCase_ = 3;
            return this;
        }

        public Builder clearMonitoredResource() {
            if (this.monitoredResourceBuilder_ == null) {
                if (this.resourceCase_ == 3) {
                    this.resourceCase_ = 0;
                    this.resource_ = null;
                    this.onChanged();
                }
            } else {
                if (this.resourceCase_ == 3) {
                    this.resourceCase_ = 0;
                    this.resource_ = null;
                }
                this.monitoredResourceBuilder_.clear();
            }
            return this;
        }

        public MonitoredResource.Builder getMonitoredResourceBuilder() {
            return this.getMonitoredResourceFieldBuilder().getBuilder();
        }

        @Override
        public MonitoredResourceOrBuilder getMonitoredResourceOrBuilder() {
            if (this.resourceCase_ == 3 && this.monitoredResourceBuilder_ != null) {
                return this.monitoredResourceBuilder_.getMessageOrBuilder();
            }
            if (this.resourceCase_ == 3) {
                return (MonitoredResource)this.resource_;
            }
            return MonitoredResource.getDefaultInstance();
        }

        private SingleFieldBuilderV3<MonitoredResource, MonitoredResource.Builder, MonitoredResourceOrBuilder> getMonitoredResourceFieldBuilder() {
            if (this.monitoredResourceBuilder_ == null) {
                if (this.resourceCase_ != 3) {
                    this.resource_ = MonitoredResource.getDefaultInstance();
                }
                this.monitoredResourceBuilder_ = new SingleFieldBuilderV3((MonitoredResource)this.resource_, this.getParentForChildren(), this.isClean());
                this.resource_ = null;
            }
            this.resourceCase_ = 3;
            this.onChanged();
            return this.monitoredResourceBuilder_;
        }

        @Override
        public boolean hasResourceGroup() {
            return this.resourceCase_ == 4;
        }

        @Override
        public ResourceGroup getResourceGroup() {
            if (this.resourceGroupBuilder_ == null) {
                if (this.resourceCase_ == 4) {
                    return (ResourceGroup)this.resource_;
                }
                return ResourceGroup.getDefaultInstance();
            }
            if (this.resourceCase_ == 4) {
                return this.resourceGroupBuilder_.getMessage();
            }
            return ResourceGroup.getDefaultInstance();
        }

        public Builder setResourceGroup(ResourceGroup value) {
            if (this.resourceGroupBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.resource_ = value;
                this.onChanged();
            } else {
                this.resourceGroupBuilder_.setMessage(value);
            }
            this.resourceCase_ = 4;
            return this;
        }

        public Builder setResourceGroup(ResourceGroup.Builder builderForValue) {
            if (this.resourceGroupBuilder_ == null) {
                this.resource_ = builderForValue.build();
                this.onChanged();
            } else {
                this.resourceGroupBuilder_.setMessage(builderForValue.build());
            }
            this.resourceCase_ = 4;
            return this;
        }

        public Builder mergeResourceGroup(ResourceGroup value) {
            if (this.resourceGroupBuilder_ == null) {
                this.resource_ = this.resourceCase_ == 4 && this.resource_ != ResourceGroup.getDefaultInstance() ? ResourceGroup.newBuilder((ResourceGroup)this.resource_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.resourceCase_ == 4) {
                this.resourceGroupBuilder_.mergeFrom(value);
            } else {
                this.resourceGroupBuilder_.setMessage(value);
            }
            this.resourceCase_ = 4;
            return this;
        }

        public Builder clearResourceGroup() {
            if (this.resourceGroupBuilder_ == null) {
                if (this.resourceCase_ == 4) {
                    this.resourceCase_ = 0;
                    this.resource_ = null;
                    this.onChanged();
                }
            } else {
                if (this.resourceCase_ == 4) {
                    this.resourceCase_ = 0;
                    this.resource_ = null;
                }
                this.resourceGroupBuilder_.clear();
            }
            return this;
        }

        public ResourceGroup.Builder getResourceGroupBuilder() {
            return this.getResourceGroupFieldBuilder().getBuilder();
        }

        @Override
        public ResourceGroupOrBuilder getResourceGroupOrBuilder() {
            if (this.resourceCase_ == 4 && this.resourceGroupBuilder_ != null) {
                return this.resourceGroupBuilder_.getMessageOrBuilder();
            }
            if (this.resourceCase_ == 4) {
                return (ResourceGroup)this.resource_;
            }
            return ResourceGroup.getDefaultInstance();
        }

        private SingleFieldBuilderV3<ResourceGroup, ResourceGroup.Builder, ResourceGroupOrBuilder> getResourceGroupFieldBuilder() {
            if (this.resourceGroupBuilder_ == null) {
                if (this.resourceCase_ != 4) {
                    this.resource_ = ResourceGroup.getDefaultInstance();
                }
                this.resourceGroupBuilder_ = new SingleFieldBuilderV3((ResourceGroup)this.resource_, this.getParentForChildren(), this.isClean());
                this.resource_ = null;
            }
            this.resourceCase_ = 4;
            this.onChanged();
            return this.resourceGroupBuilder_;
        }

        @Override
        public boolean hasHttpCheck() {
            return this.checkRequestTypeCase_ == 5;
        }

        @Override
        public HttpCheck getHttpCheck() {
            if (this.httpCheckBuilder_ == null) {
                if (this.checkRequestTypeCase_ == 5) {
                    return (HttpCheck)this.checkRequestType_;
                }
                return HttpCheck.getDefaultInstance();
            }
            if (this.checkRequestTypeCase_ == 5) {
                return this.httpCheckBuilder_.getMessage();
            }
            return HttpCheck.getDefaultInstance();
        }

        public Builder setHttpCheck(HttpCheck value) {
            if (this.httpCheckBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.checkRequestType_ = value;
                this.onChanged();
            } else {
                this.httpCheckBuilder_.setMessage(value);
            }
            this.checkRequestTypeCase_ = 5;
            return this;
        }

        public Builder setHttpCheck(HttpCheck.Builder builderForValue) {
            if (this.httpCheckBuilder_ == null) {
                this.checkRequestType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.httpCheckBuilder_.setMessage(builderForValue.build());
            }
            this.checkRequestTypeCase_ = 5;
            return this;
        }

        public Builder mergeHttpCheck(HttpCheck value) {
            if (this.httpCheckBuilder_ == null) {
                this.checkRequestType_ = this.checkRequestTypeCase_ == 5 && this.checkRequestType_ != HttpCheck.getDefaultInstance() ? HttpCheck.newBuilder((HttpCheck)this.checkRequestType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.checkRequestTypeCase_ == 5) {
                this.httpCheckBuilder_.mergeFrom(value);
            } else {
                this.httpCheckBuilder_.setMessage(value);
            }
            this.checkRequestTypeCase_ = 5;
            return this;
        }

        public Builder clearHttpCheck() {
            if (this.httpCheckBuilder_ == null) {
                if (this.checkRequestTypeCase_ == 5) {
                    this.checkRequestTypeCase_ = 0;
                    this.checkRequestType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.checkRequestTypeCase_ == 5) {
                    this.checkRequestTypeCase_ = 0;
                    this.checkRequestType_ = null;
                }
                this.httpCheckBuilder_.clear();
            }
            return this;
        }

        public HttpCheck.Builder getHttpCheckBuilder() {
            return this.getHttpCheckFieldBuilder().getBuilder();
        }

        @Override
        public HttpCheckOrBuilder getHttpCheckOrBuilder() {
            if (this.checkRequestTypeCase_ == 5 && this.httpCheckBuilder_ != null) {
                return this.httpCheckBuilder_.getMessageOrBuilder();
            }
            if (this.checkRequestTypeCase_ == 5) {
                return (HttpCheck)this.checkRequestType_;
            }
            return HttpCheck.getDefaultInstance();
        }

        private SingleFieldBuilderV3<HttpCheck, HttpCheck.Builder, HttpCheckOrBuilder> getHttpCheckFieldBuilder() {
            if (this.httpCheckBuilder_ == null) {
                if (this.checkRequestTypeCase_ != 5) {
                    this.checkRequestType_ = HttpCheck.getDefaultInstance();
                }
                this.httpCheckBuilder_ = new SingleFieldBuilderV3((HttpCheck)this.checkRequestType_, this.getParentForChildren(), this.isClean());
                this.checkRequestType_ = null;
            }
            this.checkRequestTypeCase_ = 5;
            this.onChanged();
            return this.httpCheckBuilder_;
        }

        @Override
        public boolean hasTcpCheck() {
            return this.checkRequestTypeCase_ == 6;
        }

        @Override
        public TcpCheck getTcpCheck() {
            if (this.tcpCheckBuilder_ == null) {
                if (this.checkRequestTypeCase_ == 6) {
                    return (TcpCheck)this.checkRequestType_;
                }
                return TcpCheck.getDefaultInstance();
            }
            if (this.checkRequestTypeCase_ == 6) {
                return this.tcpCheckBuilder_.getMessage();
            }
            return TcpCheck.getDefaultInstance();
        }

        public Builder setTcpCheck(TcpCheck value) {
            if (this.tcpCheckBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.checkRequestType_ = value;
                this.onChanged();
            } else {
                this.tcpCheckBuilder_.setMessage(value);
            }
            this.checkRequestTypeCase_ = 6;
            return this;
        }

        public Builder setTcpCheck(TcpCheck.Builder builderForValue) {
            if (this.tcpCheckBuilder_ == null) {
                this.checkRequestType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.tcpCheckBuilder_.setMessage(builderForValue.build());
            }
            this.checkRequestTypeCase_ = 6;
            return this;
        }

        public Builder mergeTcpCheck(TcpCheck value) {
            if (this.tcpCheckBuilder_ == null) {
                this.checkRequestType_ = this.checkRequestTypeCase_ == 6 && this.checkRequestType_ != TcpCheck.getDefaultInstance() ? TcpCheck.newBuilder((TcpCheck)this.checkRequestType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.checkRequestTypeCase_ == 6) {
                this.tcpCheckBuilder_.mergeFrom(value);
            } else {
                this.tcpCheckBuilder_.setMessage(value);
            }
            this.checkRequestTypeCase_ = 6;
            return this;
        }

        public Builder clearTcpCheck() {
            if (this.tcpCheckBuilder_ == null) {
                if (this.checkRequestTypeCase_ == 6) {
                    this.checkRequestTypeCase_ = 0;
                    this.checkRequestType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.checkRequestTypeCase_ == 6) {
                    this.checkRequestTypeCase_ = 0;
                    this.checkRequestType_ = null;
                }
                this.tcpCheckBuilder_.clear();
            }
            return this;
        }

        public TcpCheck.Builder getTcpCheckBuilder() {
            return this.getTcpCheckFieldBuilder().getBuilder();
        }

        @Override
        public TcpCheckOrBuilder getTcpCheckOrBuilder() {
            if (this.checkRequestTypeCase_ == 6 && this.tcpCheckBuilder_ != null) {
                return this.tcpCheckBuilder_.getMessageOrBuilder();
            }
            if (this.checkRequestTypeCase_ == 6) {
                return (TcpCheck)this.checkRequestType_;
            }
            return TcpCheck.getDefaultInstance();
        }

        private SingleFieldBuilderV3<TcpCheck, TcpCheck.Builder, TcpCheckOrBuilder> getTcpCheckFieldBuilder() {
            if (this.tcpCheckBuilder_ == null) {
                if (this.checkRequestTypeCase_ != 6) {
                    this.checkRequestType_ = TcpCheck.getDefaultInstance();
                }
                this.tcpCheckBuilder_ = new SingleFieldBuilderV3((TcpCheck)this.checkRequestType_, this.getParentForChildren(), this.isClean());
                this.checkRequestType_ = null;
            }
            this.checkRequestTypeCase_ = 6;
            this.onChanged();
            return this.tcpCheckBuilder_;
        }

        @Override
        public boolean hasPeriod() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Duration getPeriod() {
            if (this.periodBuilder_ == null) {
                return this.period_ == null ? Duration.getDefaultInstance() : this.period_;
            }
            return this.periodBuilder_.getMessage();
        }

        public Builder setPeriod(Duration value) {
            if (this.periodBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.period_ = value;
            } else {
                this.periodBuilder_.setMessage(value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setPeriod(Duration.Builder builderForValue) {
            if (this.periodBuilder_ == null) {
                this.period_ = builderForValue.build();
            } else {
                this.periodBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergePeriod(Duration value) {
            if (this.periodBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.period_ != null && this.period_ != Duration.getDefaultInstance()) {
                    this.getPeriodBuilder().mergeFrom(value);
                } else {
                    this.period_ = value;
                }
            } else {
                this.periodBuilder_.mergeFrom(value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearPeriod() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.period_ = null;
            if (this.periodBuilder_ != null) {
                this.periodBuilder_.dispose();
                this.periodBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getPeriodBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this.getPeriodFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getPeriodOrBuilder() {
            if (this.periodBuilder_ != null) {
                return this.periodBuilder_.getMessageOrBuilder();
            }
            return this.period_ == null ? Duration.getDefaultInstance() : this.period_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getPeriodFieldBuilder() {
            if (this.periodBuilder_ == null) {
                this.periodBuilder_ = new SingleFieldBuilderV3(this.getPeriod(), this.getParentForChildren(), this.isClean());
                this.period_ = null;
            }
            return this.periodBuilder_;
        }

        @Override
        public boolean hasTimeout() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Duration getTimeout() {
            if (this.timeoutBuilder_ == null) {
                return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
            }
            return this.timeoutBuilder_.getMessage();
        }

        public Builder setTimeout(Duration value) {
            if (this.timeoutBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.timeout_ = value;
            } else {
                this.timeoutBuilder_.setMessage(value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setTimeout(Duration.Builder builderForValue) {
            if (this.timeoutBuilder_ == null) {
                this.timeout_ = builderForValue.build();
            } else {
                this.timeoutBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeTimeout(Duration value) {
            if (this.timeoutBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.timeout_ != null && this.timeout_ != Duration.getDefaultInstance()) {
                    this.getTimeoutBuilder().mergeFrom(value);
                } else {
                    this.timeout_ = value;
                }
            } else {
                this.timeoutBuilder_.mergeFrom(value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearTimeout() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.timeout_ = null;
            if (this.timeoutBuilder_ != null) {
                this.timeoutBuilder_.dispose();
                this.timeoutBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getTimeoutBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this.getTimeoutFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getTimeoutOrBuilder() {
            if (this.timeoutBuilder_ != null) {
                return this.timeoutBuilder_.getMessageOrBuilder();
            }
            return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getTimeoutFieldBuilder() {
            if (this.timeoutBuilder_ == null) {
                this.timeoutBuilder_ = new SingleFieldBuilderV3(this.getTimeout(), this.getParentForChildren(), this.isClean());
                this.timeout_ = null;
            }
            return this.timeoutBuilder_;
        }

        private void ensureContentMatchersIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.contentMatchers_ = new ArrayList<ContentMatcher>(this.contentMatchers_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<ContentMatcher> getContentMatchersList() {
            if (this.contentMatchersBuilder_ == null) {
                return Collections.unmodifiableList(this.contentMatchers_);
            }
            return this.contentMatchersBuilder_.getMessageList();
        }

        @Override
        public int getContentMatchersCount() {
            if (this.contentMatchersBuilder_ == null) {
                return this.contentMatchers_.size();
            }
            return this.contentMatchersBuilder_.getCount();
        }

        @Override
        public ContentMatcher getContentMatchers(int index) {
            if (this.contentMatchersBuilder_ == null) {
                return this.contentMatchers_.get(index);
            }
            return this.contentMatchersBuilder_.getMessage(index);
        }

        public Builder setContentMatchers(int index, ContentMatcher value) {
            if (this.contentMatchersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureContentMatchersIsMutable();
                this.contentMatchers_.set(index, value);
                this.onChanged();
            } else {
                this.contentMatchersBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setContentMatchers(int index, ContentMatcher.Builder builderForValue) {
            if (this.contentMatchersBuilder_ == null) {
                this.ensureContentMatchersIsMutable();
                this.contentMatchers_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.contentMatchersBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addContentMatchers(ContentMatcher value) {
            if (this.contentMatchersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureContentMatchersIsMutable();
                this.contentMatchers_.add(value);
                this.onChanged();
            } else {
                this.contentMatchersBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addContentMatchers(int index, ContentMatcher value) {
            if (this.contentMatchersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureContentMatchersIsMutable();
                this.contentMatchers_.add(index, value);
                this.onChanged();
            } else {
                this.contentMatchersBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addContentMatchers(ContentMatcher.Builder builderForValue) {
            if (this.contentMatchersBuilder_ == null) {
                this.ensureContentMatchersIsMutable();
                this.contentMatchers_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.contentMatchersBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addContentMatchers(int index, ContentMatcher.Builder builderForValue) {
            if (this.contentMatchersBuilder_ == null) {
                this.ensureContentMatchersIsMutable();
                this.contentMatchers_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.contentMatchersBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllContentMatchers(Iterable<? extends ContentMatcher> values) {
            if (this.contentMatchersBuilder_ == null) {
                this.ensureContentMatchersIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.contentMatchers_);
                this.onChanged();
            } else {
                this.contentMatchersBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearContentMatchers() {
            if (this.contentMatchersBuilder_ == null) {
                this.contentMatchers_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
            } else {
                this.contentMatchersBuilder_.clear();
            }
            return this;
        }

        public Builder removeContentMatchers(int index) {
            if (this.contentMatchersBuilder_ == null) {
                this.ensureContentMatchersIsMutable();
                this.contentMatchers_.remove(index);
                this.onChanged();
            } else {
                this.contentMatchersBuilder_.remove(index);
            }
            return this;
        }

        public ContentMatcher.Builder getContentMatchersBuilder(int index) {
            return this.getContentMatchersFieldBuilder().getBuilder(index);
        }

        @Override
        public ContentMatcherOrBuilder getContentMatchersOrBuilder(int index) {
            if (this.contentMatchersBuilder_ == null) {
                return this.contentMatchers_.get(index);
            }
            return this.contentMatchersBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ContentMatcherOrBuilder> getContentMatchersOrBuilderList() {
            if (this.contentMatchersBuilder_ != null) {
                return this.contentMatchersBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.contentMatchers_);
        }

        public ContentMatcher.Builder addContentMatchersBuilder() {
            return this.getContentMatchersFieldBuilder().addBuilder(ContentMatcher.getDefaultInstance());
        }

        public ContentMatcher.Builder addContentMatchersBuilder(int index) {
            return this.getContentMatchersFieldBuilder().addBuilder(index, ContentMatcher.getDefaultInstance());
        }

        public List<ContentMatcher.Builder> getContentMatchersBuilderList() {
            return this.getContentMatchersFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ContentMatcher, ContentMatcher.Builder, ContentMatcherOrBuilder> getContentMatchersFieldBuilder() {
            if (this.contentMatchersBuilder_ == null) {
                this.contentMatchersBuilder_ = new RepeatedFieldBuilderV3(this.contentMatchers_, (this.bitField0_ & 0x100) != 0, this.getParentForChildren(), this.isClean());
                this.contentMatchers_ = null;
            }
            return this.contentMatchersBuilder_;
        }

        @Override
        public int getCheckerTypeValue() {
            return this.checkerType_;
        }

        public Builder setCheckerTypeValue(int value) {
            this.checkerType_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public CheckerType getCheckerType() {
            CheckerType result = CheckerType.forNumber(this.checkerType_);
            return result == null ? CheckerType.UNRECOGNIZED : result;
        }

        public Builder setCheckerType(CheckerType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.checkerType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCheckerType() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.checkerType_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureSelectedRegionsIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.selectedRegions_ = new ArrayList<Integer>(this.selectedRegions_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<UptimeCheckRegion> getSelectedRegionsList() {
            return new Internal.ListAdapter(this.selectedRegions_, selectedRegions_converter_);
        }

        @Override
        public int getSelectedRegionsCount() {
            return this.selectedRegions_.size();
        }

        @Override
        public UptimeCheckRegion getSelectedRegions(int index) {
            return (UptimeCheckRegion)selectedRegions_converter_.convert(this.selectedRegions_.get(index));
        }

        public Builder setSelectedRegions(int index, UptimeCheckRegion value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSelectedRegionsIsMutable();
            this.selectedRegions_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addSelectedRegions(UptimeCheckRegion value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSelectedRegionsIsMutable();
            this.selectedRegions_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllSelectedRegions(Iterable<? extends UptimeCheckRegion> values) {
            this.ensureSelectedRegionsIsMutable();
            for (UptimeCheckRegion uptimeCheckRegion : values) {
                this.selectedRegions_.add(uptimeCheckRegion.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearSelectedRegions() {
            this.selectedRegions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getSelectedRegionsValueList() {
            return Collections.unmodifiableList(this.selectedRegions_);
        }

        @Override
        public int getSelectedRegionsValue(int index) {
            return this.selectedRegions_.get(index);
        }

        public Builder setSelectedRegionsValue(int index, int value) {
            this.ensureSelectedRegionsIsMutable();
            this.selectedRegions_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addSelectedRegionsValue(int value) {
            this.ensureSelectedRegionsIsMutable();
            this.selectedRegions_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllSelectedRegionsValue(Iterable<Integer> values) {
            this.ensureSelectedRegionsIsMutable();
            for (int value : values) {
                this.selectedRegions_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        @Deprecated
        public boolean getIsInternal() {
            return this.isInternal_;
        }

        @Deprecated
        public Builder setIsInternal(boolean value) {
            this.isInternal_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder clearIsInternal() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.isInternal_ = false;
            this.onChanged();
            return this;
        }

        private void ensureInternalCheckersIsMutable() {
            if ((this.bitField0_ & 0x1000) == 0) {
                this.internalCheckers_ = new ArrayList<InternalChecker>(this.internalCheckers_);
                this.bitField0_ |= 0x1000;
            }
        }

        @Override
        @Deprecated
        public List<InternalChecker> getInternalCheckersList() {
            if (this.internalCheckersBuilder_ == null) {
                return Collections.unmodifiableList(this.internalCheckers_);
            }
            return this.internalCheckersBuilder_.getMessageList();
        }

        @Override
        @Deprecated
        public int getInternalCheckersCount() {
            if (this.internalCheckersBuilder_ == null) {
                return this.internalCheckers_.size();
            }
            return this.internalCheckersBuilder_.getCount();
        }

        @Override
        @Deprecated
        public InternalChecker getInternalCheckers(int index) {
            if (this.internalCheckersBuilder_ == null) {
                return this.internalCheckers_.get(index);
            }
            return this.internalCheckersBuilder_.getMessage(index);
        }

        @Deprecated
        public Builder setInternalCheckers(int index, InternalChecker value) {
            if (this.internalCheckersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInternalCheckersIsMutable();
                this.internalCheckers_.set(index, value);
                this.onChanged();
            } else {
                this.internalCheckersBuilder_.setMessage(index, value);
            }
            return this;
        }

        @Deprecated
        public Builder setInternalCheckers(int index, InternalChecker.Builder builderForValue) {
            if (this.internalCheckersBuilder_ == null) {
                this.ensureInternalCheckersIsMutable();
                this.internalCheckers_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.internalCheckersBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        @Deprecated
        public Builder addInternalCheckers(InternalChecker value) {
            if (this.internalCheckersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInternalCheckersIsMutable();
                this.internalCheckers_.add(value);
                this.onChanged();
            } else {
                this.internalCheckersBuilder_.addMessage(value);
            }
            return this;
        }

        @Deprecated
        public Builder addInternalCheckers(int index, InternalChecker value) {
            if (this.internalCheckersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInternalCheckersIsMutable();
                this.internalCheckers_.add(index, value);
                this.onChanged();
            } else {
                this.internalCheckersBuilder_.addMessage(index, value);
            }
            return this;
        }

        @Deprecated
        public Builder addInternalCheckers(InternalChecker.Builder builderForValue) {
            if (this.internalCheckersBuilder_ == null) {
                this.ensureInternalCheckersIsMutable();
                this.internalCheckers_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.internalCheckersBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        @Deprecated
        public Builder addInternalCheckers(int index, InternalChecker.Builder builderForValue) {
            if (this.internalCheckersBuilder_ == null) {
                this.ensureInternalCheckersIsMutable();
                this.internalCheckers_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.internalCheckersBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        @Deprecated
        public Builder addAllInternalCheckers(Iterable<? extends InternalChecker> values) {
            if (this.internalCheckersBuilder_ == null) {
                this.ensureInternalCheckersIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.internalCheckers_);
                this.onChanged();
            } else {
                this.internalCheckersBuilder_.addAllMessages(values);
            }
            return this;
        }

        @Deprecated
        public Builder clearInternalCheckers() {
            if (this.internalCheckersBuilder_ == null) {
                this.internalCheckers_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFEFFF;
                this.onChanged();
            } else {
                this.internalCheckersBuilder_.clear();
            }
            return this;
        }

        @Deprecated
        public Builder removeInternalCheckers(int index) {
            if (this.internalCheckersBuilder_ == null) {
                this.ensureInternalCheckersIsMutable();
                this.internalCheckers_.remove(index);
                this.onChanged();
            } else {
                this.internalCheckersBuilder_.remove(index);
            }
            return this;
        }

        @Deprecated
        public InternalChecker.Builder getInternalCheckersBuilder(int index) {
            return this.getInternalCheckersFieldBuilder().getBuilder(index);
        }

        @Override
        @Deprecated
        public InternalCheckerOrBuilder getInternalCheckersOrBuilder(int index) {
            if (this.internalCheckersBuilder_ == null) {
                return this.internalCheckers_.get(index);
            }
            return this.internalCheckersBuilder_.getMessageOrBuilder(index);
        }

        @Override
        @Deprecated
        public List<? extends InternalCheckerOrBuilder> getInternalCheckersOrBuilderList() {
            if (this.internalCheckersBuilder_ != null) {
                return this.internalCheckersBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.internalCheckers_);
        }

        @Deprecated
        public InternalChecker.Builder addInternalCheckersBuilder() {
            return this.getInternalCheckersFieldBuilder().addBuilder(InternalChecker.getDefaultInstance());
        }

        @Deprecated
        public InternalChecker.Builder addInternalCheckersBuilder(int index) {
            return this.getInternalCheckersFieldBuilder().addBuilder(index, InternalChecker.getDefaultInstance());
        }

        @Deprecated
        public List<InternalChecker.Builder> getInternalCheckersBuilderList() {
            return this.getInternalCheckersFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<InternalChecker, InternalChecker.Builder, InternalCheckerOrBuilder> getInternalCheckersFieldBuilder() {
            if (this.internalCheckersBuilder_ == null) {
                this.internalCheckersBuilder_ = new RepeatedFieldBuilderV3(this.internalCheckers_, (this.bitField0_ & 0x1000) != 0, this.getParentForChildren(), this.isClean());
                this.internalCheckers_ = null;
            }
            return this.internalCheckersBuilder_;
        }

        private MapField<String, String> internalGetUserLabels() {
            if (this.userLabels_ == null) {
                return MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
            }
            return this.userLabels_;
        }

        private MapField<String, String> internalGetMutableUserLabels() {
            if (this.userLabels_ == null) {
                this.userLabels_ = MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.userLabels_.isMutable()) {
                this.userLabels_ = this.userLabels_.copy();
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this.userLabels_;
        }

        @Override
        public int getUserLabelsCount() {
            return this.internalGetUserLabels().getMap().size();
        }

        @Override
        public boolean containsUserLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetUserLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getUserLabels() {
            return this.getUserLabelsMap();
        }

        @Override
        public Map<String, String> getUserLabelsMap() {
            return this.internalGetUserLabels().getMap();
        }

        @Override
        public String getUserLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map<String, String> map = this.internalGetUserLabels().getMap();
            return map.containsKey(key) ? map.get(key) : defaultValue;
        }

        @Override
        public String getUserLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map<String, String> map = this.internalGetUserLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return map.get(key);
        }

        public Builder clearUserLabels() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.internalGetMutableUserLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeUserLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableUserLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableUserLabels() {
            this.bitField0_ |= 0x2000;
            return this.internalGetMutableUserLabels().getMutableMap();
        }

        public Builder putUserLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableUserLabels().getMutableMap().put(key, value);
            this.bitField0_ |= 0x2000;
            return this;
        }

        public Builder putAllUserLabels(Map<String, String> values) {
            this.internalGetMutableUserLabels().getMutableMap().putAll(values);
            this.bitField0_ |= 0x2000;
            return this;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class UserLabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance(UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_UserLabelsEntry_descriptor, WireFormat.FieldType.STRING, "", WireFormat.FieldType.STRING, "");

        private UserLabelsDefaultEntryHolder() {
        }
    }

    public static enum CheckRequestTypeCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        HTTP_CHECK(5),
        TCP_CHECK(6),
        CHECKREQUESTTYPE_NOT_SET(0);

        private final int value;

        private CheckRequestTypeCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static CheckRequestTypeCase valueOf(int value) {
            return CheckRequestTypeCase.forNumber(value);
        }

        public static CheckRequestTypeCase forNumber(int value) {
            switch (value) {
                case 5: {
                    return HTTP_CHECK;
                }
                case 6: {
                    return TCP_CHECK;
                }
                case 0: {
                    return CHECKREQUESTTYPE_NOT_SET;
                }
            }
            return null;
        }

        @Override
        public int getNumber() {
            return this.value;
        }
    }

    public static enum ResourceCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        MONITORED_RESOURCE(3),
        RESOURCE_GROUP(4),
        RESOURCE_NOT_SET(0);

        private final int value;

        private ResourceCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static ResourceCase valueOf(int value) {
            return ResourceCase.forNumber(value);
        }

        public static ResourceCase forNumber(int value) {
            switch (value) {
                case 3: {
                    return MONITORED_RESOURCE;
                }
                case 4: {
                    return RESOURCE_GROUP;
                }
                case 0: {
                    return RESOURCE_NOT_SET;
                }
            }
            return null;
        }

        @Override
        public int getNumber() {
            return this.value;
        }
    }

    public static final class ContentMatcher
    extends GeneratedMessageV3
    implements ContentMatcherOrBuilder {
        private static final long serialVersionUID = 0L;
        private int additionalMatcherInfoCase_ = 0;
        private Object additionalMatcherInfo_;
        public static final int CONTENT_FIELD_NUMBER = 1;
        private volatile Object content_ = "";
        public static final int MATCHER_FIELD_NUMBER = 2;
        private int matcher_ = 0;
        public static final int JSON_PATH_MATCHER_FIELD_NUMBER = 3;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ContentMatcher DEFAULT_INSTANCE = new ContentMatcher();
        private static final Parser<ContentMatcher> PARSER = new AbstractParser<ContentMatcher>(){

            @Override
            public ContentMatcher parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ContentMatcher.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private ContentMatcher(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private ContentMatcher() {
            this.content_ = "";
            this.matcher_ = 0;
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new ContentMatcher();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_fieldAccessorTable.ensureFieldAccessorsInitialized(ContentMatcher.class, Builder.class);
        }

        @Override
        public AdditionalMatcherInfoCase getAdditionalMatcherInfoCase() {
            return AdditionalMatcherInfoCase.forNumber(this.additionalMatcherInfoCase_);
        }

        @Override
        public String getContent() {
            Object ref = this.content_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s2 = bs.toStringUtf8();
            this.content_ = s2;
            return s2;
        }

        @Override
        public ByteString getContentBytes() {
            Object ref = this.content_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.content_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public int getMatcherValue() {
            return this.matcher_;
        }

        @Override
        public ContentMatcherOption getMatcher() {
            ContentMatcherOption result = ContentMatcherOption.forNumber(this.matcher_);
            return result == null ? ContentMatcherOption.UNRECOGNIZED : result;
        }

        @Override
        public boolean hasJsonPathMatcher() {
            return this.additionalMatcherInfoCase_ == 3;
        }

        @Override
        public JsonPathMatcher getJsonPathMatcher() {
            if (this.additionalMatcherInfoCase_ == 3) {
                return (JsonPathMatcher)this.additionalMatcherInfo_;
            }
            return JsonPathMatcher.getDefaultInstance();
        }

        @Override
        public JsonPathMatcherOrBuilder getJsonPathMatcherOrBuilder() {
            if (this.additionalMatcherInfoCase_ == 3) {
                return (JsonPathMatcher)this.additionalMatcherInfo_;
            }
            return JsonPathMatcher.getDefaultInstance();
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty(this.content_)) {
                GeneratedMessageV3.writeString(output, 1, this.content_);
            }
            if (this.matcher_ != ContentMatcherOption.CONTENT_MATCHER_OPTION_UNSPECIFIED.getNumber()) {
                output.writeEnum(2, this.matcher_);
            }
            if (this.additionalMatcherInfoCase_ == 3) {
                output.writeMessage(3, (JsonPathMatcher)this.additionalMatcherInfo_);
            }
            this.getUnknownFields().writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty(this.content_)) {
                size += GeneratedMessageV3.computeStringSize(1, this.content_);
            }
            if (this.matcher_ != ContentMatcherOption.CONTENT_MATCHER_OPTION_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize(2, this.matcher_);
            }
            if (this.additionalMatcherInfoCase_ == 3) {
                size += CodedOutputStream.computeMessageSize(3, (JsonPathMatcher)this.additionalMatcherInfo_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ContentMatcher)) {
                return super.equals(obj);
            }
            ContentMatcher other = (ContentMatcher)obj;
            if (!this.getContent().equals(other.getContent())) {
                return false;
            }
            if (this.matcher_ != other.matcher_) {
                return false;
            }
            if (!this.getAdditionalMatcherInfoCase().equals(other.getAdditionalMatcherInfoCase())) {
                return false;
            }
            switch (this.additionalMatcherInfoCase_) {
                case 3: {
                    if (this.getJsonPathMatcher().equals(other.getJsonPathMatcher())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals(other.getUnknownFields());
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ContentMatcher.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getContent().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.matcher_;
            switch (this.additionalMatcherInfoCase_) {
                case 3: {
                    hash = 37 * hash + 3;
                    hash = 53 * hash + this.getJsonPathMatcher().hashCode();
                    break;
                }
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static ContentMatcher parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ContentMatcher parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ContentMatcher parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ContentMatcher parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ContentMatcher parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ContentMatcher parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ContentMatcher parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static ContentMatcher parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static ContentMatcher parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static ContentMatcher parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static ContentMatcher parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static ContentMatcher parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return ContentMatcher.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ContentMatcher prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ContentMatcher getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ContentMatcher> parser() {
            return PARSER;
        }

        public Parser<ContentMatcher> getParserForType() {
            return PARSER;
        }

        @Override
        public ContentMatcher getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ContentMatcherOrBuilder {
            private int additionalMatcherInfoCase_ = 0;
            private Object additionalMatcherInfo_;
            private int bitField0_;
            private Object content_ = "";
            private int matcher_ = 0;
            private SingleFieldBuilderV3<JsonPathMatcher, JsonPathMatcher.Builder, JsonPathMatcherOrBuilder> jsonPathMatcherBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_fieldAccessorTable.ensureFieldAccessorsInitialized(ContentMatcher.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            @Override
            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.content_ = "";
                this.matcher_ = 0;
                if (this.jsonPathMatcherBuilder_ != null) {
                    this.jsonPathMatcherBuilder_.clear();
                }
                this.additionalMatcherInfoCase_ = 0;
                this.additionalMatcherInfo_ = null;
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_descriptor;
            }

            @Override
            public ContentMatcher getDefaultInstanceForType() {
                return ContentMatcher.getDefaultInstance();
            }

            @Override
            public ContentMatcher build() {
                ContentMatcher result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public ContentMatcher buildPartial() {
                ContentMatcher result = new ContentMatcher(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.buildPartialOneofs(result);
                this.onBuilt();
                return result;
            }

            private void buildPartial0(ContentMatcher result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.content_ = this.content_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.matcher_ = this.matcher_;
                }
            }

            private void buildPartialOneofs(ContentMatcher result) {
                result.additionalMatcherInfoCase_ = this.additionalMatcherInfoCase_;
                result.additionalMatcherInfo_ = this.additionalMatcherInfo_;
                if (this.additionalMatcherInfoCase_ == 3 && this.jsonPathMatcherBuilder_ != null) {
                    result.additionalMatcherInfo_ = this.jsonPathMatcherBuilder_.build();
                }
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof ContentMatcher) {
                    return this.mergeFrom((ContentMatcher)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ContentMatcher other) {
                if (other == ContentMatcher.getDefaultInstance()) {
                    return this;
                }
                if (!other.getContent().isEmpty()) {
                    this.content_ = other.content_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (other.matcher_ != 0) {
                    this.setMatcherValue(other.getMatcherValue());
                }
                switch (other.getAdditionalMatcherInfoCase()) {
                    case JSON_PATH_MATCHER: {
                        this.mergeJsonPathMatcher(other.getJsonPathMatcher());
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 10: {
                                this.content_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block11;
                            }
                            case 16: {
                                this.matcher_ = input.readEnum();
                                this.bitField0_ |= 2;
                                continue block11;
                            }
                            case 26: {
                                input.readMessage(this.getJsonPathMatcherFieldBuilder().getBuilder(), extensionRegistry);
                                this.additionalMatcherInfoCase_ = 3;
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public AdditionalMatcherInfoCase getAdditionalMatcherInfoCase() {
                return AdditionalMatcherInfoCase.forNumber(this.additionalMatcherInfoCase_);
            }

            public Builder clearAdditionalMatcherInfo() {
                this.additionalMatcherInfoCase_ = 0;
                this.additionalMatcherInfo_ = null;
                this.onChanged();
                return this;
            }

            @Override
            public String getContent() {
                Object ref = this.content_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s2 = bs.toStringUtf8();
                    this.content_ = s2;
                    return s2;
                }
                return (String)ref;
            }

            @Override
            public ByteString getContentBytes() {
                Object ref = this.content_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.content_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setContent(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.content_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearContent() {
                this.content_ = ContentMatcher.getDefaultInstance().getContent();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setContentBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ContentMatcher.checkByteStringIsUtf8(value);
                this.content_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public int getMatcherValue() {
                return this.matcher_;
            }

            public Builder setMatcherValue(int value) {
                this.matcher_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            @Override
            public ContentMatcherOption getMatcher() {
                ContentMatcherOption result = ContentMatcherOption.forNumber(this.matcher_);
                return result == null ? ContentMatcherOption.UNRECOGNIZED : result;
            }

            public Builder setMatcher(ContentMatcherOption value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 2;
                this.matcher_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearMatcher() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.matcher_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasJsonPathMatcher() {
                return this.additionalMatcherInfoCase_ == 3;
            }

            @Override
            public JsonPathMatcher getJsonPathMatcher() {
                if (this.jsonPathMatcherBuilder_ == null) {
                    if (this.additionalMatcherInfoCase_ == 3) {
                        return (JsonPathMatcher)this.additionalMatcherInfo_;
                    }
                    return JsonPathMatcher.getDefaultInstance();
                }
                if (this.additionalMatcherInfoCase_ == 3) {
                    return this.jsonPathMatcherBuilder_.getMessage();
                }
                return JsonPathMatcher.getDefaultInstance();
            }

            public Builder setJsonPathMatcher(JsonPathMatcher value) {
                if (this.jsonPathMatcherBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.additionalMatcherInfo_ = value;
                    this.onChanged();
                } else {
                    this.jsonPathMatcherBuilder_.setMessage(value);
                }
                this.additionalMatcherInfoCase_ = 3;
                return this;
            }

            public Builder setJsonPathMatcher(JsonPathMatcher.Builder builderForValue) {
                if (this.jsonPathMatcherBuilder_ == null) {
                    this.additionalMatcherInfo_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.jsonPathMatcherBuilder_.setMessage(builderForValue.build());
                }
                this.additionalMatcherInfoCase_ = 3;
                return this;
            }

            public Builder mergeJsonPathMatcher(JsonPathMatcher value) {
                if (this.jsonPathMatcherBuilder_ == null) {
                    this.additionalMatcherInfo_ = this.additionalMatcherInfoCase_ == 3 && this.additionalMatcherInfo_ != JsonPathMatcher.getDefaultInstance() ? JsonPathMatcher.newBuilder((JsonPathMatcher)this.additionalMatcherInfo_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.additionalMatcherInfoCase_ == 3) {
                    this.jsonPathMatcherBuilder_.mergeFrom(value);
                } else {
                    this.jsonPathMatcherBuilder_.setMessage(value);
                }
                this.additionalMatcherInfoCase_ = 3;
                return this;
            }

            public Builder clearJsonPathMatcher() {
                if (this.jsonPathMatcherBuilder_ == null) {
                    if (this.additionalMatcherInfoCase_ == 3) {
                        this.additionalMatcherInfoCase_ = 0;
                        this.additionalMatcherInfo_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.additionalMatcherInfoCase_ == 3) {
                        this.additionalMatcherInfoCase_ = 0;
                        this.additionalMatcherInfo_ = null;
                    }
                    this.jsonPathMatcherBuilder_.clear();
                }
                return this;
            }

            public JsonPathMatcher.Builder getJsonPathMatcherBuilder() {
                return this.getJsonPathMatcherFieldBuilder().getBuilder();
            }

            @Override
            public JsonPathMatcherOrBuilder getJsonPathMatcherOrBuilder() {
                if (this.additionalMatcherInfoCase_ == 3 && this.jsonPathMatcherBuilder_ != null) {
                    return this.jsonPathMatcherBuilder_.getMessageOrBuilder();
                }
                if (this.additionalMatcherInfoCase_ == 3) {
                    return (JsonPathMatcher)this.additionalMatcherInfo_;
                }
                return JsonPathMatcher.getDefaultInstance();
            }

            private SingleFieldBuilderV3<JsonPathMatcher, JsonPathMatcher.Builder, JsonPathMatcherOrBuilder> getJsonPathMatcherFieldBuilder() {
                if (this.jsonPathMatcherBuilder_ == null) {
                    if (this.additionalMatcherInfoCase_ != 3) {
                        this.additionalMatcherInfo_ = JsonPathMatcher.getDefaultInstance();
                    }
                    this.jsonPathMatcherBuilder_ = new SingleFieldBuilderV3((JsonPathMatcher)this.additionalMatcherInfo_, this.getParentForChildren(), this.isClean());
                    this.additionalMatcherInfo_ = null;
                }
                this.additionalMatcherInfoCase_ = 3;
                this.onChanged();
                return this.jsonPathMatcherBuilder_;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum AdditionalMatcherInfoCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            JSON_PATH_MATCHER(3),
            ADDITIONALMATCHERINFO_NOT_SET(0);

            private final int value;

            private AdditionalMatcherInfoCase(int value) {
                this.value = value;
            }

            @Deprecated
            public static AdditionalMatcherInfoCase valueOf(int value) {
                return AdditionalMatcherInfoCase.forNumber(value);
            }

            public static AdditionalMatcherInfoCase forNumber(int value) {
                switch (value) {
                    case 3: {
                        return JSON_PATH_MATCHER;
                    }
                    case 0: {
                        return ADDITIONALMATCHERINFO_NOT_SET;
                    }
                }
                return null;
            }

            @Override
            public int getNumber() {
                return this.value;
            }
        }

        public static final class JsonPathMatcher
        extends GeneratedMessageV3
        implements JsonPathMatcherOrBuilder {
            private static final long serialVersionUID = 0L;
            public static final int JSON_PATH_FIELD_NUMBER = 1;
            private volatile Object jsonPath_ = "";
            public static final int JSON_MATCHER_FIELD_NUMBER = 2;
            private int jsonMatcher_ = 0;
            private byte memoizedIsInitialized = (byte)-1;
            private static final JsonPathMatcher DEFAULT_INSTANCE = new JsonPathMatcher();
            private static final Parser<JsonPathMatcher> PARSER = new AbstractParser<JsonPathMatcher>(){

                @Override
                public JsonPathMatcher parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = JsonPathMatcher.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private JsonPathMatcher(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private JsonPathMatcher() {
                this.jsonPath_ = "";
                this.jsonMatcher_ = 0;
            }

            @Override
            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new JsonPathMatcher();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_fieldAccessorTable.ensureFieldAccessorsInitialized(JsonPathMatcher.class, Builder.class);
            }

            @Override
            public String getJsonPath() {
                Object ref = this.jsonPath_;
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.jsonPath_ = s2;
                return s2;
            }

            @Override
            public ByteString getJsonPathBytes() {
                Object ref = this.jsonPath_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.jsonPath_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            @Override
            public int getJsonMatcherValue() {
                return this.jsonMatcher_;
            }

            @Override
            public JsonPathMatcherOption getJsonMatcher() {
                JsonPathMatcherOption result = JsonPathMatcherOption.forNumber(this.jsonMatcher_);
                return result == null ? JsonPathMatcherOption.UNRECOGNIZED : result;
            }

            @Override
            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            @Override
            public void writeTo(CodedOutputStream output) throws IOException {
                if (!GeneratedMessageV3.isStringEmpty(this.jsonPath_)) {
                    GeneratedMessageV3.writeString(output, 1, this.jsonPath_);
                }
                if (this.jsonMatcher_ != JsonPathMatcherOption.JSON_PATH_MATCHER_OPTION_UNSPECIFIED.getNumber()) {
                    output.writeEnum(2, this.jsonMatcher_);
                }
                this.getUnknownFields().writeTo(output);
            }

            @Override
            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if (!GeneratedMessageV3.isStringEmpty(this.jsonPath_)) {
                    size += GeneratedMessageV3.computeStringSize(1, this.jsonPath_);
                }
                if (this.jsonMatcher_ != JsonPathMatcherOption.JSON_PATH_MATCHER_OPTION_UNSPECIFIED.getNumber()) {
                    size += CodedOutputStream.computeEnumSize(2, this.jsonMatcher_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof JsonPathMatcher)) {
                    return super.equals(obj);
                }
                JsonPathMatcher other = (JsonPathMatcher)obj;
                if (!this.getJsonPath().equals(other.getJsonPath())) {
                    return false;
                }
                if (this.jsonMatcher_ != other.jsonMatcher_) {
                    return false;
                }
                return this.getUnknownFields().equals(other.getUnknownFields());
            }

            @Override
            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + JsonPathMatcher.getDescriptor().hashCode();
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getJsonPath().hashCode();
                hash = 37 * hash + 2;
                hash = 53 * hash + this.jsonMatcher_;
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static JsonPathMatcher parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }

            public static JsonPathMatcher parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }

            public static JsonPathMatcher parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }

            public static JsonPathMatcher parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }

            public static JsonPathMatcher parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }

            public static JsonPathMatcher parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }

            public static JsonPathMatcher parseFrom(InputStream input) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static JsonPathMatcher parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static JsonPathMatcher parseDelimitedFrom(InputStream input) throws IOException {
                return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
            }

            public static JsonPathMatcher parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }

            public static JsonPathMatcher parseFrom(CodedInputStream input) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static JsonPathMatcher parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
            }

            @Override
            public Builder newBuilderForType() {
                return JsonPathMatcher.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(JsonPathMatcher prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            @Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            @Override
            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static JsonPathMatcher getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<JsonPathMatcher> parser() {
                return PARSER;
            }

            public Parser<JsonPathMatcher> getParserForType() {
                return PARSER;
            }

            @Override
            public JsonPathMatcher getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements JsonPathMatcherOrBuilder {
                private int bitField0_;
                private Object jsonPath_ = "";
                private int jsonMatcher_ = 0;

                public static final Descriptors.Descriptor getDescriptor() {
                    return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_descriptor;
                }

                @Override
                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_fieldAccessorTable.ensureFieldAccessorsInitialized(JsonPathMatcher.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                @Override
                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.jsonPath_ = "";
                    this.jsonMatcher_ = 0;
                    return this;
                }

                @Override
                public Descriptors.Descriptor getDescriptorForType() {
                    return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_descriptor;
                }

                @Override
                public JsonPathMatcher getDefaultInstanceForType() {
                    return JsonPathMatcher.getDefaultInstance();
                }

                @Override
                public JsonPathMatcher build() {
                    JsonPathMatcher result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException(result);
                    }
                    return result;
                }

                @Override
                public JsonPathMatcher buildPartial() {
                    JsonPathMatcher result = new JsonPathMatcher(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(JsonPathMatcher result) {
                    int from_bitField0_ = this.bitField0_;
                    if ((from_bitField0_ & 1) != 0) {
                        result.jsonPath_ = this.jsonPath_;
                    }
                    if ((from_bitField0_ & 2) != 0) {
                        result.jsonMatcher_ = this.jsonMatcher_;
                    }
                }

                @Override
                public Builder clone() {
                    return (Builder)super.clone();
                }

                @Override
                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                @Override
                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                @Override
                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                @Override
                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                @Override
                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                @Override
                public Builder mergeFrom(Message other) {
                    if (other instanceof JsonPathMatcher) {
                        return this.mergeFrom((JsonPathMatcher)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(JsonPathMatcher other) {
                    if (other == JsonPathMatcher.getDefaultInstance()) {
                        return this;
                    }
                    if (!other.getJsonPath().isEmpty()) {
                        this.jsonPath_ = other.jsonPath_;
                        this.bitField0_ |= 1;
                        this.onChanged();
                    }
                    if (other.jsonMatcher_ != 0) {
                        this.setJsonMatcherValue(other.getJsonMatcherValue());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                @Override
                public final boolean isInitialized() {
                    return true;
                }

                @Override
                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block10: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block10;
                                }
                                case 10: {
                                    this.jsonPath_ = input.readStringRequireUtf8();
                                    this.bitField0_ |= 1;
                                    continue block10;
                                }
                                case 16: {
                                    this.jsonMatcher_ = input.readEnum();
                                    this.bitField0_ |= 2;
                                    continue block10;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public String getJsonPath() {
                    Object ref = this.jsonPath_;
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s2 = bs.toStringUtf8();
                        this.jsonPath_ = s2;
                        return s2;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getJsonPathBytes() {
                    Object ref = this.jsonPath_;
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)ref);
                        this.jsonPath_ = b;
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setJsonPath(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.jsonPath_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder clearJsonPath() {
                    this.jsonPath_ = JsonPathMatcher.getDefaultInstance().getJsonPath();
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.onChanged();
                    return this;
                }

                public Builder setJsonPathBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    JsonPathMatcher.checkByteStringIsUtf8(value);
                    this.jsonPath_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                @Override
                public int getJsonMatcherValue() {
                    return this.jsonMatcher_;
                }

                public Builder setJsonMatcherValue(int value) {
                    this.jsonMatcher_ = value;
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                @Override
                public JsonPathMatcherOption getJsonMatcher() {
                    JsonPathMatcherOption result = JsonPathMatcherOption.forNumber(this.jsonMatcher_);
                    return result == null ? JsonPathMatcherOption.UNRECOGNIZED : result;
                }

                public Builder setJsonMatcher(JsonPathMatcherOption value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.bitField0_ |= 2;
                    this.jsonMatcher_ = value.getNumber();
                    this.onChanged();
                    return this;
                }

                public Builder clearJsonMatcher() {
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.jsonMatcher_ = 0;
                    this.onChanged();
                    return this;
                }

                @Override
                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                @Override
                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }

            public static enum JsonPathMatcherOption implements ProtocolMessageEnum
            {
                JSON_PATH_MATCHER_OPTION_UNSPECIFIED(0),
                EXACT_MATCH(1),
                REGEX_MATCH(2),
                UNRECOGNIZED(-1);

                public static final int JSON_PATH_MATCHER_OPTION_UNSPECIFIED_VALUE = 0;
                public static final int EXACT_MATCH_VALUE = 1;
                public static final int REGEX_MATCH_VALUE = 2;
                private static final Internal.EnumLiteMap<JsonPathMatcherOption> internalValueMap;
                private static final JsonPathMatcherOption[] VALUES;
                private final int value;

                @Override
                public final int getNumber() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                    }
                    return this.value;
                }

                @Deprecated
                public static JsonPathMatcherOption valueOf(int value) {
                    return JsonPathMatcherOption.forNumber(value);
                }

                public static JsonPathMatcherOption forNumber(int value) {
                    switch (value) {
                        case 0: {
                            return JSON_PATH_MATCHER_OPTION_UNSPECIFIED;
                        }
                        case 1: {
                            return EXACT_MATCH;
                        }
                        case 2: {
                            return REGEX_MATCH;
                        }
                    }
                    return null;
                }

                public static Internal.EnumLiteMap<JsonPathMatcherOption> internalGetValueMap() {
                    return internalValueMap;
                }

                @Override
                public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                    }
                    return JsonPathMatcherOption.getDescriptor().getValues().get(this.ordinal());
                }

                @Override
                public final Descriptors.EnumDescriptor getDescriptorForType() {
                    return JsonPathMatcherOption.getDescriptor();
                }

                public static final Descriptors.EnumDescriptor getDescriptor() {
                    return JsonPathMatcher.getDescriptor().getEnumTypes().get(0);
                }

                public static JsonPathMatcherOption valueOf(Descriptors.EnumValueDescriptor desc) {
                    if (desc.getType() != JsonPathMatcherOption.getDescriptor()) {
                        throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                    }
                    if (desc.getIndex() == -1) {
                        return UNRECOGNIZED;
                    }
                    return VALUES[desc.getIndex()];
                }

                private JsonPathMatcherOption(int value) {
                    this.value = value;
                }

                static {
                    internalValueMap = new Internal.EnumLiteMap<JsonPathMatcherOption>(){

                        @Override
                        public JsonPathMatcherOption findValueByNumber(int number) {
                            return JsonPathMatcherOption.forNumber(number);
                        }
                    };
                    VALUES = JsonPathMatcherOption.values();
                }
            }
        }

        public static interface JsonPathMatcherOrBuilder
        extends MessageOrBuilder {
            public String getJsonPath();

            public ByteString getJsonPathBytes();

            public int getJsonMatcherValue();

            public JsonPathMatcher.JsonPathMatcherOption getJsonMatcher();
        }

        public static enum ContentMatcherOption implements ProtocolMessageEnum
        {
            CONTENT_MATCHER_OPTION_UNSPECIFIED(0),
            CONTAINS_STRING(1),
            NOT_CONTAINS_STRING(2),
            MATCHES_REGEX(3),
            NOT_MATCHES_REGEX(4),
            MATCHES_JSON_PATH(5),
            NOT_MATCHES_JSON_PATH(6),
            UNRECOGNIZED(-1);

            public static final int CONTENT_MATCHER_OPTION_UNSPECIFIED_VALUE = 0;
            public static final int CONTAINS_STRING_VALUE = 1;
            public static final int NOT_CONTAINS_STRING_VALUE = 2;
            public static final int MATCHES_REGEX_VALUE = 3;
            public static final int NOT_MATCHES_REGEX_VALUE = 4;
            public static final int MATCHES_JSON_PATH_VALUE = 5;
            public static final int NOT_MATCHES_JSON_PATH_VALUE = 6;
            private static final Internal.EnumLiteMap<ContentMatcherOption> internalValueMap;
            private static final ContentMatcherOption[] VALUES;
            private final int value;

            @Override
            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static ContentMatcherOption valueOf(int value) {
                return ContentMatcherOption.forNumber(value);
            }

            public static ContentMatcherOption forNumber(int value) {
                switch (value) {
                    case 0: {
                        return CONTENT_MATCHER_OPTION_UNSPECIFIED;
                    }
                    case 1: {
                        return CONTAINS_STRING;
                    }
                    case 2: {
                        return NOT_CONTAINS_STRING;
                    }
                    case 3: {
                        return MATCHES_REGEX;
                    }
                    case 4: {
                        return NOT_MATCHES_REGEX;
                    }
                    case 5: {
                        return MATCHES_JSON_PATH;
                    }
                    case 6: {
                        return NOT_MATCHES_JSON_PATH;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<ContentMatcherOption> internalGetValueMap() {
                return internalValueMap;
            }

            @Override
            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return ContentMatcherOption.getDescriptor().getValues().get(this.ordinal());
            }

            @Override
            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return ContentMatcherOption.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return ContentMatcher.getDescriptor().getEnumTypes().get(0);
            }

            public static ContentMatcherOption valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != ContentMatcherOption.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private ContentMatcherOption(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<ContentMatcherOption>(){

                    @Override
                    public ContentMatcherOption findValueByNumber(int number) {
                        return ContentMatcherOption.forNumber(number);
                    }
                };
                VALUES = ContentMatcherOption.values();
            }
        }
    }

    public static interface ContentMatcherOrBuilder
    extends MessageOrBuilder {
        public String getContent();

        public ByteString getContentBytes();

        public int getMatcherValue();

        public ContentMatcher.ContentMatcherOption getMatcher();

        public boolean hasJsonPathMatcher();

        public ContentMatcher.JsonPathMatcher getJsonPathMatcher();

        public ContentMatcher.JsonPathMatcherOrBuilder getJsonPathMatcherOrBuilder();

        public ContentMatcher.AdditionalMatcherInfoCase getAdditionalMatcherInfoCase();
    }

    public static final class TcpCheck
    extends GeneratedMessageV3
    implements TcpCheckOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int PORT_FIELD_NUMBER = 1;
        private int port_ = 0;
        public static final int PING_CONFIG_FIELD_NUMBER = 2;
        private PingConfig pingConfig_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final TcpCheck DEFAULT_INSTANCE = new TcpCheck();
        private static final Parser<TcpCheck> PARSER = new AbstractParser<TcpCheck>(){

            @Override
            public TcpCheck parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = TcpCheck.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private TcpCheck(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private TcpCheck() {
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new TcpCheck();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_fieldAccessorTable.ensureFieldAccessorsInitialized(TcpCheck.class, Builder.class);
        }

        @Override
        public int getPort() {
            return this.port_;
        }

        @Override
        public boolean hasPingConfig() {
            return this.pingConfig_ != null;
        }

        @Override
        public PingConfig getPingConfig() {
            return this.pingConfig_ == null ? PingConfig.getDefaultInstance() : this.pingConfig_;
        }

        @Override
        public PingConfigOrBuilder getPingConfigOrBuilder() {
            return this.pingConfig_ == null ? PingConfig.getDefaultInstance() : this.pingConfig_;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.port_ != 0) {
                output.writeInt32(1, this.port_);
            }
            if (this.pingConfig_ != null) {
                output.writeMessage(2, this.getPingConfig());
            }
            this.getUnknownFields().writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.port_ != 0) {
                size += CodedOutputStream.computeInt32Size(1, this.port_);
            }
            if (this.pingConfig_ != null) {
                size += CodedOutputStream.computeMessageSize(2, this.getPingConfig());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TcpCheck)) {
                return super.equals(obj);
            }
            TcpCheck other = (TcpCheck)obj;
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.hasPingConfig() != other.hasPingConfig()) {
                return false;
            }
            if (this.hasPingConfig() && !this.getPingConfig().equals(other.getPingConfig())) {
                return false;
            }
            return this.getUnknownFields().equals(other.getUnknownFields());
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + TcpCheck.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getPort();
            if (this.hasPingConfig()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getPingConfig().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static TcpCheck parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static TcpCheck parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static TcpCheck parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static TcpCheck parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static TcpCheck parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static TcpCheck parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static TcpCheck parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static TcpCheck parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static TcpCheck parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static TcpCheck parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static TcpCheck parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static TcpCheck parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return TcpCheck.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(TcpCheck prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static TcpCheck getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<TcpCheck> parser() {
            return PARSER;
        }

        public Parser<TcpCheck> getParserForType() {
            return PARSER;
        }

        @Override
        public TcpCheck getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements TcpCheckOrBuilder {
            private int bitField0_;
            private int port_;
            private PingConfig pingConfig_;
            private SingleFieldBuilderV3<PingConfig, PingConfig.Builder, PingConfigOrBuilder> pingConfigBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_fieldAccessorTable.ensureFieldAccessorsInitialized(TcpCheck.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            @Override
            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.port_ = 0;
                this.pingConfig_ = null;
                if (this.pingConfigBuilder_ != null) {
                    this.pingConfigBuilder_.dispose();
                    this.pingConfigBuilder_ = null;
                }
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_descriptor;
            }

            @Override
            public TcpCheck getDefaultInstanceForType() {
                return TcpCheck.getDefaultInstance();
            }

            @Override
            public TcpCheck build() {
                TcpCheck result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public TcpCheck buildPartial() {
                TcpCheck result = new TcpCheck(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(TcpCheck result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.port_ = this.port_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.pingConfig_ = this.pingConfigBuilder_ == null ? this.pingConfig_ : this.pingConfigBuilder_.build();
                }
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof TcpCheck) {
                    return this.mergeFrom((TcpCheck)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(TcpCheck other) {
                if (other == TcpCheck.getDefaultInstance()) {
                    return this;
                }
                if (other.getPort() != 0) {
                    this.setPort(other.getPort());
                }
                if (other.hasPingConfig()) {
                    this.mergePingConfig(other.getPingConfig());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.port_ = input.readInt32();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 18: {
                                input.readMessage(this.getPingConfigFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public int getPort() {
                return this.port_;
            }

            public Builder setPort(int value) {
                this.port_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearPort() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.port_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasPingConfig() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public PingConfig getPingConfig() {
                if (this.pingConfigBuilder_ == null) {
                    return this.pingConfig_ == null ? PingConfig.getDefaultInstance() : this.pingConfig_;
                }
                return this.pingConfigBuilder_.getMessage();
            }

            public Builder setPingConfig(PingConfig value) {
                if (this.pingConfigBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.pingConfig_ = value;
                } else {
                    this.pingConfigBuilder_.setMessage(value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder setPingConfig(PingConfig.Builder builderForValue) {
                if (this.pingConfigBuilder_ == null) {
                    this.pingConfig_ = builderForValue.build();
                } else {
                    this.pingConfigBuilder_.setMessage(builderForValue.build());
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder mergePingConfig(PingConfig value) {
                if (this.pingConfigBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0 && this.pingConfig_ != null && this.pingConfig_ != PingConfig.getDefaultInstance()) {
                        this.getPingConfigBuilder().mergeFrom(value);
                    } else {
                        this.pingConfig_ = value;
                    }
                } else {
                    this.pingConfigBuilder_.mergeFrom(value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearPingConfig() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.pingConfig_ = null;
                if (this.pingConfigBuilder_ != null) {
                    this.pingConfigBuilder_.dispose();
                    this.pingConfigBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public PingConfig.Builder getPingConfigBuilder() {
                this.bitField0_ |= 2;
                this.onChanged();
                return this.getPingConfigFieldBuilder().getBuilder();
            }

            @Override
            public PingConfigOrBuilder getPingConfigOrBuilder() {
                if (this.pingConfigBuilder_ != null) {
                    return this.pingConfigBuilder_.getMessageOrBuilder();
                }
                return this.pingConfig_ == null ? PingConfig.getDefaultInstance() : this.pingConfig_;
            }

            private SingleFieldBuilderV3<PingConfig, PingConfig.Builder, PingConfigOrBuilder> getPingConfigFieldBuilder() {
                if (this.pingConfigBuilder_ == null) {
                    this.pingConfigBuilder_ = new SingleFieldBuilderV3(this.getPingConfig(), this.getParentForChildren(), this.isClean());
                    this.pingConfig_ = null;
                }
                return this.pingConfigBuilder_;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface TcpCheckOrBuilder
    extends MessageOrBuilder {
        public int getPort();

        public boolean hasPingConfig();

        public PingConfig getPingConfig();

        public PingConfigOrBuilder getPingConfigOrBuilder();
    }

    public static final class HttpCheck
    extends GeneratedMessageV3
    implements HttpCheckOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int REQUEST_METHOD_FIELD_NUMBER = 8;
        private int requestMethod_ = 0;
        public static final int USE_SSL_FIELD_NUMBER = 1;
        private boolean useSsl_ = false;
        public static final int PATH_FIELD_NUMBER = 2;
        private volatile Object path_ = "";
        public static final int PORT_FIELD_NUMBER = 3;
        private int port_ = 0;
        public static final int AUTH_INFO_FIELD_NUMBER = 4;
        private BasicAuthentication authInfo_;
        public static final int MASK_HEADERS_FIELD_NUMBER = 5;
        private boolean maskHeaders_ = false;
        public static final int HEADERS_FIELD_NUMBER = 6;
        private MapField<String, String> headers_;
        public static final int CONTENT_TYPE_FIELD_NUMBER = 9;
        private int contentType_ = 0;
        public static final int CUSTOM_CONTENT_TYPE_FIELD_NUMBER = 13;
        private volatile Object customContentType_ = "";
        public static final int VALIDATE_SSL_FIELD_NUMBER = 7;
        private boolean validateSsl_ = false;
        public static final int BODY_FIELD_NUMBER = 10;
        private ByteString body_ = ByteString.EMPTY;
        public static final int ACCEPTED_RESPONSE_STATUS_CODES_FIELD_NUMBER = 11;
        private List<ResponseStatusCode> acceptedResponseStatusCodes_;
        public static final int PING_CONFIG_FIELD_NUMBER = 12;
        private PingConfig pingConfig_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final HttpCheck DEFAULT_INSTANCE = new HttpCheck();
        private static final Parser<HttpCheck> PARSER = new AbstractParser<HttpCheck>(){

            @Override
            public HttpCheck parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = HttpCheck.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private HttpCheck(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private HttpCheck() {
            this.requestMethod_ = 0;
            this.path_ = "";
            this.contentType_ = 0;
            this.customContentType_ = "";
            this.body_ = ByteString.EMPTY;
            this.acceptedResponseStatusCodes_ = Collections.emptyList();
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new HttpCheck();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_descriptor;
        }

        @Override
        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 6: {
                    return this.internalGetHeaders();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_fieldAccessorTable.ensureFieldAccessorsInitialized(HttpCheck.class, Builder.class);
        }

        @Override
        public int getRequestMethodValue() {
            return this.requestMethod_;
        }

        @Override
        public RequestMethod getRequestMethod() {
            RequestMethod result = RequestMethod.forNumber(this.requestMethod_);
            return result == null ? RequestMethod.UNRECOGNIZED : result;
        }

        @Override
        public boolean getUseSsl() {
            return this.useSsl_;
        }

        @Override
        public String getPath() {
            Object ref = this.path_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s2 = bs.toStringUtf8();
            this.path_ = s2;
            return s2;
        }

        @Override
        public ByteString getPathBytes() {
            Object ref = this.path_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.path_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public int getPort() {
            return this.port_;
        }

        @Override
        public boolean hasAuthInfo() {
            return this.authInfo_ != null;
        }

        @Override
        public BasicAuthentication getAuthInfo() {
            return this.authInfo_ == null ? BasicAuthentication.getDefaultInstance() : this.authInfo_;
        }

        @Override
        public BasicAuthenticationOrBuilder getAuthInfoOrBuilder() {
            return this.authInfo_ == null ? BasicAuthentication.getDefaultInstance() : this.authInfo_;
        }

        @Override
        public boolean getMaskHeaders() {
            return this.maskHeaders_;
        }

        private MapField<String, String> internalGetHeaders() {
            if (this.headers_ == null) {
                return MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
            }
            return this.headers_;
        }

        @Override
        public int getHeadersCount() {
            return this.internalGetHeaders().getMap().size();
        }

        @Override
        public boolean containsHeaders(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetHeaders().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getHeaders() {
            return this.getHeadersMap();
        }

        @Override
        public Map<String, String> getHeadersMap() {
            return this.internalGetHeaders().getMap();
        }

        @Override
        public String getHeadersOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map<String, String> map = this.internalGetHeaders().getMap();
            return map.containsKey(key) ? map.get(key) : defaultValue;
        }

        @Override
        public String getHeadersOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map<String, String> map = this.internalGetHeaders().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return map.get(key);
        }

        @Override
        public int getContentTypeValue() {
            return this.contentType_;
        }

        @Override
        public ContentType getContentType() {
            ContentType result = ContentType.forNumber(this.contentType_);
            return result == null ? ContentType.UNRECOGNIZED : result;
        }

        @Override
        public String getCustomContentType() {
            Object ref = this.customContentType_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s2 = bs.toStringUtf8();
            this.customContentType_ = s2;
            return s2;
        }

        @Override
        public ByteString getCustomContentTypeBytes() {
            Object ref = this.customContentType_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.customContentType_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean getValidateSsl() {
            return this.validateSsl_;
        }

        @Override
        public ByteString getBody() {
            return this.body_;
        }

        @Override
        public List<ResponseStatusCode> getAcceptedResponseStatusCodesList() {
            return this.acceptedResponseStatusCodes_;
        }

        @Override
        public List<? extends ResponseStatusCodeOrBuilder> getAcceptedResponseStatusCodesOrBuilderList() {
            return this.acceptedResponseStatusCodes_;
        }

        @Override
        public int getAcceptedResponseStatusCodesCount() {
            return this.acceptedResponseStatusCodes_.size();
        }

        @Override
        public ResponseStatusCode getAcceptedResponseStatusCodes(int index) {
            return this.acceptedResponseStatusCodes_.get(index);
        }

        @Override
        public ResponseStatusCodeOrBuilder getAcceptedResponseStatusCodesOrBuilder(int index) {
            return this.acceptedResponseStatusCodes_.get(index);
        }

        @Override
        public boolean hasPingConfig() {
            return this.pingConfig_ != null;
        }

        @Override
        public PingConfig getPingConfig() {
            return this.pingConfig_ == null ? PingConfig.getDefaultInstance() : this.pingConfig_;
        }

        @Override
        public PingConfigOrBuilder getPingConfigOrBuilder() {
            return this.pingConfig_ == null ? PingConfig.getDefaultInstance() : this.pingConfig_;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.useSsl_) {
                output.writeBool(1, this.useSsl_);
            }
            if (!GeneratedMessageV3.isStringEmpty(this.path_)) {
                GeneratedMessageV3.writeString(output, 2, this.path_);
            }
            if (this.port_ != 0) {
                output.writeInt32(3, this.port_);
            }
            if (this.authInfo_ != null) {
                output.writeMessage(4, this.getAuthInfo());
            }
            if (this.maskHeaders_) {
                output.writeBool(5, this.maskHeaders_);
            }
            GeneratedMessageV3.serializeStringMapTo(output, this.internalGetHeaders(), HeadersDefaultEntryHolder.defaultEntry, 6);
            if (this.validateSsl_) {
                output.writeBool(7, this.validateSsl_);
            }
            if (this.requestMethod_ != RequestMethod.METHOD_UNSPECIFIED.getNumber()) {
                output.writeEnum(8, this.requestMethod_);
            }
            if (this.contentType_ != ContentType.TYPE_UNSPECIFIED.getNumber()) {
                output.writeEnum(9, this.contentType_);
            }
            if (!this.body_.isEmpty()) {
                output.writeBytes(10, this.body_);
            }
            for (int i = 0; i < this.acceptedResponseStatusCodes_.size(); ++i) {
                output.writeMessage(11, this.acceptedResponseStatusCodes_.get(i));
            }
            if (this.pingConfig_ != null) {
                output.writeMessage(12, this.getPingConfig());
            }
            if (!GeneratedMessageV3.isStringEmpty(this.customContentType_)) {
                GeneratedMessageV3.writeString(output, 13, this.customContentType_);
            }
            this.getUnknownFields().writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.useSsl_) {
                size += CodedOutputStream.computeBoolSize(1, this.useSsl_);
            }
            if (!GeneratedMessageV3.isStringEmpty(this.path_)) {
                size += GeneratedMessageV3.computeStringSize(2, this.path_);
            }
            if (this.port_ != 0) {
                size += CodedOutputStream.computeInt32Size(3, this.port_);
            }
            if (this.authInfo_ != null) {
                size += CodedOutputStream.computeMessageSize(4, this.getAuthInfo());
            }
            if (this.maskHeaders_) {
                size += CodedOutputStream.computeBoolSize(5, this.maskHeaders_);
            }
            for (Map.Entry<String, String> entry : this.internalGetHeaders().getMap().entrySet()) {
                Message headers__ = ((MapEntry.Builder)HeadersDefaultEntryHolder.defaultEntry.newBuilderForType()).setKey(entry.getKey()).setValue(entry.getValue()).build();
                size += CodedOutputStream.computeMessageSize(6, headers__);
            }
            if (this.validateSsl_) {
                size += CodedOutputStream.computeBoolSize(7, this.validateSsl_);
            }
            if (this.requestMethod_ != RequestMethod.METHOD_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize(8, this.requestMethod_);
            }
            if (this.contentType_ != ContentType.TYPE_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize(9, this.contentType_);
            }
            if (!this.body_.isEmpty()) {
                size += CodedOutputStream.computeBytesSize(10, this.body_);
            }
            for (int i = 0; i < this.acceptedResponseStatusCodes_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize(11, this.acceptedResponseStatusCodes_.get(i));
            }
            if (this.pingConfig_ != null) {
                size += CodedOutputStream.computeMessageSize(12, this.getPingConfig());
            }
            if (!GeneratedMessageV3.isStringEmpty(this.customContentType_)) {
                size += GeneratedMessageV3.computeStringSize(13, this.customContentType_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof HttpCheck)) {
                return super.equals(obj);
            }
            HttpCheck other = (HttpCheck)obj;
            if (this.requestMethod_ != other.requestMethod_) {
                return false;
            }
            if (this.getUseSsl() != other.getUseSsl()) {
                return false;
            }
            if (!this.getPath().equals(other.getPath())) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.hasAuthInfo() != other.hasAuthInfo()) {
                return false;
            }
            if (this.hasAuthInfo() && !this.getAuthInfo().equals(other.getAuthInfo())) {
                return false;
            }
            if (this.getMaskHeaders() != other.getMaskHeaders()) {
                return false;
            }
            if (!this.internalGetHeaders().equals(other.internalGetHeaders())) {
                return false;
            }
            if (this.contentType_ != other.contentType_) {
                return false;
            }
            if (!this.getCustomContentType().equals(other.getCustomContentType())) {
                return false;
            }
            if (this.getValidateSsl() != other.getValidateSsl()) {
                return false;
            }
            if (!this.getBody().equals(other.getBody())) {
                return false;
            }
            if (!this.getAcceptedResponseStatusCodesList().equals(other.getAcceptedResponseStatusCodesList())) {
                return false;
            }
            if (this.hasPingConfig() != other.hasPingConfig()) {
                return false;
            }
            if (this.hasPingConfig() && !this.getPingConfig().equals(other.getPingConfig())) {
                return false;
            }
            return this.getUnknownFields().equals(other.getUnknownFields());
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + HttpCheck.getDescriptor().hashCode();
            hash = 37 * hash + 8;
            hash = 53 * hash + this.requestMethod_;
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashBoolean(this.getUseSsl());
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getPath().hashCode();
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getPort();
            if (this.hasAuthInfo()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getAuthInfo().hashCode();
            }
            hash = 37 * hash + 5;
            hash = 53 * hash + Internal.hashBoolean(this.getMaskHeaders());
            if (!this.internalGetHeaders().getMap().isEmpty()) {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.internalGetHeaders().hashCode();
            }
            hash = 37 * hash + 9;
            hash = 53 * hash + this.contentType_;
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getCustomContentType().hashCode();
            hash = 37 * hash + 7;
            hash = 53 * hash + Internal.hashBoolean(this.getValidateSsl());
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getBody().hashCode();
            if (this.getAcceptedResponseStatusCodesCount() > 0) {
                hash = 37 * hash + 11;
                hash = 53 * hash + this.getAcceptedResponseStatusCodesList().hashCode();
            }
            if (this.hasPingConfig()) {
                hash = 37 * hash + 12;
                hash = 53 * hash + this.getPingConfig().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static HttpCheck parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static HttpCheck parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static HttpCheck parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static HttpCheck parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static HttpCheck parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static HttpCheck parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static HttpCheck parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static HttpCheck parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static HttpCheck parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static HttpCheck parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static HttpCheck parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static HttpCheck parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return HttpCheck.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(HttpCheck prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static HttpCheck getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<HttpCheck> parser() {
            return PARSER;
        }

        public Parser<HttpCheck> getParserForType() {
            return PARSER;
        }

        @Override
        public HttpCheck getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements HttpCheckOrBuilder {
            private int bitField0_;
            private int requestMethod_ = 0;
            private boolean useSsl_;
            private Object path_ = "";
            private int port_;
            private BasicAuthentication authInfo_;
            private SingleFieldBuilderV3<BasicAuthentication, BasicAuthentication.Builder, BasicAuthenticationOrBuilder> authInfoBuilder_;
            private boolean maskHeaders_;
            private MapField<String, String> headers_;
            private int contentType_ = 0;
            private Object customContentType_ = "";
            private boolean validateSsl_;
            private ByteString body_ = ByteString.EMPTY;
            private List<ResponseStatusCode> acceptedResponseStatusCodes_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<ResponseStatusCode, ResponseStatusCode.Builder, ResponseStatusCodeOrBuilder> acceptedResponseStatusCodesBuilder_;
            private PingConfig pingConfig_;
            private SingleFieldBuilderV3<PingConfig, PingConfig.Builder, PingConfigOrBuilder> pingConfigBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_descriptor;
            }

            @Override
            protected MapField internalGetMapField(int number) {
                switch (number) {
                    case 6: {
                        return this.internalGetHeaders();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            @Override
            protected MapField internalGetMutableMapField(int number) {
                switch (number) {
                    case 6: {
                        return this.internalGetMutableHeaders();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_fieldAccessorTable.ensureFieldAccessorsInitialized(HttpCheck.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            @Override
            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.requestMethod_ = 0;
                this.useSsl_ = false;
                this.path_ = "";
                this.port_ = 0;
                this.authInfo_ = null;
                if (this.authInfoBuilder_ != null) {
                    this.authInfoBuilder_.dispose();
                    this.authInfoBuilder_ = null;
                }
                this.maskHeaders_ = false;
                this.internalGetMutableHeaders().clear();
                this.contentType_ = 0;
                this.customContentType_ = "";
                this.validateSsl_ = false;
                this.body_ = ByteString.EMPTY;
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    this.acceptedResponseStatusCodes_ = Collections.emptyList();
                } else {
                    this.acceptedResponseStatusCodes_ = null;
                    this.acceptedResponseStatusCodesBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFF7FF;
                this.pingConfig_ = null;
                if (this.pingConfigBuilder_ != null) {
                    this.pingConfigBuilder_.dispose();
                    this.pingConfigBuilder_ = null;
                }
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_descriptor;
            }

            @Override
            public HttpCheck getDefaultInstanceForType() {
                return HttpCheck.getDefaultInstance();
            }

            @Override
            public HttpCheck build() {
                HttpCheck result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public HttpCheck buildPartial() {
                HttpCheck result = new HttpCheck(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(HttpCheck result) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    if ((this.bitField0_ & 0x800) != 0) {
                        this.acceptedResponseStatusCodes_ = Collections.unmodifiableList(this.acceptedResponseStatusCodes_);
                        this.bitField0_ &= 0xFFFFF7FF;
                    }
                    result.acceptedResponseStatusCodes_ = this.acceptedResponseStatusCodes_;
                } else {
                    result.acceptedResponseStatusCodes_ = this.acceptedResponseStatusCodesBuilder_.build();
                }
            }

            private void buildPartial0(HttpCheck result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.requestMethod_ = this.requestMethod_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.useSsl_ = this.useSsl_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.path_ = this.path_;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.port_ = this.port_;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.authInfo_ = this.authInfoBuilder_ == null ? this.authInfo_ : this.authInfoBuilder_.build();
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    result.maskHeaders_ = this.maskHeaders_;
                }
                if ((from_bitField0_ & 0x40) != 0) {
                    result.headers_ = this.internalGetHeaders();
                    result.headers_.makeImmutable();
                }
                if ((from_bitField0_ & 0x80) != 0) {
                    result.contentType_ = this.contentType_;
                }
                if ((from_bitField0_ & 0x100) != 0) {
                    result.customContentType_ = this.customContentType_;
                }
                if ((from_bitField0_ & 0x200) != 0) {
                    result.validateSsl_ = this.validateSsl_;
                }
                if ((from_bitField0_ & 0x400) != 0) {
                    result.body_ = this.body_;
                }
                if ((from_bitField0_ & 0x1000) != 0) {
                    result.pingConfig_ = this.pingConfigBuilder_ == null ? this.pingConfig_ : this.pingConfigBuilder_.build();
                }
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof HttpCheck) {
                    return this.mergeFrom((HttpCheck)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(HttpCheck other) {
                if (other == HttpCheck.getDefaultInstance()) {
                    return this;
                }
                if (other.requestMethod_ != 0) {
                    this.setRequestMethodValue(other.getRequestMethodValue());
                }
                if (other.getUseSsl()) {
                    this.setUseSsl(other.getUseSsl());
                }
                if (!other.getPath().isEmpty()) {
                    this.path_ = other.path_;
                    this.bitField0_ |= 4;
                    this.onChanged();
                }
                if (other.getPort() != 0) {
                    this.setPort(other.getPort());
                }
                if (other.hasAuthInfo()) {
                    this.mergeAuthInfo(other.getAuthInfo());
                }
                if (other.getMaskHeaders()) {
                    this.setMaskHeaders(other.getMaskHeaders());
                }
                this.internalGetMutableHeaders().mergeFrom(other.internalGetHeaders());
                this.bitField0_ |= 0x40;
                if (other.contentType_ != 0) {
                    this.setContentTypeValue(other.getContentTypeValue());
                }
                if (!other.getCustomContentType().isEmpty()) {
                    this.customContentType_ = other.customContentType_;
                    this.bitField0_ |= 0x100;
                    this.onChanged();
                }
                if (other.getValidateSsl()) {
                    this.setValidateSsl(other.getValidateSsl());
                }
                if (other.getBody() != ByteString.EMPTY) {
                    this.setBody(other.getBody());
                }
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    if (!other.acceptedResponseStatusCodes_.isEmpty()) {
                        if (this.acceptedResponseStatusCodes_.isEmpty()) {
                            this.acceptedResponseStatusCodes_ = other.acceptedResponseStatusCodes_;
                            this.bitField0_ &= 0xFFFFF7FF;
                        } else {
                            this.ensureAcceptedResponseStatusCodesIsMutable();
                            this.acceptedResponseStatusCodes_.addAll(other.acceptedResponseStatusCodes_);
                        }
                        this.onChanged();
                    }
                } else if (!other.acceptedResponseStatusCodes_.isEmpty()) {
                    if (this.acceptedResponseStatusCodesBuilder_.isEmpty()) {
                        this.acceptedResponseStatusCodesBuilder_.dispose();
                        this.acceptedResponseStatusCodesBuilder_ = null;
                        this.acceptedResponseStatusCodes_ = other.acceptedResponseStatusCodes_;
                        this.bitField0_ &= 0xFFFFF7FF;
                        this.acceptedResponseStatusCodesBuilder_ = alwaysUseFieldBuilders ? this.getAcceptedResponseStatusCodesFieldBuilder() : null;
                    } else {
                        this.acceptedResponseStatusCodesBuilder_.addAllMessages(other.acceptedResponseStatusCodes_);
                    }
                }
                if (other.hasPingConfig()) {
                    this.mergePingConfig(other.getPingConfig());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block21: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block21;
                            }
                            case 8: {
                                this.useSsl_ = input.readBool();
                                this.bitField0_ |= 2;
                                continue block21;
                            }
                            case 18: {
                                this.path_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 4;
                                continue block21;
                            }
                            case 24: {
                                this.port_ = input.readInt32();
                                this.bitField0_ |= 8;
                                continue block21;
                            }
                            case 34: {
                                input.readMessage(this.getAuthInfoFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 0x10;
                                continue block21;
                            }
                            case 40: {
                                this.maskHeaders_ = input.readBool();
                                this.bitField0_ |= 0x20;
                                continue block21;
                            }
                            case 50: {
                                MapEntry<String, String> headers__ = input.readMessage(HeadersDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                                this.internalGetMutableHeaders().getMutableMap().put(headers__.getKey(), headers__.getValue());
                                this.bitField0_ |= 0x40;
                                continue block21;
                            }
                            case 56: {
                                this.validateSsl_ = input.readBool();
                                this.bitField0_ |= 0x200;
                                continue block21;
                            }
                            case 64: {
                                this.requestMethod_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block21;
                            }
                            case 72: {
                                this.contentType_ = input.readEnum();
                                this.bitField0_ |= 0x80;
                                continue block21;
                            }
                            case 82: {
                                this.body_ = input.readBytes();
                                this.bitField0_ |= 0x400;
                                continue block21;
                            }
                            case 90: {
                                ResponseStatusCode m4 = input.readMessage(ResponseStatusCode.parser(), extensionRegistry);
                                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                                    this.ensureAcceptedResponseStatusCodesIsMutable();
                                    this.acceptedResponseStatusCodes_.add(m4);
                                    continue block21;
                                }
                                this.acceptedResponseStatusCodesBuilder_.addMessage(m4);
                                continue block21;
                            }
                            case 98: {
                                input.readMessage(this.getPingConfigFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 0x1000;
                                continue block21;
                            }
                            case 106: {
                                this.customContentType_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x100;
                                continue block21;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public int getRequestMethodValue() {
                return this.requestMethod_;
            }

            public Builder setRequestMethodValue(int value) {
                this.requestMethod_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public RequestMethod getRequestMethod() {
                RequestMethod result = RequestMethod.forNumber(this.requestMethod_);
                return result == null ? RequestMethod.UNRECOGNIZED : result;
            }

            public Builder setRequestMethod(RequestMethod value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.requestMethod_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearRequestMethod() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.requestMethod_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean getUseSsl() {
                return this.useSsl_;
            }

            public Builder setUseSsl(boolean value) {
                this.useSsl_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearUseSsl() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.useSsl_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public String getPath() {
                Object ref = this.path_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s2 = bs.toStringUtf8();
                    this.path_ = s2;
                    return s2;
                }
                return (String)ref;
            }

            @Override
            public ByteString getPathBytes() {
                Object ref = this.path_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.path_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setPath(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.path_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearPath() {
                this.path_ = HttpCheck.getDefaultInstance().getPath();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            public Builder setPathBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                HttpCheck.checkByteStringIsUtf8(value);
                this.path_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            @Override
            public int getPort() {
                return this.port_;
            }

            public Builder setPort(int value) {
                this.port_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearPort() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.port_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasAuthInfo() {
                return (this.bitField0_ & 0x10) != 0;
            }

            @Override
            public BasicAuthentication getAuthInfo() {
                if (this.authInfoBuilder_ == null) {
                    return this.authInfo_ == null ? BasicAuthentication.getDefaultInstance() : this.authInfo_;
                }
                return this.authInfoBuilder_.getMessage();
            }

            public Builder setAuthInfo(BasicAuthentication value) {
                if (this.authInfoBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.authInfo_ = value;
                } else {
                    this.authInfoBuilder_.setMessage(value);
                }
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder setAuthInfo(BasicAuthentication.Builder builderForValue) {
                if (this.authInfoBuilder_ == null) {
                    this.authInfo_ = builderForValue.build();
                } else {
                    this.authInfoBuilder_.setMessage(builderForValue.build());
                }
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder mergeAuthInfo(BasicAuthentication value) {
                if (this.authInfoBuilder_ == null) {
                    if ((this.bitField0_ & 0x10) != 0 && this.authInfo_ != null && this.authInfo_ != BasicAuthentication.getDefaultInstance()) {
                        this.getAuthInfoBuilder().mergeFrom(value);
                    } else {
                        this.authInfo_ = value;
                    }
                } else {
                    this.authInfoBuilder_.mergeFrom(value);
                }
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearAuthInfo() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.authInfo_ = null;
                if (this.authInfoBuilder_ != null) {
                    this.authInfoBuilder_.dispose();
                    this.authInfoBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public BasicAuthentication.Builder getAuthInfoBuilder() {
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this.getAuthInfoFieldBuilder().getBuilder();
            }

            @Override
            public BasicAuthenticationOrBuilder getAuthInfoOrBuilder() {
                if (this.authInfoBuilder_ != null) {
                    return this.authInfoBuilder_.getMessageOrBuilder();
                }
                return this.authInfo_ == null ? BasicAuthentication.getDefaultInstance() : this.authInfo_;
            }

            private SingleFieldBuilderV3<BasicAuthentication, BasicAuthentication.Builder, BasicAuthenticationOrBuilder> getAuthInfoFieldBuilder() {
                if (this.authInfoBuilder_ == null) {
                    this.authInfoBuilder_ = new SingleFieldBuilderV3(this.getAuthInfo(), this.getParentForChildren(), this.isClean());
                    this.authInfo_ = null;
                }
                return this.authInfoBuilder_;
            }

            @Override
            public boolean getMaskHeaders() {
                return this.maskHeaders_;
            }

            public Builder setMaskHeaders(boolean value) {
                this.maskHeaders_ = value;
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder clearMaskHeaders() {
                this.bitField0_ &= 0xFFFFFFDF;
                this.maskHeaders_ = false;
                this.onChanged();
                return this;
            }

            private MapField<String, String> internalGetHeaders() {
                if (this.headers_ == null) {
                    return MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
                }
                return this.headers_;
            }

            private MapField<String, String> internalGetMutableHeaders() {
                if (this.headers_ == null) {
                    this.headers_ = MapField.newMapField(HeadersDefaultEntryHolder.defaultEntry);
                }
                if (!this.headers_.isMutable()) {
                    this.headers_ = this.headers_.copy();
                }
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this.headers_;
            }

            @Override
            public int getHeadersCount() {
                return this.internalGetHeaders().getMap().size();
            }

            @Override
            public boolean containsHeaders(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                return this.internalGetHeaders().getMap().containsKey(key);
            }

            @Override
            @Deprecated
            public Map<String, String> getHeaders() {
                return this.getHeadersMap();
            }

            @Override
            public Map<String, String> getHeadersMap() {
                return this.internalGetHeaders().getMap();
            }

            @Override
            public String getHeadersOrDefault(String key, String defaultValue) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map<String, String> map = this.internalGetHeaders().getMap();
                return map.containsKey(key) ? map.get(key) : defaultValue;
            }

            @Override
            public String getHeadersOrThrow(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map<String, String> map = this.internalGetHeaders().getMap();
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException();
                }
                return map.get(key);
            }

            public Builder clearHeaders() {
                this.bitField0_ &= 0xFFFFFFBF;
                this.internalGetMutableHeaders().getMutableMap().clear();
                return this;
            }

            public Builder removeHeaders(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                this.internalGetMutableHeaders().getMutableMap().remove(key);
                return this;
            }

            @Deprecated
            public Map<String, String> getMutableHeaders() {
                this.bitField0_ |= 0x40;
                return this.internalGetMutableHeaders().getMutableMap();
            }

            public Builder putHeaders(String key, String value) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                if (value == null) {
                    throw new NullPointerException("map value");
                }
                this.internalGetMutableHeaders().getMutableMap().put(key, value);
                this.bitField0_ |= 0x40;
                return this;
            }

            public Builder putAllHeaders(Map<String, String> values) {
                this.internalGetMutableHeaders().getMutableMap().putAll(values);
                this.bitField0_ |= 0x40;
                return this;
            }

            @Override
            public int getContentTypeValue() {
                return this.contentType_;
            }

            public Builder setContentTypeValue(int value) {
                this.contentType_ = value;
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            @Override
            public ContentType getContentType() {
                ContentType result = ContentType.forNumber(this.contentType_);
                return result == null ? ContentType.UNRECOGNIZED : result;
            }

            public Builder setContentType(ContentType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 0x80;
                this.contentType_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearContentType() {
                this.bitField0_ &= 0xFFFFFF7F;
                this.contentType_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public String getCustomContentType() {
                Object ref = this.customContentType_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s2 = bs.toStringUtf8();
                    this.customContentType_ = s2;
                    return s2;
                }
                return (String)ref;
            }

            @Override
            public ByteString getCustomContentTypeBytes() {
                Object ref = this.customContentType_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.customContentType_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setCustomContentType(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.customContentType_ = value;
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            public Builder clearCustomContentType() {
                this.customContentType_ = HttpCheck.getDefaultInstance().getCustomContentType();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
                return this;
            }

            public Builder setCustomContentTypeBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                HttpCheck.checkByteStringIsUtf8(value);
                this.customContentType_ = value;
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            @Override
            public boolean getValidateSsl() {
                return this.validateSsl_;
            }

            public Builder setValidateSsl(boolean value) {
                this.validateSsl_ = value;
                this.bitField0_ |= 0x200;
                this.onChanged();
                return this;
            }

            public Builder clearValidateSsl() {
                this.bitField0_ &= 0xFFFFFDFF;
                this.validateSsl_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public ByteString getBody() {
                return this.body_;
            }

            public Builder setBody(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.body_ = value;
                this.bitField0_ |= 0x400;
                this.onChanged();
                return this;
            }

            public Builder clearBody() {
                this.bitField0_ &= 0xFFFFFBFF;
                this.body_ = HttpCheck.getDefaultInstance().getBody();
                this.onChanged();
                return this;
            }

            private void ensureAcceptedResponseStatusCodesIsMutable() {
                if ((this.bitField0_ & 0x800) == 0) {
                    this.acceptedResponseStatusCodes_ = new ArrayList<ResponseStatusCode>(this.acceptedResponseStatusCodes_);
                    this.bitField0_ |= 0x800;
                }
            }

            @Override
            public List<ResponseStatusCode> getAcceptedResponseStatusCodesList() {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    return Collections.unmodifiableList(this.acceptedResponseStatusCodes_);
                }
                return this.acceptedResponseStatusCodesBuilder_.getMessageList();
            }

            @Override
            public int getAcceptedResponseStatusCodesCount() {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    return this.acceptedResponseStatusCodes_.size();
                }
                return this.acceptedResponseStatusCodesBuilder_.getCount();
            }

            @Override
            public ResponseStatusCode getAcceptedResponseStatusCodes(int index) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    return this.acceptedResponseStatusCodes_.get(index);
                }
                return this.acceptedResponseStatusCodesBuilder_.getMessage(index);
            }

            public Builder setAcceptedResponseStatusCodes(int index, ResponseStatusCode value) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAcceptedResponseStatusCodesIsMutable();
                    this.acceptedResponseStatusCodes_.set(index, value);
                    this.onChanged();
                } else {
                    this.acceptedResponseStatusCodesBuilder_.setMessage(index, value);
                }
                return this;
            }

            public Builder setAcceptedResponseStatusCodes(int index, ResponseStatusCode.Builder builderForValue) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    this.ensureAcceptedResponseStatusCodesIsMutable();
                    this.acceptedResponseStatusCodes_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.acceptedResponseStatusCodesBuilder_.setMessage(index, builderForValue.build());
                }
                return this;
            }

            public Builder addAcceptedResponseStatusCodes(ResponseStatusCode value) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAcceptedResponseStatusCodesIsMutable();
                    this.acceptedResponseStatusCodes_.add(value);
                    this.onChanged();
                } else {
                    this.acceptedResponseStatusCodesBuilder_.addMessage(value);
                }
                return this;
            }

            public Builder addAcceptedResponseStatusCodes(int index, ResponseStatusCode value) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAcceptedResponseStatusCodesIsMutable();
                    this.acceptedResponseStatusCodes_.add(index, value);
                    this.onChanged();
                } else {
                    this.acceptedResponseStatusCodesBuilder_.addMessage(index, value);
                }
                return this;
            }

            public Builder addAcceptedResponseStatusCodes(ResponseStatusCode.Builder builderForValue) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    this.ensureAcceptedResponseStatusCodesIsMutable();
                    this.acceptedResponseStatusCodes_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.acceptedResponseStatusCodesBuilder_.addMessage(builderForValue.build());
                }
                return this;
            }

            public Builder addAcceptedResponseStatusCodes(int index, ResponseStatusCode.Builder builderForValue) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    this.ensureAcceptedResponseStatusCodesIsMutable();
                    this.acceptedResponseStatusCodes_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.acceptedResponseStatusCodesBuilder_.addMessage(index, builderForValue.build());
                }
                return this;
            }

            public Builder addAllAcceptedResponseStatusCodes(Iterable<? extends ResponseStatusCode> values) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    this.ensureAcceptedResponseStatusCodesIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.acceptedResponseStatusCodes_);
                    this.onChanged();
                } else {
                    this.acceptedResponseStatusCodesBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearAcceptedResponseStatusCodes() {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    this.acceptedResponseStatusCodes_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFF7FF;
                    this.onChanged();
                } else {
                    this.acceptedResponseStatusCodesBuilder_.clear();
                }
                return this;
            }

            public Builder removeAcceptedResponseStatusCodes(int index) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    this.ensureAcceptedResponseStatusCodesIsMutable();
                    this.acceptedResponseStatusCodes_.remove(index);
                    this.onChanged();
                } else {
                    this.acceptedResponseStatusCodesBuilder_.remove(index);
                }
                return this;
            }

            public ResponseStatusCode.Builder getAcceptedResponseStatusCodesBuilder(int index) {
                return this.getAcceptedResponseStatusCodesFieldBuilder().getBuilder(index);
            }

            @Override
            public ResponseStatusCodeOrBuilder getAcceptedResponseStatusCodesOrBuilder(int index) {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    return this.acceptedResponseStatusCodes_.get(index);
                }
                return this.acceptedResponseStatusCodesBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends ResponseStatusCodeOrBuilder> getAcceptedResponseStatusCodesOrBuilderList() {
                if (this.acceptedResponseStatusCodesBuilder_ != null) {
                    return this.acceptedResponseStatusCodesBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.acceptedResponseStatusCodes_);
            }

            public ResponseStatusCode.Builder addAcceptedResponseStatusCodesBuilder() {
                return this.getAcceptedResponseStatusCodesFieldBuilder().addBuilder(ResponseStatusCode.getDefaultInstance());
            }

            public ResponseStatusCode.Builder addAcceptedResponseStatusCodesBuilder(int index) {
                return this.getAcceptedResponseStatusCodesFieldBuilder().addBuilder(index, ResponseStatusCode.getDefaultInstance());
            }

            public List<ResponseStatusCode.Builder> getAcceptedResponseStatusCodesBuilderList() {
                return this.getAcceptedResponseStatusCodesFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<ResponseStatusCode, ResponseStatusCode.Builder, ResponseStatusCodeOrBuilder> getAcceptedResponseStatusCodesFieldBuilder() {
                if (this.acceptedResponseStatusCodesBuilder_ == null) {
                    this.acceptedResponseStatusCodesBuilder_ = new RepeatedFieldBuilderV3(this.acceptedResponseStatusCodes_, (this.bitField0_ & 0x800) != 0, this.getParentForChildren(), this.isClean());
                    this.acceptedResponseStatusCodes_ = null;
                }
                return this.acceptedResponseStatusCodesBuilder_;
            }

            @Override
            public boolean hasPingConfig() {
                return (this.bitField0_ & 0x1000) != 0;
            }

            @Override
            public PingConfig getPingConfig() {
                if (this.pingConfigBuilder_ == null) {
                    return this.pingConfig_ == null ? PingConfig.getDefaultInstance() : this.pingConfig_;
                }
                return this.pingConfigBuilder_.getMessage();
            }

            public Builder setPingConfig(PingConfig value) {
                if (this.pingConfigBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.pingConfig_ = value;
                } else {
                    this.pingConfigBuilder_.setMessage(value);
                }
                this.bitField0_ |= 0x1000;
                this.onChanged();
                return this;
            }

            public Builder setPingConfig(PingConfig.Builder builderForValue) {
                if (this.pingConfigBuilder_ == null) {
                    this.pingConfig_ = builderForValue.build();
                } else {
                    this.pingConfigBuilder_.setMessage(builderForValue.build());
                }
                this.bitField0_ |= 0x1000;
                this.onChanged();
                return this;
            }

            public Builder mergePingConfig(PingConfig value) {
                if (this.pingConfigBuilder_ == null) {
                    if ((this.bitField0_ & 0x1000) != 0 && this.pingConfig_ != null && this.pingConfig_ != PingConfig.getDefaultInstance()) {
                        this.getPingConfigBuilder().mergeFrom(value);
                    } else {
                        this.pingConfig_ = value;
                    }
                } else {
                    this.pingConfigBuilder_.mergeFrom(value);
                }
                this.bitField0_ |= 0x1000;
                this.onChanged();
                return this;
            }

            public Builder clearPingConfig() {
                this.bitField0_ &= 0xFFFFEFFF;
                this.pingConfig_ = null;
                if (this.pingConfigBuilder_ != null) {
                    this.pingConfigBuilder_.dispose();
                    this.pingConfigBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public PingConfig.Builder getPingConfigBuilder() {
                this.bitField0_ |= 0x1000;
                this.onChanged();
                return this.getPingConfigFieldBuilder().getBuilder();
            }

            @Override
            public PingConfigOrBuilder getPingConfigOrBuilder() {
                if (this.pingConfigBuilder_ != null) {
                    return this.pingConfigBuilder_.getMessageOrBuilder();
                }
                return this.pingConfig_ == null ? PingConfig.getDefaultInstance() : this.pingConfig_;
            }

            private SingleFieldBuilderV3<PingConfig, PingConfig.Builder, PingConfigOrBuilder> getPingConfigFieldBuilder() {
                if (this.pingConfigBuilder_ == null) {
                    this.pingConfigBuilder_ = new SingleFieldBuilderV3(this.getPingConfig(), this.getParentForChildren(), this.isClean());
                    this.pingConfig_ = null;
                }
                return this.pingConfigBuilder_;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        private static final class HeadersDefaultEntryHolder {
            static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance(UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_HeadersEntry_descriptor, WireFormat.FieldType.STRING, "", WireFormat.FieldType.STRING, "");

            private HeadersDefaultEntryHolder() {
            }
        }

        public static final class ResponseStatusCode
        extends GeneratedMessageV3
        implements ResponseStatusCodeOrBuilder {
            private static final long serialVersionUID = 0L;
            private int statusCodeCase_ = 0;
            private Object statusCode_;
            public static final int STATUS_VALUE_FIELD_NUMBER = 1;
            public static final int STATUS_CLASS_FIELD_NUMBER = 2;
            private byte memoizedIsInitialized = (byte)-1;
            private static final ResponseStatusCode DEFAULT_INSTANCE = new ResponseStatusCode();
            private static final Parser<ResponseStatusCode> PARSER = new AbstractParser<ResponseStatusCode>(){

                @Override
                public ResponseStatusCode parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = ResponseStatusCode.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private ResponseStatusCode(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private ResponseStatusCode() {
            }

            @Override
            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new ResponseStatusCode();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_fieldAccessorTable.ensureFieldAccessorsInitialized(ResponseStatusCode.class, Builder.class);
            }

            @Override
            public StatusCodeCase getStatusCodeCase() {
                return StatusCodeCase.forNumber(this.statusCodeCase_);
            }

            @Override
            public boolean hasStatusValue() {
                return this.statusCodeCase_ == 1;
            }

            @Override
            public int getStatusValue() {
                if (this.statusCodeCase_ == 1) {
                    return (Integer)this.statusCode_;
                }
                return 0;
            }

            @Override
            public boolean hasStatusClass() {
                return this.statusCodeCase_ == 2;
            }

            @Override
            public int getStatusClassValue() {
                if (this.statusCodeCase_ == 2) {
                    return (Integer)this.statusCode_;
                }
                return 0;
            }

            @Override
            public StatusClass getStatusClass() {
                if (this.statusCodeCase_ == 2) {
                    StatusClass result = StatusClass.forNumber((Integer)this.statusCode_);
                    return result == null ? StatusClass.UNRECOGNIZED : result;
                }
                return StatusClass.STATUS_CLASS_UNSPECIFIED;
            }

            @Override
            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            @Override
            public void writeTo(CodedOutputStream output) throws IOException {
                if (this.statusCodeCase_ == 1) {
                    output.writeInt32(1, (Integer)this.statusCode_);
                }
                if (this.statusCodeCase_ == 2) {
                    output.writeEnum(2, (Integer)this.statusCode_);
                }
                this.getUnknownFields().writeTo(output);
            }

            @Override
            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if (this.statusCodeCase_ == 1) {
                    size += CodedOutputStream.computeInt32Size(1, (Integer)this.statusCode_);
                }
                if (this.statusCodeCase_ == 2) {
                    size += CodedOutputStream.computeEnumSize(2, (Integer)this.statusCode_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof ResponseStatusCode)) {
                    return super.equals(obj);
                }
                ResponseStatusCode other = (ResponseStatusCode)obj;
                if (!this.getStatusCodeCase().equals(other.getStatusCodeCase())) {
                    return false;
                }
                switch (this.statusCodeCase_) {
                    case 1: {
                        if (this.getStatusValue() == other.getStatusValue()) break;
                        return false;
                    }
                    case 2: {
                        if (this.getStatusClassValue() == other.getStatusClassValue()) break;
                        return false;
                    }
                }
                return this.getUnknownFields().equals(other.getUnknownFields());
            }

            @Override
            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + ResponseStatusCode.getDescriptor().hashCode();
                switch (this.statusCodeCase_) {
                    case 1: {
                        hash = 37 * hash + 1;
                        hash = 53 * hash + this.getStatusValue();
                        break;
                    }
                    case 2: {
                        hash = 37 * hash + 2;
                        hash = 53 * hash + this.getStatusClassValue();
                        break;
                    }
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static ResponseStatusCode parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }

            public static ResponseStatusCode parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }

            public static ResponseStatusCode parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }

            public static ResponseStatusCode parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }

            public static ResponseStatusCode parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }

            public static ResponseStatusCode parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }

            public static ResponseStatusCode parseFrom(InputStream input) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static ResponseStatusCode parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static ResponseStatusCode parseDelimitedFrom(InputStream input) throws IOException {
                return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
            }

            public static ResponseStatusCode parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }

            public static ResponseStatusCode parseFrom(CodedInputStream input) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static ResponseStatusCode parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
            }

            @Override
            public Builder newBuilderForType() {
                return ResponseStatusCode.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(ResponseStatusCode prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            @Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            @Override
            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static ResponseStatusCode getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<ResponseStatusCode> parser() {
                return PARSER;
            }

            public Parser<ResponseStatusCode> getParserForType() {
                return PARSER;
            }

            @Override
            public ResponseStatusCode getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements ResponseStatusCodeOrBuilder {
                private int statusCodeCase_ = 0;
                private Object statusCode_;
                private int bitField0_;

                public static final Descriptors.Descriptor getDescriptor() {
                    return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_descriptor;
                }

                @Override
                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_fieldAccessorTable.ensureFieldAccessorsInitialized(ResponseStatusCode.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                @Override
                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.statusCodeCase_ = 0;
                    this.statusCode_ = null;
                    return this;
                }

                @Override
                public Descriptors.Descriptor getDescriptorForType() {
                    return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_descriptor;
                }

                @Override
                public ResponseStatusCode getDefaultInstanceForType() {
                    return ResponseStatusCode.getDefaultInstance();
                }

                @Override
                public ResponseStatusCode build() {
                    ResponseStatusCode result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException(result);
                    }
                    return result;
                }

                @Override
                public ResponseStatusCode buildPartial() {
                    ResponseStatusCode result = new ResponseStatusCode(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.buildPartialOneofs(result);
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(ResponseStatusCode result) {
                    int from_bitField0_ = this.bitField0_;
                }

                private void buildPartialOneofs(ResponseStatusCode result) {
                    result.statusCodeCase_ = this.statusCodeCase_;
                    result.statusCode_ = this.statusCode_;
                }

                @Override
                public Builder clone() {
                    return (Builder)super.clone();
                }

                @Override
                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                @Override
                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                @Override
                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                @Override
                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                @Override
                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                @Override
                public Builder mergeFrom(Message other) {
                    if (other instanceof ResponseStatusCode) {
                        return this.mergeFrom((ResponseStatusCode)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(ResponseStatusCode other) {
                    if (other == ResponseStatusCode.getDefaultInstance()) {
                        return this;
                    }
                    switch (other.getStatusCodeCase()) {
                        case STATUS_VALUE: {
                            this.setStatusValue(other.getStatusValue());
                            break;
                        }
                        case STATUS_CLASS: {
                            this.setStatusClassValue(other.getStatusClassValue());
                            break;
                        }
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                @Override
                public final boolean isInitialized() {
                    return true;
                }

                @Override
                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block10: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block10;
                                }
                                case 8: {
                                    this.statusCode_ = input.readInt32();
                                    this.statusCodeCase_ = 1;
                                    continue block10;
                                }
                                case 16: {
                                    int rawValue = input.readEnum();
                                    this.statusCodeCase_ = 2;
                                    this.statusCode_ = rawValue;
                                    continue block10;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public StatusCodeCase getStatusCodeCase() {
                    return StatusCodeCase.forNumber(this.statusCodeCase_);
                }

                public Builder clearStatusCode() {
                    this.statusCodeCase_ = 0;
                    this.statusCode_ = null;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasStatusValue() {
                    return this.statusCodeCase_ == 1;
                }

                @Override
                public int getStatusValue() {
                    if (this.statusCodeCase_ == 1) {
                        return (Integer)this.statusCode_;
                    }
                    return 0;
                }

                public Builder setStatusValue(int value) {
                    this.statusCodeCase_ = 1;
                    this.statusCode_ = value;
                    this.onChanged();
                    return this;
                }

                public Builder clearStatusValue() {
                    if (this.statusCodeCase_ == 1) {
                        this.statusCodeCase_ = 0;
                        this.statusCode_ = null;
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public boolean hasStatusClass() {
                    return this.statusCodeCase_ == 2;
                }

                @Override
                public int getStatusClassValue() {
                    if (this.statusCodeCase_ == 2) {
                        return (Integer)this.statusCode_;
                    }
                    return 0;
                }

                public Builder setStatusClassValue(int value) {
                    this.statusCodeCase_ = 2;
                    this.statusCode_ = value;
                    this.onChanged();
                    return this;
                }

                @Override
                public StatusClass getStatusClass() {
                    if (this.statusCodeCase_ == 2) {
                        StatusClass result = StatusClass.forNumber((Integer)this.statusCode_);
                        return result == null ? StatusClass.UNRECOGNIZED : result;
                    }
                    return StatusClass.STATUS_CLASS_UNSPECIFIED;
                }

                public Builder setStatusClass(StatusClass value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.statusCodeCase_ = 2;
                    this.statusCode_ = value.getNumber();
                    this.onChanged();
                    return this;
                }

                public Builder clearStatusClass() {
                    if (this.statusCodeCase_ == 2) {
                        this.statusCodeCase_ = 0;
                        this.statusCode_ = null;
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                @Override
                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }

            public static enum StatusCodeCase implements Internal.EnumLite,
            AbstractMessageLite.InternalOneOfEnum
            {
                STATUS_VALUE(1),
                STATUS_CLASS(2),
                STATUSCODE_NOT_SET(0);

                private final int value;

                private StatusCodeCase(int value) {
                    this.value = value;
                }

                @Deprecated
                public static StatusCodeCase valueOf(int value) {
                    return StatusCodeCase.forNumber(value);
                }

                public static StatusCodeCase forNumber(int value) {
                    switch (value) {
                        case 1: {
                            return STATUS_VALUE;
                        }
                        case 2: {
                            return STATUS_CLASS;
                        }
                        case 0: {
                            return STATUSCODE_NOT_SET;
                        }
                    }
                    return null;
                }

                @Override
                public int getNumber() {
                    return this.value;
                }
            }

            public static enum StatusClass implements ProtocolMessageEnum
            {
                STATUS_CLASS_UNSPECIFIED(0),
                STATUS_CLASS_1XX(100),
                STATUS_CLASS_2XX(200),
                STATUS_CLASS_3XX(300),
                STATUS_CLASS_4XX(400),
                STATUS_CLASS_5XX(500),
                STATUS_CLASS_ANY(1000),
                UNRECOGNIZED(-1);

                public static final int STATUS_CLASS_UNSPECIFIED_VALUE = 0;
                public static final int STATUS_CLASS_1XX_VALUE = 100;
                public static final int STATUS_CLASS_2XX_VALUE = 200;
                public static final int STATUS_CLASS_3XX_VALUE = 300;
                public static final int STATUS_CLASS_4XX_VALUE = 400;
                public static final int STATUS_CLASS_5XX_VALUE = 500;
                public static final int STATUS_CLASS_ANY_VALUE = 1000;
                private static final Internal.EnumLiteMap<StatusClass> internalValueMap;
                private static final StatusClass[] VALUES;
                private final int value;

                @Override
                public final int getNumber() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                    }
                    return this.value;
                }

                @Deprecated
                public static StatusClass valueOf(int value) {
                    return StatusClass.forNumber(value);
                }

                public static StatusClass forNumber(int value) {
                    switch (value) {
                        case 0: {
                            return STATUS_CLASS_UNSPECIFIED;
                        }
                        case 100: {
                            return STATUS_CLASS_1XX;
                        }
                        case 200: {
                            return STATUS_CLASS_2XX;
                        }
                        case 300: {
                            return STATUS_CLASS_3XX;
                        }
                        case 400: {
                            return STATUS_CLASS_4XX;
                        }
                        case 500: {
                            return STATUS_CLASS_5XX;
                        }
                        case 1000: {
                            return STATUS_CLASS_ANY;
                        }
                    }
                    return null;
                }

                public static Internal.EnumLiteMap<StatusClass> internalGetValueMap() {
                    return internalValueMap;
                }

                @Override
                public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                    if (this == UNRECOGNIZED) {
                        throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                    }
                    return StatusClass.getDescriptor().getValues().get(this.ordinal());
                }

                @Override
                public final Descriptors.EnumDescriptor getDescriptorForType() {
                    return StatusClass.getDescriptor();
                }

                public static final Descriptors.EnumDescriptor getDescriptor() {
                    return ResponseStatusCode.getDescriptor().getEnumTypes().get(0);
                }

                public static StatusClass valueOf(Descriptors.EnumValueDescriptor desc) {
                    if (desc.getType() != StatusClass.getDescriptor()) {
                        throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                    }
                    if (desc.getIndex() == -1) {
                        return UNRECOGNIZED;
                    }
                    return VALUES[desc.getIndex()];
                }

                private StatusClass(int value) {
                    this.value = value;
                }

                static {
                    internalValueMap = new Internal.EnumLiteMap<StatusClass>(){

                        @Override
                        public StatusClass findValueByNumber(int number) {
                            return StatusClass.forNumber(number);
                        }
                    };
                    VALUES = StatusClass.values();
                }
            }
        }

        public static interface ResponseStatusCodeOrBuilder
        extends MessageOrBuilder {
            public boolean hasStatusValue();

            public int getStatusValue();

            public boolean hasStatusClass();

            public int getStatusClassValue();

            public ResponseStatusCode.StatusClass getStatusClass();

            public ResponseStatusCode.StatusCodeCase getStatusCodeCase();
        }

        public static final class BasicAuthentication
        extends GeneratedMessageV3
        implements BasicAuthenticationOrBuilder {
            private static final long serialVersionUID = 0L;
            public static final int USERNAME_FIELD_NUMBER = 1;
            private volatile Object username_ = "";
            public static final int PASSWORD_FIELD_NUMBER = 2;
            private volatile Object password_ = "";
            private byte memoizedIsInitialized = (byte)-1;
            private static final BasicAuthentication DEFAULT_INSTANCE = new BasicAuthentication();
            private static final Parser<BasicAuthentication> PARSER = new AbstractParser<BasicAuthentication>(){

                @Override
                public BasicAuthentication parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = BasicAuthentication.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private BasicAuthentication(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private BasicAuthentication() {
                this.username_ = "";
                this.password_ = "";
            }

            @Override
            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new BasicAuthentication();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_fieldAccessorTable.ensureFieldAccessorsInitialized(BasicAuthentication.class, Builder.class);
            }

            @Override
            public String getUsername() {
                Object ref = this.username_;
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.username_ = s2;
                return s2;
            }

            @Override
            public ByteString getUsernameBytes() {
                Object ref = this.username_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.username_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            @Override
            public String getPassword() {
                Object ref = this.password_;
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.password_ = s2;
                return s2;
            }

            @Override
            public ByteString getPasswordBytes() {
                Object ref = this.password_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.password_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            @Override
            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            @Override
            public void writeTo(CodedOutputStream output) throws IOException {
                if (!GeneratedMessageV3.isStringEmpty(this.username_)) {
                    GeneratedMessageV3.writeString(output, 1, this.username_);
                }
                if (!GeneratedMessageV3.isStringEmpty(this.password_)) {
                    GeneratedMessageV3.writeString(output, 2, this.password_);
                }
                this.getUnknownFields().writeTo(output);
            }

            @Override
            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if (!GeneratedMessageV3.isStringEmpty(this.username_)) {
                    size += GeneratedMessageV3.computeStringSize(1, this.username_);
                }
                if (!GeneratedMessageV3.isStringEmpty(this.password_)) {
                    size += GeneratedMessageV3.computeStringSize(2, this.password_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof BasicAuthentication)) {
                    return super.equals(obj);
                }
                BasicAuthentication other = (BasicAuthentication)obj;
                if (!this.getUsername().equals(other.getUsername())) {
                    return false;
                }
                if (!this.getPassword().equals(other.getPassword())) {
                    return false;
                }
                return this.getUnknownFields().equals(other.getUnknownFields());
            }

            @Override
            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + BasicAuthentication.getDescriptor().hashCode();
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getUsername().hashCode();
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getPassword().hashCode();
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static BasicAuthentication parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }

            public static BasicAuthentication parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }

            public static BasicAuthentication parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }

            public static BasicAuthentication parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }

            public static BasicAuthentication parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }

            public static BasicAuthentication parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }

            public static BasicAuthentication parseFrom(InputStream input) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static BasicAuthentication parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static BasicAuthentication parseDelimitedFrom(InputStream input) throws IOException {
                return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
            }

            public static BasicAuthentication parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }

            public static BasicAuthentication parseFrom(CodedInputStream input) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static BasicAuthentication parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
            }

            @Override
            public Builder newBuilderForType() {
                return BasicAuthentication.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(BasicAuthentication prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            @Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            @Override
            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static BasicAuthentication getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<BasicAuthentication> parser() {
                return PARSER;
            }

            public Parser<BasicAuthentication> getParserForType() {
                return PARSER;
            }

            @Override
            public BasicAuthentication getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements BasicAuthenticationOrBuilder {
                private int bitField0_;
                private Object username_ = "";
                private Object password_ = "";

                public static final Descriptors.Descriptor getDescriptor() {
                    return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_descriptor;
                }

                @Override
                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_fieldAccessorTable.ensureFieldAccessorsInitialized(BasicAuthentication.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                @Override
                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.username_ = "";
                    this.password_ = "";
                    return this;
                }

                @Override
                public Descriptors.Descriptor getDescriptorForType() {
                    return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_descriptor;
                }

                @Override
                public BasicAuthentication getDefaultInstanceForType() {
                    return BasicAuthentication.getDefaultInstance();
                }

                @Override
                public BasicAuthentication build() {
                    BasicAuthentication result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException(result);
                    }
                    return result;
                }

                @Override
                public BasicAuthentication buildPartial() {
                    BasicAuthentication result = new BasicAuthentication(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(BasicAuthentication result) {
                    int from_bitField0_ = this.bitField0_;
                    if ((from_bitField0_ & 1) != 0) {
                        result.username_ = this.username_;
                    }
                    if ((from_bitField0_ & 2) != 0) {
                        result.password_ = this.password_;
                    }
                }

                @Override
                public Builder clone() {
                    return (Builder)super.clone();
                }

                @Override
                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                @Override
                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                @Override
                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                @Override
                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                @Override
                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                @Override
                public Builder mergeFrom(Message other) {
                    if (other instanceof BasicAuthentication) {
                        return this.mergeFrom((BasicAuthentication)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(BasicAuthentication other) {
                    if (other == BasicAuthentication.getDefaultInstance()) {
                        return this;
                    }
                    if (!other.getUsername().isEmpty()) {
                        this.username_ = other.username_;
                        this.bitField0_ |= 1;
                        this.onChanged();
                    }
                    if (!other.getPassword().isEmpty()) {
                        this.password_ = other.password_;
                        this.bitField0_ |= 2;
                        this.onChanged();
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                @Override
                public final boolean isInitialized() {
                    return true;
                }

                @Override
                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block10: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block10;
                                }
                                case 10: {
                                    this.username_ = input.readStringRequireUtf8();
                                    this.bitField0_ |= 1;
                                    continue block10;
                                }
                                case 18: {
                                    this.password_ = input.readStringRequireUtf8();
                                    this.bitField0_ |= 2;
                                    continue block10;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public String getUsername() {
                    Object ref = this.username_;
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s2 = bs.toStringUtf8();
                        this.username_ = s2;
                        return s2;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getUsernameBytes() {
                    Object ref = this.username_;
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)ref);
                        this.username_ = b;
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setUsername(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.username_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder clearUsername() {
                    this.username_ = BasicAuthentication.getDefaultInstance().getUsername();
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.onChanged();
                    return this;
                }

                public Builder setUsernameBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    BasicAuthentication.checkByteStringIsUtf8(value);
                    this.username_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                @Override
                public String getPassword() {
                    Object ref = this.password_;
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s2 = bs.toStringUtf8();
                        this.password_ = s2;
                        return s2;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getPasswordBytes() {
                    Object ref = this.password_;
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)ref);
                        this.password_ = b;
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setPassword(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.password_ = value;
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                public Builder clearPassword() {
                    this.password_ = BasicAuthentication.getDefaultInstance().getPassword();
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.onChanged();
                    return this;
                }

                public Builder setPasswordBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    BasicAuthentication.checkByteStringIsUtf8(value);
                    this.password_ = value;
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                @Override
                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                @Override
                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }
        }

        public static interface BasicAuthenticationOrBuilder
        extends MessageOrBuilder {
            public String getUsername();

            public ByteString getUsernameBytes();

            public String getPassword();

            public ByteString getPasswordBytes();
        }

        public static enum ContentType implements ProtocolMessageEnum
        {
            TYPE_UNSPECIFIED(0),
            URL_ENCODED(1),
            USER_PROVIDED(2),
            UNRECOGNIZED(-1);

            public static final int TYPE_UNSPECIFIED_VALUE = 0;
            public static final int URL_ENCODED_VALUE = 1;
            public static final int USER_PROVIDED_VALUE = 2;
            private static final Internal.EnumLiteMap<ContentType> internalValueMap;
            private static final ContentType[] VALUES;
            private final int value;

            @Override
            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static ContentType valueOf(int value) {
                return ContentType.forNumber(value);
            }

            public static ContentType forNumber(int value) {
                switch (value) {
                    case 0: {
                        return TYPE_UNSPECIFIED;
                    }
                    case 1: {
                        return URL_ENCODED;
                    }
                    case 2: {
                        return USER_PROVIDED;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<ContentType> internalGetValueMap() {
                return internalValueMap;
            }

            @Override
            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return ContentType.getDescriptor().getValues().get(this.ordinal());
            }

            @Override
            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return ContentType.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return HttpCheck.getDescriptor().getEnumTypes().get(1);
            }

            public static ContentType valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != ContentType.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private ContentType(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<ContentType>(){

                    @Override
                    public ContentType findValueByNumber(int number) {
                        return ContentType.forNumber(number);
                    }
                };
                VALUES = ContentType.values();
            }
        }

        public static enum RequestMethod implements ProtocolMessageEnum
        {
            METHOD_UNSPECIFIED(0),
            GET(1),
            POST(2),
            UNRECOGNIZED(-1);

            public static final int METHOD_UNSPECIFIED_VALUE = 0;
            public static final int GET_VALUE = 1;
            public static final int POST_VALUE = 2;
            private static final Internal.EnumLiteMap<RequestMethod> internalValueMap;
            private static final RequestMethod[] VALUES;
            private final int value;

            @Override
            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static RequestMethod valueOf(int value) {
                return RequestMethod.forNumber(value);
            }

            public static RequestMethod forNumber(int value) {
                switch (value) {
                    case 0: {
                        return METHOD_UNSPECIFIED;
                    }
                    case 1: {
                        return GET;
                    }
                    case 2: {
                        return POST;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<RequestMethod> internalGetValueMap() {
                return internalValueMap;
            }

            @Override
            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return RequestMethod.getDescriptor().getValues().get(this.ordinal());
            }

            @Override
            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return RequestMethod.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return HttpCheck.getDescriptor().getEnumTypes().get(0);
            }

            public static RequestMethod valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != RequestMethod.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private RequestMethod(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<RequestMethod>(){

                    @Override
                    public RequestMethod findValueByNumber(int number) {
                        return RequestMethod.forNumber(number);
                    }
                };
                VALUES = RequestMethod.values();
            }
        }
    }

    public static interface HttpCheckOrBuilder
    extends MessageOrBuilder {
        public int getRequestMethodValue();

        public HttpCheck.RequestMethod getRequestMethod();

        public boolean getUseSsl();

        public String getPath();

        public ByteString getPathBytes();

        public int getPort();

        public boolean hasAuthInfo();

        public HttpCheck.BasicAuthentication getAuthInfo();

        public HttpCheck.BasicAuthenticationOrBuilder getAuthInfoOrBuilder();

        public boolean getMaskHeaders();

        public int getHeadersCount();

        public boolean containsHeaders(String var1);

        @Deprecated
        public Map<String, String> getHeaders();

        public Map<String, String> getHeadersMap();

        public String getHeadersOrDefault(String var1, String var2);

        public String getHeadersOrThrow(String var1);

        public int getContentTypeValue();

        public HttpCheck.ContentType getContentType();

        public String getCustomContentType();

        public ByteString getCustomContentTypeBytes();

        public boolean getValidateSsl();

        public ByteString getBody();

        public List<HttpCheck.ResponseStatusCode> getAcceptedResponseStatusCodesList();

        public HttpCheck.ResponseStatusCode getAcceptedResponseStatusCodes(int var1);

        public int getAcceptedResponseStatusCodesCount();

        public List<? extends HttpCheck.ResponseStatusCodeOrBuilder> getAcceptedResponseStatusCodesOrBuilderList();

        public HttpCheck.ResponseStatusCodeOrBuilder getAcceptedResponseStatusCodesOrBuilder(int var1);

        public boolean hasPingConfig();

        public PingConfig getPingConfig();

        public PingConfigOrBuilder getPingConfigOrBuilder();
    }

    public static final class PingConfig
    extends GeneratedMessageV3
    implements PingConfigOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int PINGS_COUNT_FIELD_NUMBER = 1;
        private int pingsCount_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final PingConfig DEFAULT_INSTANCE = new PingConfig();
        private static final Parser<PingConfig> PARSER = new AbstractParser<PingConfig>(){

            @Override
            public PingConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = PingConfig.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private PingConfig(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private PingConfig() {
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new PingConfig();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(PingConfig.class, Builder.class);
        }

        @Override
        public int getPingsCount() {
            return this.pingsCount_;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.pingsCount_ != 0) {
                output.writeInt32(1, this.pingsCount_);
            }
            this.getUnknownFields().writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.pingsCount_ != 0) {
                size += CodedOutputStream.computeInt32Size(1, this.pingsCount_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PingConfig)) {
                return super.equals(obj);
            }
            PingConfig other = (PingConfig)obj;
            if (this.getPingsCount() != other.getPingsCount()) {
                return false;
            }
            return this.getUnknownFields().equals(other.getUnknownFields());
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + PingConfig.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getPingsCount();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static PingConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PingConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PingConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PingConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PingConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PingConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PingConfig parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static PingConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static PingConfig parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static PingConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static PingConfig parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static PingConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return PingConfig.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PingConfig prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static PingConfig getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<PingConfig> parser() {
            return PARSER;
        }

        public Parser<PingConfig> getParserForType() {
            return PARSER;
        }

        @Override
        public PingConfig getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements PingConfigOrBuilder {
            private int bitField0_;
            private int pingsCount_;

            public static final Descriptors.Descriptor getDescriptor() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(PingConfig.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            @Override
            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.pingsCount_ = 0;
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_descriptor;
            }

            @Override
            public PingConfig getDefaultInstanceForType() {
                return PingConfig.getDefaultInstance();
            }

            @Override
            public PingConfig build() {
                PingConfig result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public PingConfig buildPartial() {
                PingConfig result = new PingConfig(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(PingConfig result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.pingsCount_ = this.pingsCount_;
                }
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof PingConfig) {
                    return this.mergeFrom((PingConfig)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(PingConfig other) {
                if (other == PingConfig.getDefaultInstance()) {
                    return this;
                }
                if (other.getPingsCount() != 0) {
                    this.setPingsCount(other.getPingsCount());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 8: {
                                this.pingsCount_ = input.readInt32();
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public int getPingsCount() {
                return this.pingsCount_;
            }

            public Builder setPingsCount(int value) {
                this.pingsCount_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearPingsCount() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.pingsCount_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface PingConfigOrBuilder
    extends MessageOrBuilder {
        public int getPingsCount();
    }

    public static final class ResourceGroup
    extends GeneratedMessageV3
    implements ResourceGroupOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int GROUP_ID_FIELD_NUMBER = 1;
        private volatile Object groupId_ = "";
        public static final int RESOURCE_TYPE_FIELD_NUMBER = 2;
        private int resourceType_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ResourceGroup DEFAULT_INSTANCE = new ResourceGroup();
        private static final Parser<ResourceGroup> PARSER = new AbstractParser<ResourceGroup>(){

            @Override
            public ResourceGroup parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ResourceGroup.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private ResourceGroup(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private ResourceGroup() {
            this.groupId_ = "";
            this.resourceType_ = 0;
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new ResourceGroup();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(ResourceGroup.class, Builder.class);
        }

        @Override
        public String getGroupId() {
            Object ref = this.groupId_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s2 = bs.toStringUtf8();
            this.groupId_ = s2;
            return s2;
        }

        @Override
        public ByteString getGroupIdBytes() {
            Object ref = this.groupId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.groupId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public int getResourceTypeValue() {
            return this.resourceType_;
        }

        @Override
        public GroupResourceType getResourceType() {
            GroupResourceType result = GroupResourceType.forNumber(this.resourceType_);
            return result == null ? GroupResourceType.UNRECOGNIZED : result;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty(this.groupId_)) {
                GeneratedMessageV3.writeString(output, 1, this.groupId_);
            }
            if (this.resourceType_ != GroupResourceType.RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
                output.writeEnum(2, this.resourceType_);
            }
            this.getUnknownFields().writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty(this.groupId_)) {
                size += GeneratedMessageV3.computeStringSize(1, this.groupId_);
            }
            if (this.resourceType_ != GroupResourceType.RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize(2, this.resourceType_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ResourceGroup)) {
                return super.equals(obj);
            }
            ResourceGroup other = (ResourceGroup)obj;
            if (!this.getGroupId().equals(other.getGroupId())) {
                return false;
            }
            if (this.resourceType_ != other.resourceType_) {
                return false;
            }
            return this.getUnknownFields().equals(other.getUnknownFields());
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ResourceGroup.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getGroupId().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.resourceType_;
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static ResourceGroup parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ResourceGroup parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ResourceGroup parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ResourceGroup parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ResourceGroup parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static ResourceGroup parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static ResourceGroup parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static ResourceGroup parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static ResourceGroup parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static ResourceGroup parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static ResourceGroup parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static ResourceGroup parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return ResourceGroup.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ResourceGroup prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ResourceGroup getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ResourceGroup> parser() {
            return PARSER;
        }

        public Parser<ResourceGroup> getParserForType() {
            return PARSER;
        }

        @Override
        public ResourceGroup getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ResourceGroupOrBuilder {
            private int bitField0_;
            private Object groupId_ = "";
            private int resourceType_ = 0;

            public static final Descriptors.Descriptor getDescriptor() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(ResourceGroup.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            @Override
            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.groupId_ = "";
                this.resourceType_ = 0;
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return UptimeProto.internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_descriptor;
            }

            @Override
            public ResourceGroup getDefaultInstanceForType() {
                return ResourceGroup.getDefaultInstance();
            }

            @Override
            public ResourceGroup build() {
                ResourceGroup result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public ResourceGroup buildPartial() {
                ResourceGroup result = new ResourceGroup(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(ResourceGroup result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.groupId_ = this.groupId_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.resourceType_ = this.resourceType_;
                }
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof ResourceGroup) {
                    return this.mergeFrom((ResourceGroup)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ResourceGroup other) {
                if (other == ResourceGroup.getDefaultInstance()) {
                    return this;
                }
                if (!other.getGroupId().isEmpty()) {
                    this.groupId_ = other.groupId_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (other.resourceType_ != 0) {
                    this.setResourceTypeValue(other.getResourceTypeValue());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                this.groupId_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 16: {
                                this.resourceType_ = input.readEnum();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getGroupId() {
                Object ref = this.groupId_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s2 = bs.toStringUtf8();
                    this.groupId_ = s2;
                    return s2;
                }
                return (String)ref;
            }

            @Override
            public ByteString getGroupIdBytes() {
                Object ref = this.groupId_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.groupId_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setGroupId(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.groupId_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearGroupId() {
                this.groupId_ = ResourceGroup.getDefaultInstance().getGroupId();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setGroupIdBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ResourceGroup.checkByteStringIsUtf8(value);
                this.groupId_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public int getResourceTypeValue() {
                return this.resourceType_;
            }

            public Builder setResourceTypeValue(int value) {
                this.resourceType_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            @Override
            public GroupResourceType getResourceType() {
                GroupResourceType result = GroupResourceType.forNumber(this.resourceType_);
                return result == null ? GroupResourceType.UNRECOGNIZED : result;
            }

            public Builder setResourceType(GroupResourceType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 2;
                this.resourceType_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearResourceType() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.resourceType_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface ResourceGroupOrBuilder
    extends MessageOrBuilder {
        public String getGroupId();

        public ByteString getGroupIdBytes();

        public int getResourceTypeValue();

        public GroupResourceType getResourceType();
    }

    public static enum CheckerType implements ProtocolMessageEnum
    {
        CHECKER_TYPE_UNSPECIFIED(0),
        STATIC_IP_CHECKERS(1),
        VPC_CHECKERS(3),
        UNRECOGNIZED(-1);

        public static final int CHECKER_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int STATIC_IP_CHECKERS_VALUE = 1;
        public static final int VPC_CHECKERS_VALUE = 3;
        private static final Internal.EnumLiteMap<CheckerType> internalValueMap;
        private static final CheckerType[] VALUES;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static CheckerType valueOf(int value) {
            return CheckerType.forNumber(value);
        }

        public static CheckerType forNumber(int value) {
            switch (value) {
                case 0: {
                    return CHECKER_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return STATIC_IP_CHECKERS;
                }
                case 3: {
                    return VPC_CHECKERS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<CheckerType> internalGetValueMap() {
            return internalValueMap;
        }

        @Override
        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return CheckerType.getDescriptor().getValues().get(this.ordinal());
        }

        @Override
        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return CheckerType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return UptimeCheckConfig.getDescriptor().getEnumTypes().get(0);
        }

        public static CheckerType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != CheckerType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private CheckerType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<CheckerType>(){

                @Override
                public CheckerType findValueByNumber(int number) {
                    return CheckerType.forNumber(number);
                }
            };
            VALUES = CheckerType.values();
        }
    }
}

