/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage;

import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.storage.GoogleCloudStorageComponent;
import org.apache.camel.component.google.storage.GoogleCloudStorageConfiguration;
import org.apache.camel.component.google.storage.GoogleCloudStorageConnectionFactory;
import org.apache.camel.component.google.storage.GoogleCloudStorageConstants;
import org.apache.camel.component.google.storage.GoogleCloudStorageConsumer;
import org.apache.camel.component.google.storage.GoogleCloudStorageProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.9.0", scheme="google-storage", title="Google Storage", syntax="google-storage:bucketName", category={Category.CLOUD}, headersClass=GoogleCloudStorageConstants.class)
public class GoogleCloudStorageEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleCloudStorageEndpoint.class);
    @UriParam
    private GoogleCloudStorageConfiguration configuration;
    private Storage storageClient;

    public GoogleCloudStorageEndpoint(String uri, GoogleCloudStorageComponent component, GoogleCloudStorageConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new GoogleCloudStorageProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        GoogleCloudStorageConsumer consumer = new GoogleCloudStorageConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    @Override
    public GoogleCloudStorageComponent getComponent() {
        return (GoogleCloudStorageComponent)super.getComponent();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.storageClient = this.configuration.getStorageClient();
        if (this.storageClient == null) {
            this.storageClient = GoogleCloudStorageConnectionFactory.create(this.getCamelContext(), this.configuration);
        }
        if (this.configuration.isAutoCreateBucket()) {
            Bucket bucket = this.storageClient.get(this.configuration.getBucketName(), new Storage.BucketGetOption[0]);
            if (bucket != null) {
                LOG.trace("Bucket [{}] already exists", (Object)bucket.getName());
                return;
            }
            GoogleCloudStorageEndpoint.createNewBucket(this.configuration.getBucketName(), this.configuration, this.storageClient);
        }
    }

    public static Bucket createNewBucket(String bucketName, GoogleCloudStorageConfiguration conf, Storage storage) {
        String location = conf.getStorageLocation();
        StorageClass storageClass = conf.getStorageClass();
        BucketInfo.Builder bucketBuilder = BucketInfo.newBuilder(bucketName).setStorageClass(storageClass).setLocation(location);
        BucketInfo bucketInfo = bucketBuilder.build();
        Bucket bucket = storage.create(bucketInfo, new Storage.BucketTargetOption[0]);
        LOG.trace("Bucket [{}] has been created", (Object)bucket.getName());
        return bucket;
    }

    public GoogleCloudStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GoogleCloudStorageConfiguration configuration) {
        this.configuration = configuration;
    }

    public Storage getStorageClient() {
        return this.storageClient;
    }

    @Override
    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty(this.configuration.getBucketName()) && ObjectHelper.isNotEmpty(this.configuration.getStorageLocation())) {
            return this.getServiceProtocol() + ":" + this.configuration.getStorageLocation() + ":" + this.configuration.getBucketName();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        return "storage";
    }

    @Override
    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getStorageClass() != null) {
            return Map.of("storageClass", this.configuration.getStorageClass().name());
        }
        return null;
    }
}

