/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage;

import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.google.storage.GoogleCloudStorageEndpoint;
import org.apache.camel.component.google.storage.GoogleCloudStorageOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class GoogleCloudStorageEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        GoogleCloudStorageEndpoint target = (GoogleCloudStorageEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autocreatebucket": 
            case "autoCreateBucket": {
                target.getConfiguration().setAutoCreateBucket(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold(GoogleCloudStorageEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold(GoogleCloudStorageEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier(GoogleCloudStorageEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "delay": {
                target.setDelay(GoogleCloudStorageEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                target.getConfiguration().setDeleteAfterRead(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "destinationbucket": 
            case "destinationBucket": {
                target.getConfiguration().setDestinationBucket(GoogleCloudStorageEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "downloadfilename": 
            case "downloadFileName": {
                target.getConfiguration().setDownloadFileName(GoogleCloudStorageEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(GoogleCloudStorageEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(GoogleCloudStorageEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "filter": {
                target.getConfiguration().setFilter(GoogleCloudStorageEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "greedy": {
                target.setGreedy(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "includebody": 
            case "includeBody": {
                target.getConfiguration().setIncludeBody(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "includefolders": 
            case "includeFolders": {
                target.getConfiguration().setIncludeFolders(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay(GoogleCloudStorageEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "moveafterread": 
            case "moveAfterRead": {
                target.getConfiguration().setMoveAfterRead(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "objectname": 
            case "objectName": {
                target.getConfiguration().setObjectName(GoogleCloudStorageEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "operation": {
                target.getConfiguration().setOperation(GoogleCloudStorageEndpointConfigurer.property(camelContext, GoogleCloudStorageOperations.class, value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy(GoogleCloudStorageEndpointConfigurer.property(camelContext, PollingConsumerPollStrategy.class, value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount(GoogleCloudStorageEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel(GoogleCloudStorageEndpointConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService(GoogleCloudStorageEndpointConfigurer.property(camelContext, ScheduledExecutorService.class, value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(GoogleCloudStorageEndpointConfigurer.property(camelContext, Object.class, value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties(GoogleCloudStorageEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                target.getConfiguration().setServiceAccountKey(GoogleCloudStorageEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "storageclass": 
            case "storageClass": {
                target.getConfiguration().setStorageClass(GoogleCloudStorageEndpointConfigurer.property(camelContext, StorageClass.class, value));
                return true;
            }
            case "storageclient": 
            case "storageClient": {
                target.getConfiguration().setStorageClient(GoogleCloudStorageEndpointConfigurer.property(camelContext, Storage.class, value));
                return true;
            }
            case "storagelocation": 
            case "storageLocation": {
                target.getConfiguration().setStorageLocation(GoogleCloudStorageEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit(GoogleCloudStorageEndpointConfigurer.property(camelContext, TimeUnit.class, value));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay(GoogleCloudStorageEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"storageClient"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return Boolean.TYPE;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return Integer.TYPE;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return Integer.TYPE;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return Integer.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "delay": {
                return Long.TYPE;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return Boolean.TYPE;
            }
            case "destinationbucket": 
            case "destinationBucket": {
                return String.class;
            }
            case "downloadfilename": 
            case "downloadFileName": {
                return String.class;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "filter": {
                return String.class;
            }
            case "greedy": {
                return Boolean.TYPE;
            }
            case "includebody": 
            case "includeBody": {
                return Boolean.TYPE;
            }
            case "includefolders": 
            case "includeFolders": {
                return Boolean.TYPE;
            }
            case "initialdelay": 
            case "initialDelay": {
                return Long.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "moveafterread": 
            case "moveAfterRead": {
                return Boolean.TYPE;
            }
            case "objectname": 
            case "objectName": {
                return String.class;
            }
            case "operation": {
                return GoogleCloudStorageOperations.class;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return PollingConsumerPollStrategy.class;
            }
            case "repeatcount": 
            case "repeatCount": {
                return Long.TYPE;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return LoggingLevel.class;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return ScheduledExecutorService.class;
            }
            case "scheduler": {
                return Object.class;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Map.class;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return Boolean.TYPE;
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                return String.class;
            }
            case "startscheduler": 
            case "startScheduler": {
                return Boolean.TYPE;
            }
            case "storageclass": 
            case "storageClass": {
                return StorageClass.class;
            }
            case "storageclient": 
            case "storageClient": {
                return Storage.class;
            }
            case "storagelocation": 
            case "storageLocation": {
                return String.class;
            }
            case "timeunit": 
            case "timeUnit": {
                return TimeUnit.class;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        GoogleCloudStorageEndpoint target = (GoogleCloudStorageEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return target.getConfiguration().isAutoCreateBucket();
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "delay": {
                return target.getDelay();
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return target.getConfiguration().isDeleteAfterRead();
            }
            case "destinationbucket": 
            case "destinationBucket": {
                return target.getConfiguration().getDestinationBucket();
            }
            case "downloadfilename": 
            case "downloadFileName": {
                return target.getConfiguration().getDownloadFileName();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "filter": {
                return target.getConfiguration().getFilter();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "includebody": 
            case "includeBody": {
                return target.getConfiguration().isIncludeBody();
            }
            case "includefolders": 
            case "includeFolders": {
                return target.getConfiguration().isIncludeFolders();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "moveafterread": 
            case "moveAfterRead": {
                return target.getConfiguration().isMoveAfterRead();
            }
            case "objectname": 
            case "objectName": {
                return target.getConfiguration().getObjectName();
            }
            case "operation": {
                return target.getConfiguration().getOperation();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                return target.getConfiguration().getServiceAccountKey();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "storageclass": 
            case "storageClass": {
                return target.getConfiguration().getStorageClass();
            }
            case "storageclient": 
            case "storageClient": {
                return target.getConfiguration().getStorageClient();
            }
            case "storagelocation": 
            case "storageLocation": {
                return target.getConfiguration().getStorageLocation();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Object.class;
            }
        }
        return null;
    }
}

