/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.support.EventHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepProcessor
extends Pipeline {
    private static final Logger LOG = LoggerFactory.getLogger(StepProcessor.class);
    private final String stepId;

    public StepProcessor(CamelContext camelContext, Collection<Processor> processors, String stepId) {
        super(camelContext, processors);
        this.stepId = stepId;
    }

    public static Processor newInstance(CamelContext camelContext, List<Processor> processors, String stepId) {
        if (processors.isEmpty()) {
            return null;
        }
        return new StepProcessor(camelContext, processors, stepId);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Object oldStepId = exchange.removeProperty(ExchangePropertyKey.STEP_ID);
        exchange.setProperty(ExchangePropertyKey.STEP_ID, (Object)this.stepId);
        EventHelper.notifyStepStarted(exchange.getContext(), exchange, this.stepId);
        return super.process(exchange, sync -> {
            boolean failed = exchange.isFailed();
            try {
                if (failed) {
                    EventHelper.notifyStepFailed(exchange.getContext(), exchange, this.stepId);
                } else {
                    EventHelper.notifyStepDone(exchange.getContext(), exchange, this.stepId);
                }
            }
            catch (Exception t2) {
                LOG.warn("Exception occurred during event notification. This exception will be ignored.", (Throwable)t2);
            }
            finally {
                if (oldStepId != null) {
                    exchange.setProperty(ExchangePropertyKey.STEP_ID, oldStepId);
                } else {
                    exchange.removeProperty(ExchangePropertyKey.STEP_ID);
                }
                callback.done(sync);
            }
        });
    }

    @Override
    public String getTraceLabel() {
        return "step";
    }
}

