/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grape;

import groovy.grape.Grape;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.grape.GrapeCommand;
import org.apache.camel.component.grape.GrapeEndpoint;
import org.apache.camel.component.grape.MavenCoordinates;
import org.apache.camel.support.DefaultProducer;

public class GrapeProducer
extends DefaultProducer {
    public GrapeProducer(GrapeEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) {
        GrapeCommand command = exchange.getIn().getHeader("CamelGrapeCommand", (Object)GrapeCommand.grab, GrapeCommand.class);
        switch (command) {
            case grab: {
                ClassLoader classLoader = exchange.getContext().getApplicationContextClassLoader();
                String rawCoordinates = exchange.getIn().getBody(String.class);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(5);
                try {
                    MavenCoordinates coordinates = MavenCoordinates.parseMavenCoordinates(rawCoordinates);
                    map.put("classLoader", classLoader);
                    map.put("group", coordinates.getGroupId());
                    map.put("module", coordinates.getArtifactId());
                    map.put("version", coordinates.getVersion());
                    map.put("classifier", coordinates.getClassifier());
                    Grape.grab(map);
                    this.getEndpoint().getComponent().getPatchesRepository().install(rawCoordinates);
                }
                catch (IllegalArgumentException ex) {
                    MavenCoordinates coordinates = MavenCoordinates.parseMavenCoordinates(this.getEndpoint().getDefaultCoordinates());
                    map.put("classLoader", classLoader);
                    map.put("group", coordinates.getGroupId());
                    map.put("module", coordinates.getArtifactId());
                    map.put("version", coordinates.getVersion());
                    map.put("classifier", coordinates.getClassifier());
                    Grape.grab(map);
                    this.getEndpoint().getComponent().getPatchesRepository().install(this.getEndpoint().getDefaultCoordinates());
                }
                break;
            }
            case listPatches: {
                List<String> patches = this.getEndpoint().getComponent().getPatchesRepository().listPatches();
                exchange.getIn().setBody(patches);
                break;
            }
            case clearPatches: {
                this.getEndpoint().getComponent().getPatchesRepository().clear();
                break;
            }
        }
    }

    @Override
    public GrapeEndpoint getEndpoint() {
        return (GrapeEndpoint)super.getEndpoint();
    }
}

