/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grape;

import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import org.apache.camel.component.grape.PatchesRepository;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;

public class FilePatchesRepository
implements PatchesRepository {
    private final File repository;

    public FilePatchesRepository() {
        this(Paths.get(SystemUtils.getUserHome().getAbsolutePath(), ".camel", "patches").toFile());
    }

    public FilePatchesRepository(File repository) {
        try {
            if (!repository.exists()) {
                if (repository.getParentFile() != null) {
                    repository.getParentFile().mkdirs();
                }
                repository.createNewFile();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.repository = repository;
    }

    @Override
    public void install(String coordinates) {
        try {
            FileUtils.writeStringToFile(this.repository, coordinates + "\n", StandardCharsets.UTF_8.name(), true);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public List<String> listPatches() {
        List<String> list;
        FileReader reader = new FileReader(this.repository);
        try {
            list = IOUtils.readLines(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        reader.close();
        return list;
    }

    @Override
    public void clear() {
        try {
            this.repository.delete();
            this.repository.createNewFile();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

