/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.graphql;

import java.net.URI;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.graphql.GraphqlEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.json.JsonObject;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class GraphqlProducer
extends DefaultAsyncProducer {
    public GraphqlProducer(GraphqlEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public GraphqlEndpoint getEndpoint() {
        return (GraphqlEndpoint)super.getEndpoint();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            CloseableHttpClient httpClient = this.getEndpoint().getHttpclient();
            URI httpUri = this.getEndpoint().getHttpUri();
            String requestBody = GraphqlProducer.buildRequestBody(this.getQuery(exchange), this.getEndpoint().getOperationName(), this.getVariables(exchange));
            StringEntity requestEntity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
            HttpPost httpPost = new HttpPost(httpUri);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Accept-Encoding", "gzip");
            httpPost.setEntity(requestEntity);
            String responseContent = httpClient.execute((ClassicHttpRequest)httpPost, response -> EntityUtils.toString(response.getEntity()));
            exchange.getMessage().setBody(responseContent);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    protected static String buildRequestBody(String query, String operationName, JsonObject variables) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("query", query);
        jsonObject.put("operationName", operationName);
        jsonObject.put("variables", variables != null ? variables : new JsonObject());
        return jsonObject.toJson();
    }

    private String getQuery(Exchange exchange) throws InvalidPayloadException {
        String query = null;
        query = this.getEndpoint().getQuery() != null ? this.getEndpoint().getQuery() : (this.getEndpoint().getQueryHeader() != null ? exchange.getIn().getHeader(this.getEndpoint().getQueryHeader(), String.class) : exchange.getIn().getMandatoryBody(String.class));
        return query;
    }

    private JsonObject getVariables(Exchange exchange) {
        JsonObject variables = null;
        if (this.getEndpoint().getVariables() != null) {
            variables = this.getEndpoint().getVariables();
        } else if (this.getEndpoint().getVariablesHeader() != null) {
            variables = exchange.getIn().getHeader(this.getEndpoint().getVariablesHeader(), JsonObject.class);
        } else if (exchange.getIn().getBody() instanceof JsonObject) {
            variables = exchange.getIn().getBody(JsonObject.class);
        }
        return variables;
    }
}

