/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.graphql;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.graphql.GraphqlEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.URISupport;

@Component(value="graphql")
public class GraphqlComponent
extends DefaultComponent {
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GraphqlEndpoint endpoint = new GraphqlEndpoint(uri, this);
        endpoint.setHttpUri(new URI(remaining));
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    @Override
    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        GraphqlEndpoint graphqlEndpoint = (GraphqlEndpoint)endpoint;
        if (!parameters.isEmpty()) {
            URI httpUri = URISupport.createRemainingURI(graphqlEndpoint.getHttpUri(), parameters);
            graphqlEndpoint.setHttpUri(httpUri);
        }
    }
}

